/* Copyright (c) 1998 John E. Davis
 * This file is part of the S-Lang library.
 *
 * You may distribute under the terms of either the GNU General Public
 * License or the Perl Artistic License.
 */
#include "config.h"
#include "sl-feat.h"

#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#include "slang.h"
#include "_slang.h"

typedef struct _SLAssoc_Array_Element_Type
{
   char *str_index;
   SLang_Object_Type value;
   struct _SLAssoc_Array_Element_Type *next;
   unsigned long hash;
}
_SLAssoc_Array_Element_Type;

typedef struct
{
#define MAX_HASH_TABLE_SIZE 499
   _SLAssoc_Array_Element_Type elements[MAX_HASH_TABLE_SIZE];
   unsigned int num_elements;
}
_SLang_Assoc_Array_Type;

