/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPSchemaElement;

public class LDAPAttributeSchema
extends LDAPSchemaElement {
    protected int syntax = 0;
    private boolean single = false;

    protected LDAPAttributeSchema() {
    }

    public LDAPAttributeSchema(String string, String string2, String string3, int n, boolean bl) {
        super(string, string2, string3);
        this.attrName = "attributetypes";
        this.syntax = n;
        this.single = bl;
    }

    public LDAPAttributeSchema(String string) {
        this.attrName = "attributetypes";
        string.trim();
        int n = string.length();
        string = string.substring(2, n - 1);
        n = string.length();
        int n2 = string.indexOf(32);
        this.oid = string.substring(0, n2);
        char[] cArray = new char[n];
        string = string.substring(n2 + 1, n);
        n = string.length();
        string.getChars(0, n, cArray, 0);
        n2 = 0;
        n = cArray.length;
        while (n2 < n) {
            String string2 = "";
            while (cArray[n2] == ' ') {
                ++n2;
            }
            int n3 = n2 + 1;
            while (n3 < n && cArray[n3] != ' ') {
                ++n3;
            }
            if (n2 < n && n3 < n) {
                string2 = new String(cArray, n2, n3 - n2);
                n2 = n3;
                if (string2.equalsIgnoreCase("SINGLE-VALUE")) {
                    this.single = true;
                    continue;
                }
            } else {
                n2 = n;
            }
            while (n2 < n && cArray[n2] != '\'') {
                ++n2;
            }
            n3 = n2 + 1;
            while (n3 < n && cArray[n3] != '\'') {
                ++n3;
            }
            if (n2 >= n3 || n3 >= n) continue;
            String string3 = new String(cArray, n2 + 1, n3 - n2 - 1);
            n2 = n3 + 1;
            if (string2.equalsIgnoreCase("NAME")) {
                this.name = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("DESC")) {
                this.description = string3;
                continue;
            }
            if (!string2.equalsIgnoreCase("SYNTAX")) continue;
            this.syntax = this.syntaxCheck(string3);
        }
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean isSingleValued() {
        return this.single;
    }

    protected String internalSyntaxToString() {
        String string = this.syntax == 1 ? "1.3.6.1.4.1.1466.115.121.1.15" : (this.syntax == 2 ? "1.3.6.1.4.1.1466.115.121.1.5" : (this.syntax == 4 ? "1.3.6.1.4.1.1466.115.121.1.26" : (this.syntax == 3 ? "1.3.6.1.4.1.1466.115.121.1.50" : (this.syntax == 5 ? "1.3.6.1.4.1.1466.115.121.1.12" : (this.syntax == 6 ? "1.3.6.1.4.1.1466.115.121.1.27" : "unknown")))));
        return string;
    }

    public String getValue() {
        String string = "( " + this.oid + " NAME '" + this.name + "' DESC '" + this.description + "' SYNTAX '";
        string = String.valueOf(string) + this.internalSyntaxToString();
        string = String.valueOf(string) + "' ";
        if (this.single) {
            string = String.valueOf(string) + "SINGLE-VALUE ";
        }
        string = String.valueOf(string) + ')';
        return string;
    }

    protected String syntaxToString() {
        String string = this.syntax == 1 ? "case-insensitive string" : (this.syntax == 2 ? "binary" : (this.syntax == 6 ? "integer" : (this.syntax == 4 ? "case-exact string" : (this.syntax == 3 ? "telephone" : (this.syntax == 5 ? "distinguished name" : "unknown")))));
        return string;
    }

    public String toString() {
        String string = "Name: " + this.name + "; OID: " + this.oid + "; Type: ";
        string = String.valueOf(string) + this.syntaxToString();
        string = String.valueOf(string) + "; Description: " + this.description + "; ";
        string = this.single ? String.valueOf(string) + "single-valued" : String.valueOf(string) + "multi-valued";
        return string;
    }

    protected int syntaxCheck(String string) {
        int n = 0;
        if (string.equals("1.3.6.1.4.1.1466.115.121.1.15")) {
            n = 1;
        } else if (string.equals("1.3.6.1.4.1.1466.115.121.1.5")) {
            n = 2;
        } else if (string.equals("1.3.6.1.4.1.1466.115.121.1.26")) {
            n = 4;
        } else if (string.equals("1.3.6.1.4.1.1466.115.121.1.27")) {
            n = 6;
        } else if (string.equals("1.3.6.1.4.1.1466.115.121.1.50")) {
            n = 3;
        } else if (string.equals("1.3.6.1.4.1.1466.115.121.1.12")) {
            n = 5;
        }
        return n;
    }
}

