/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import sun.rmi.transport.Connection;
import sun.rmi.transport.ConnectionInputStream;
import sun.rmi.transport.ConnectionOutputStream;
import sun.rmi.transport.Transport;

public class StreamRemoteCall
implements RemoteCall {
    private ConnectionInputStream in;
    private ConnectionOutputStream out;
    private Connection conn;
    private boolean resultStarted = false;

    public StreamRemoteCall(Connection connection) {
        this.conn = connection;
    }

    public StreamRemoteCall(Connection connection, ObjID objID, int n, long l) throws RemoteException {
        try {
            this.conn = connection;
            if (Transport.logLevel >= 20) {
                LogStream.log("transport").println("StreamRemoteCall.<init>: write remote call header...");
            }
            DataOutputStream dataOutputStream = new DataOutputStream(this.conn.getOutputStream());
            dataOutputStream.writeByte(80);
            this.getOutputStream();
            objID.write(this.out);
            this.out.writeInt(n);
            this.out.writeLong(l);
            return;
        }
        catch (IOException iOException) {
            throw new MarshalException("Error marshaling call header", iOException);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public ObjectOutput getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    private ObjectOutput getOutputStream(boolean bl) throws IOException {
        if (this.out == null) {
            if (Transport.logLevel >= 20) {
                LogStream.log("transport").println("StreamRemoteCall.getOutputStream");
            }
            this.out = new ConnectionOutputStream(this.conn.getOutputStream(), bl);
        }
        return this.out;
    }

    public void releaseOutputStream() throws IOException {
        try {
            if (this.out != null) {
                this.out.flush();
                this.out.done(this.conn);
            }
            this.conn.releaseOutputStream();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.out = null;
            throw throwable;
        }
        Object var2_1 = null;
        this.out = null;
    }

    public ObjectInput getInputStream() throws IOException {
        if (this.in == null) {
            if (Transport.logLevel >= 20) {
                LogStream.log("transport").println("StreamRemoteCall.getInputStream");
            }
            this.in = new ConnectionInputStream(this.conn.getInputStream());
        }
        return this.in;
    }

    public void releaseInputStream() throws IOException {
        try {
            if (this.in != null) {
                this.in.registerRefs();
                this.in.done(this.conn);
            }
            this.conn.releaseInputStream();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.in = null;
            throw throwable;
        }
        Object var2_1 = null;
        this.in = null;
    }

    public ObjectOutput getResultStream(boolean bl) throws IOException, StreamCorruptedException {
        if (this.resultStarted) {
            throw new StreamCorruptedException("result already in progress");
        }
        this.resultStarted = true;
        DataOutputStream dataOutputStream = new DataOutputStream(this.conn.getOutputStream());
        dataOutputStream.writeByte(81);
        this.getOutputStream(true);
        if (bl) {
            this.out.writeByte(1);
        } else {
            this.out.writeByte(2);
        }
        this.out.writeID();
        return this.out;
    }

    public void executeCall() throws Exception {
        byte by;
        Object object;
        try {
            this.releaseOutputStream();
            object = new DataInputStream(this.conn.getInputStream());
            byte by2 = ((DataInputStream)object).readByte();
            if (by2 != 81) {
                if (Transport.logLevel >= 10) {
                    LogStream.log("transport").println("StreamRemoteCall.executeCall: transport return code invalid: " + by2);
                }
                throw new UnmarshalException("Transport return code invalid");
            }
            this.getInputStream();
            by = this.in.readByte();
            this.in.readID();
        }
        catch (UnmarshalException unmarshalException) {
            throw unmarshalException;
        }
        catch (IOException iOException) {
            throw new UnmarshalException("Error unmarshaling return header");
        }
        switch (by) {
            case 2: {
                try {
                    object = this.in.readObject();
                }
                catch (Exception exception) {
                    throw new UnmarshalException("Error unmarshaling return", exception);
                }
                if (object instanceof Exception) {
                    throw (Exception)object;
                }
                throw new UnmarshalException("Return type not Exception");
            }
            default: {
                if (Transport.logLevel >= 10) {
                    LogStream.log("transport").println("StreamRemoteCall.executeCall: return code invalid: " + by);
                }
                throw new UnmarshalException("Return code invalid");
            }
            case 1: 
        }
    }

    public void done() throws IOException {
        this.releaseInputStream();
    }
}

