/*
** apple.h:	cut down macfile.h from CAP distribution
*/
#ifndef _APPLE_H

#include <sys/param.h>
#include <stdio.h>

#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif /* MIN */

#define CT_SIZE		4			/* Size of type/creator */
#define NUMMAP		512			/* initial number of maps */
#define BLANK		"    "			/* blank type/creator */
#define DEFMATCH	"*"			/* default mapping extension */
#define FINDERINFO	".finderinfo"		/* finder info directory */

typedef struct {
	char		*extn;			/* filename extension */
	int		elen;			/* length of extension */
	char		type[CT_SIZE+1];	/* extension type */
	char		creator[CT_SIZE+1];	/* extension creator */
	unsigned short	fdflags;		/* finder flags */
} afpmap;

/* from "data.h" - libhfs routines */
unsigned long d_toutime(unsigned long);
long d_getl(unsigned char *);
short d_getw(unsigned char *);

/*
 * taken from the CAP distribution:
 * macfile.h - header file with Macintosh file definitions 
 *
 * AppleTalk package for UNIX (4.2 BSD).
 *
 * Copyright (c) 1986, 1987, 1988 by The Trustees of Columbia University in the
 * City of New York.
 *
 * Edit History:
 *
 *  Sept 1987	Created by Charlie
 *
 */


#ifndef USE_MAC_DATES
#define	USE_MAC_DATES
#endif /* USE_MAC_DATES */

typedef unsigned char byte;
typedef char sbyte;
typedef unsigned short word;
typedef short sword;
typedef unsigned long dword;
typedef long sdword;

#define MAXCLEN 199		/* max size of a comment string */
#define FINFOLEN 32		/* Finder info is 32 bytes */
#define MAXMACFLEN 31		/* max Mac file name length */

typedef struct {
  /* base finder information */
  byte fdType[4];		/* File type [4]*/
  byte fdCreator[4];		/* File creator [8]*/
  word fdFlags;			/* Finder flags [10]*/
  word fdLocation[2];		/* File's location [14] */
  word fdFldr;			/* File's window [16] */
  /* extended finder information */
  word fdIconID;		/* Icon ID [18] */
  word fdUnused[4];		/* Unused [26] */
  word fdComment;		/* Comment ID [28] */
  dword fdPutAway;		/* Home directory ID [32] */
  word fi_attr;			/* attributes */
#define FI_MAGIC1 255
  byte fi_magic1;		/* was: length of comment */
#define FI_VERSION 0x10		/* version major 1, minor 0 */
				/* if we have more than 8 versions wer're */
				/* doiong something wrong anyway */
  byte fi_version;		/* version number */
#define FI_MAGIC 0xda
  byte fi_magic;		/* magic word check */
  byte fi_bitmap;		/* bitmap of included info */
#define FI_BM_SHORTFILENAME 0x1	/* is this included? */
#define FI_BM_MACINTOSHFILENAME 0x2 /* is this included? */
  byte fi_shortfilename[12+1];	/* possible short file name */
  byte fi_macfilename[32+1];	/* possible macintosh file name */
  byte fi_comln;		/* comment length */
  byte fi_comnt[MAXCLEN+1];	/* comment string */
#ifdef USE_MAC_DATES
  byte fi_datemagic;		/* sanity check */
#define FI_MDATE 0x01		/* mtime & utime are valid */
#define FI_CDATE 0x02		/* ctime is valid */
  byte fi_datevalid;		/* validity flags */
  byte fi_ctime[4];		/* mac file create time */
  byte fi_mtime[4];		/* mac file modify time */
  byte fi_utime[4];		/* (real) time mtime was set */
#endif /* USE_MAC_DATES */
} FileInfo;

/* Atribute flags */
#define FI_ATTR_SETCLEAR 0x8000 /* set-clear attributes */
#define FI_ATTR_READONLY 0x20	/* file is read-only */
#define FI_ATTR_ROPEN 0x10	/* resource fork in use */
#define FI_ATTR_DOPEN 0x80	/* data fork in use */
#define FI_ATTR_MUSER 0x2	/* multi-user */
#define FI_ATTR_INVISIBLE 0x1	/* invisible */

/**** MAC STUFF *****/

/* Flags */
#define FNDR_fOnDesk 0x1
#define FNDR_fHasBundle 0x2000
#define FNDR_fInvisible 0x4000
/* locations */
#define FNDR_fTrash -3	/* File in Trash */
#define FNDR_fDesktop -2	/* File on desktop */
#define FNDR_fDisk 0	/* File in disk window */

#define _APPLE_H
#endif /* _APPLE_H */
