/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Range
implements Codable {
    private static Range nullRange;
    public int index;
    public int length;
    static final String INDEX_KEY = "index";
    static final String LENGTH_KEY = "length";

    public static Range nullRange() {
        if (nullRange == null) {
            nullRange = new Range(-1, 0);
        }
        return nullRange;
    }

    public static Range rangeFromIntersection(Range range, Range range2) {
        Range range3 = new Range(range);
        range3.intersectWith(range2);
        return range3;
    }

    public static Range rangeFromUnion(Range range, Range range2) {
        Range range3 = new Range(range);
        range3.unionWith(range2);
        return range3;
    }

    public static Range rangeFromIndices(int n, int n2) {
        if (n < n2) {
            return new Range(n, n2 - n);
        }
        return new Range(n2, n - n2);
    }

    public Range() {
        this.index = Range.nullRange().index;
        this.length = Range.nullRange().length;
    }

    public Range(int n, int n2) {
        this.index = n;
        this.length = n2;
    }

    public Range(Range range) {
        this.index = range.index;
        this.length = range.length;
    }

    public int index() {
        return this.index;
    }

    public int length() {
        return this.length;
    }

    public int lastIndex() {
        return this.index + this.length - 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        return range.index == this.index && range.length == this.length;
    }

    public void unionWith(Range range) {
        this.unionWith(range.index, range.length);
    }

    public void unionWith(int n, int n2) {
        if (this.index == Range.nullRange().index) {
            this.index = n;
            this.length = n2;
            return;
        }
        if (n == Range.nullRange().index) {
            return;
        }
        int n3 = this.index < n ? this.index : n;
        int n4 = this.index + this.length > n + n2 ? this.index + this.length : n + n2;
        this.index = n3;
        this.length = n4 - n3;
    }

    public void intersectWith(Range range) {
        this.intersectWith(range.index, range.length);
    }

    public void intersectWith(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.index < n) {
            n6 = this.index;
            n5 = this.length;
            n4 = n;
            n3 = n2;
        } else {
            n6 = n;
            n5 = n2;
            n4 = this.index;
            n3 = this.length;
        }
        if (n6 + n5 <= n4) {
            this.index = Range.nullRange().index;
            this.length = Range.nullRange().length;
            return;
        }
        this.index = n4;
        if (n4 + n3 > n6 + n5) {
            this.length = n6 + n5 - n4;
            return;
        }
        this.length = n3;
    }

    public String toString() {
        if (this.isNullRange()) {
            return "Null range";
        }
        return "(" + this.index + ", " + this.length + ")";
    }

    public boolean intersects(Range range) {
        int n = this.index;
        int n2 = this.length;
        this.intersectWith(range);
        boolean bl = this.index != Range.nullRange().index;
        this.index = n;
        this.length = n2;
        return bl;
    }

    public boolean intersects(int n, int n2) {
        int n3 = this.index;
        int n4 = this.length;
        this.intersectWith(n, n2);
        boolean bl = this.index != Range.nullRange().index;
        this.index = n3;
        this.length = n4;
        return bl;
    }

    public boolean isNullRange() {
        return this.index == Range.nullRange().index;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean contains(int n) {
        return n >= this.index && n < this.index + this.length;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.Range", 1);
        classInfo.addField(INDEX_KEY, (byte)8);
        classInfo.addField(LENGTH_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(INDEX_KEY, this.index);
        encoder.encodeInt(LENGTH_KEY, this.length);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.index = decoder.decodeInt(INDEX_KEY);
        this.length = decoder.decodeInt(LENGTH_KEY);
    }

    public void finishDecoding() throws CodingException {
    }
}

