/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.FormattingSerializer;
import netscape.util.HashtableEnumerator;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Hashtable
implements Cloneable,
Codable {
    static final int A = -1640531527;
    static final int EMPTY = 0;
    static final int REMOVED = 1;
    static final int DEFAULT = 2;
    static final String keysField = "keys";
    static final String elementsField = "elements";
    int count;
    int totalCount;
    int shift = 30;
    int capacity;
    int indexMask;
    int[] hashCodes;
    Object[] keys;
    Object[] elements;

    public Hashtable() {
    }

    public Hashtable(int n) {
        this();
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be > 0");
        }
        this.grow(n);
    }

    public Object clone() {
        Hashtable hashtable;
        try {
            hashtable = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Error in clone(). This shouldn't happen.");
        }
        if (this.count == 0) {
            hashtable.shift = 30;
            hashtable.totalCount = 0;
            hashtable.capacity = 0;
            hashtable.indexMask = 0;
            hashtable.hashCodes = null;
            hashtable.keys = null;
            hashtable.elements = null;
            return hashtable;
        }
        int n = this.hashCodes.length;
        hashtable.hashCodes = new int[n];
        hashtable.keys = new Object[n];
        hashtable.elements = new Object[n];
        System.arraycopy(this.hashCodes, 0, hashtable.hashCodes, 0, n);
        System.arraycopy(this.keys, 0, hashtable.keys, 0, n);
        System.arraycopy(this.elements, 0, hashtable.elements, 0, n);
        return hashtable;
    }

    public int count() {
        return this.count;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new HashtableEnumerator(this, true);
    }

    public Enumeration elements() {
        return new HashtableEnumerator(this, false);
    }

    public Vector keysVector() {
        if (this.count == 0) {
            return new Vector();
        }
        Vector vector = new Vector(this.count);
        int n = 0;
        int n2 = 0;
        while (n2 < this.keys.length && n < this.count) {
            Object object = this.keys[n2];
            if (object != null) {
                vector.addElement(object);
                ++n;
            }
            ++n2;
        }
        return vector;
    }

    public Vector elementsVector() {
        if (this.count == 0) {
            return new Vector();
        }
        Vector vector = new Vector(this.count);
        int n = 0;
        int n2 = 0;
        while (n2 < this.elements.length && n < this.count) {
            Object object = this.elements[n2];
            if (object != null) {
                vector.addElement(object);
                ++n;
            }
            ++n2;
        }
        return vector;
    }

    public Object[] keysArray() {
        if (this.count == 0) {
            return null;
        }
        Object[] objectArray = new Object[this.count];
        int n = 0;
        int n2 = 0;
        while (n2 < this.keys.length && n < this.count) {
            Object object = this.keys[n2];
            if (object != null) {
                objectArray[n++] = object;
            }
            ++n2;
        }
        return objectArray;
    }

    public Object[] elementsArray() {
        if (this.count == 0) {
            return null;
        }
        Object[] objectArray = new Object[this.count];
        int n = 0;
        int n2 = 0;
        while (n2 < this.elements.length && n < this.count) {
            Object object = this.elements[n2];
            if (object != null) {
                objectArray[n++] = object;
            }
            ++n2;
        }
        return objectArray;
    }

    public boolean contains(Object object) {
        if (this.count == 0) {
            return false;
        }
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.elements == null) {
            return false;
        }
        int n = 0;
        while (n < this.elements.length) {
            Object object2 = this.elements[n];
            if (object2 != null && object.equals(object2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object object) {
        if (this.count == 0) {
            return null;
        }
        return this.elements[this.tableIndexFor(object, this.hash(object))];
    }

    public Object remove(Object object) {
        if (this.count == 0) {
            return null;
        }
        int n = this.tableIndexFor(object, this.hash(object));
        Object object2 = this.elements[n];
        if (object2 == null) {
            return null;
        }
        --this.count;
        this.hashCodes[n] = 1;
        this.keys[n] = null;
        this.elements[n] = null;
        return object2;
    }

    public Object put(Object object, Object object2) {
        int n;
        int n2;
        Object object3;
        if (object2 == null) {
            throw new NullPointerException();
        }
        if (this.hashCodes == null) {
            this.grow();
        }
        if ((object3 = this.elements[n2 = this.tableIndexFor(object, n = this.hash(object))]) == null) {
            if (this.hashCodes[n2] == 0) {
                if (this.totalCount >= this.capacity) {
                    this.grow();
                    return this.put(object, object2);
                }
                ++this.totalCount;
            }
            ++this.count;
        }
        this.hashCodes[n2] = n;
        this.keys[n2] = object;
        this.elements[n2] = object2;
        return object3;
    }

    private int hash(Object object) {
        int n = object.hashCode();
        if (n == 0 || n == 1) {
            n = 2;
        }
        return n;
    }

    private int tableIndexFor(Object object, int n) {
        int n2;
        int n3 = n * -1640531527;
        int n4 = n3 >>> this.shift;
        int n5 = this.hashCodes[n4];
        if (n5 == n) {
            if (object.equals(this.keys[n4])) {
                return n4;
            }
            n2 = -1;
        } else {
            if (n5 == 0) {
                return n4;
            }
            n2 = n5 == 1 ? n4 : -1;
        }
        int n6 = n3 >>> 2 * this.shift - 32 & this.indexMask | 1;
        int n7 = 1;
        do {
            ++n7;
            n5 = this.hashCodes[n4 = n4 + n6 & this.indexMask];
            if (n5 == n) {
                if (!object.equals(this.keys[n4])) continue;
                return n4;
            }
            if (n5 == 0) {
                if (n2 < 0) {
                    return n4;
                }
                return n2;
            }
            if (n5 != 1 || n2 != -1) continue;
            n2 = n4;
        } while (n7 <= this.totalCount);
        throw new InconsistencyException("Hashtable overflow");
    }

    private void grow(int n) {
        int n2 = n * 4 / 3;
        int n3 = 3;
        while (1 << n3 < n2) {
            ++n3;
        }
        this.shift = 32 - n3 + 1;
        this.grow();
    }

    private void grow() {
        --this.shift;
        int n = 32 - this.shift;
        this.indexMask = (1 << n) - 1;
        this.capacity = 3 * (1 << n) / 4;
        int[] nArray = this.hashCodes;
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.elements;
        this.hashCodes = new int[1 << n];
        this.keys = new Object[1 << n];
        this.elements = new Object[1 << n];
        this.totalCount = 0;
        if (this.count > 0) {
            this.count = 0;
            int n2 = 0;
            while (n2 < nArray.length) {
                Object object = objectArray[n2];
                if (object != null) {
                    int n3 = nArray[n2];
                    int n4 = this.tableIndexFor(object, n3);
                    this.hashCodes[n4] = n3;
                    this.keys[n4] = object;
                    this.elements[n4] = objectArray2[n2];
                    ++this.count;
                    ++this.totalCount;
                }
                ++n2;
            }
        }
    }

    public void clear() {
        if (this.hashCodes == null) {
            return;
        }
        int n = 0;
        while (n < this.hashCodes.length) {
            this.hashCodes[n] = 0;
            this.keys[n] = null;
            this.elements[n] = null;
            ++n;
        }
        this.count = 0;
        this.totalCount = 0;
    }

    public String toString() {
        return FormattingSerializer.serializeObject((Object)this);
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.util.Hashtable", 1);
        classInfo.addField(keysField, (byte)19);
        classInfo.addField(elementsField, (byte)19);
    }

    public void encode(Encoder encoder) throws CodingException {
        if (this.count == 0) {
            return;
        }
        Object[] objectArray = this.keysArray();
        Object[] objectArray2 = this.elementsArray();
        encoder.encodeObjectArray(keysField, objectArray, 0, objectArray.length);
        encoder.encodeObjectArray(elementsField, objectArray2, 0, objectArray2.length);
    }

    public void decode(Decoder decoder) throws CodingException {
        Object[] objectArray = decoder.decodeObjectArray(keysField);
        Object[] objectArray2 = decoder.decodeObjectArray(elementsField);
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        this.grow(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            this.put(objectArray[n], objectArray2[n]);
            ++n;
        }
    }

    public void finishDecoding() throws CodingException {
    }
}

