/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import netscape.util.Vector;

public class CompactInputStream
extends InputStream {
    static final int INVALID_BUFFER_COUNT = 8;
    InputStream in;
    int booleanCount = 8;
    int booleanBuffer;
    Vector stringVector = new Vector(128);

    public CompactInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int read() throws IOException {
        this.booleanCount = 8;
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        this.booleanCount = 8;
        return this.in.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.booleanCount = 8;
        return this.in.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        if (l > 0L) {
            this.booleanCount = 8;
            return this.in.skip(l);
        }
        return l;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.booleanCount = 8;
        this.in.close();
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.booleanCount = 8;
        InputStream inputStream = this.in;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public int skipBytes(int n) throws IOException {
        int n2 = n;
        while (n > 0) {
            n = (int)((long)n - this.skip(n));
        }
        return n2;
    }

    public boolean readCompactBoolean() throws IOException {
        int n = this.booleanBuffer;
        int n2 = this.booleanCount;
        if (n2 >= 8) {
            n = this.in.read();
            if (n < 0) {
                throw new EOFException();
            }
            n2 = 0;
        }
        boolean bl = (n & 1 << n2) != 0;
        this.booleanBuffer = n;
        this.booleanCount = ++n2;
        return bl;
    }

    public boolean readBoolean() throws IOException {
        this.booleanCount = 8;
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        this.booleanCount = 8;
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        this.booleanCount = 8;
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        int n;
        this.booleanCount = 8;
        InputStream inputStream = this.in;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public int readUnsignedShort() throws IOException {
        int n;
        this.booleanCount = 8;
        InputStream inputStream = this.in;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public char readChar() throws IOException {
        int n;
        this.booleanCount = 8;
        InputStream inputStream = this.in;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    public int readCompactInt() throws IOException {
        this.booleanCount = 8;
        InputStream inputStream = this.in;
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        if (n == 64) {
            return Integer.MIN_VALUE;
        }
        boolean bl = (n & 0x40) != 0;
        int n2 = n & 0x3F;
        if ((n & 0x80) != 0) {
            n = inputStream.read();
            if (n < 0) {
                throw new EOFException();
            }
            n2 |= (n & 0x7F) << 6;
            if ((n & 0x80) != 0) {
                n = inputStream.read();
                if (n < 0) {
                    throw new EOFException();
                }
                n2 |= (n & 0x7F) << 13;
                if ((n & 0x80) != 0) {
                    n = inputStream.read();
                    if (n < 0) {
                        throw new EOFException();
                    }
                    n2 |= (n & 0x7F) << 20;
                    if ((n & 0x80) != 0) {
                        n = inputStream.read();
                        if (n < 0) {
                            throw new EOFException();
                        }
                        n2 |= (n & 0x7F) << 27;
                    }
                }
            }
        }
        if (bl) {
            n2 = -n2;
        }
        return n2;
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        this.booleanCount = 8;
        InputStream inputStream = this.in;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readCompactUTF() throws IOException {
        int n = this.readCompactInt();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return "";
        }
        if (n < 0) {
            String string = this.readUTFBytes(-n);
            this.stringVector.addElement(string);
            return string;
        }
        return (String)this.stringVector.elementAt(n - 2);
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        if (n == 65535) {
            return null;
        }
        return this.readUTFBytes(n);
    }

    private final String readUTFBytes(int n) throws IOException {
        this.booleanCount = 8;
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = this.readUnsignedByte();
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n3++] = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = this.readUnsignedByte();
                    if ((n5 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | n5 & 0x3F);
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = this.readUnsignedByte();
                    int n6 = this.readUnsignedByte();
                    if ((n5 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | n6 & 0x3F);
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(cArray, 0, n3);
    }
}

