/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Frame;
import java.awt.List;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;

public abstract class AWTEvent
extends EventObject {
    private transient int data;
    protected int id;
    protected boolean consumed = false;
    public static final long COMPONENT_EVENT_MASK = 1L;
    public static final long CONTAINER_EVENT_MASK = 2L;
    public static final long FOCUS_EVENT_MASK = 4L;
    public static final long KEY_EVENT_MASK = 8L;
    public static final long MOUSE_EVENT_MASK = 16L;
    public static final long MOUSE_MOTION_EVENT_MASK = 32L;
    public static final long WINDOW_EVENT_MASK = 64L;
    public static final long ACTION_EVENT_MASK = 128L;
    public static final long ADJUSTMENT_EVENT_MASK = 256L;
    public static final long ITEM_EVENT_MASK = 512L;
    public static final long TEXT_EVENT_MASK = 1024L;
    public static final int RESERVED_ID_MAX = 1999;
    private static final long serialVersionUID = -1825314779160409405L;

    public AWTEvent(Event event) {
        this(event.target, event.id);
    }

    public AWTEvent(Object object, int n) {
        super(object);
        this.id = n;
        switch (n) {
            case 601: 
            case 701: 
            case 900: 
            case 1001: {
                this.consumed = true;
                return;
            }
        }
    }

    public int getID() {
        return this.id;
    }

    public String toString() {
        String string = null;
        if (this.source instanceof Component) {
            string = ((Component)this.source).getName();
        } else if (this.source instanceof MenuComponent) {
            string = ((MenuComponent)this.source).getName();
        }
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "] on " + (string != null ? string : this.source);
    }

    public String paramString() {
        return "";
    }

    protected void consume() {
        switch (this.id) {
            case 401: 
            case 402: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                this.consumed = true;
                return;
            }
        }
    }

    protected boolean isConsumed() {
        return this.consumed;
    }

    Event convertToOld() {
        Object object = this.getSource();
        int n = this.id;
        switch (this.id) {
            case 401: 
            case 402: {
                int n2;
                KeyEvent keyEvent = (KeyEvent)this;
                if (keyEvent.isActionKey()) {
                    int n3 = n = this.id == 401 ? 403 : 404;
                }
                if ((n2 = keyEvent.getKeyCode()) == 16 || n2 == 17 || n2 == 18) {
                    return null;
                }
                return new Event(object, keyEvent.getWhen(), n, 0, 0, Event.getOldEventKey(keyEvent), keyEvent.getModifiers() & 0xFFFFFFEF);
            }
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                MouseEvent mouseEvent = (MouseEvent)this;
                Event event = new Event(object, mouseEvent.getWhen(), n, mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getModifiers() & 0xFFFFFFEF);
                event.clickCount = mouseEvent.getClickCount();
                return event;
            }
            case 1004: {
                return new Event(object, 1004, null);
            }
            case 1005: {
                return new Event(object, 1005, null);
            }
            case 201: 
            case 203: 
            case 204: {
                return new Event(object, n, null);
            }
            case 100: {
                if (!(object instanceof Frame) && !(object instanceof Dialog)) break;
                Point point = ((Component)object).getLocation();
                return new Event(object, 0L, 205, point.x, point.y, 0, 0);
            }
            case 1001: {
                ActionEvent actionEvent = (ActionEvent)this;
                String string = object instanceof Button ? ((Button)object).getLabel() : (object instanceof MenuItem ? ((MenuItem)object).getLabel() : actionEvent.getActionCommand());
                return new Event(object, 0L, n, 0, 0, 0, actionEvent.getModifiers(), string);
            }
            case 701: {
                Object object2;
                ItemEvent itemEvent = (ItemEvent)this;
                if (object instanceof List) {
                    n = itemEvent.getStateChange() == 1 ? 701 : 702;
                    object2 = itemEvent.getItem();
                } else {
                    n = 1001;
                    object2 = object instanceof Choice || object instanceof CheckboxMenuItem ? itemEvent.getItem() : new Boolean(itemEvent.getStateChange() == 1);
                }
                return new Event(object, n, object2);
            }
            case 601: {
                AdjustmentEvent adjustmentEvent = (AdjustmentEvent)this;
                switch (adjustmentEvent.getAdjustmentType()) {
                    case 1: {
                        n = 602;
                        break;
                    }
                    case 2: {
                        n = 601;
                        break;
                    }
                    case 4: {
                        n = 604;
                        break;
                    }
                    case 3: {
                        n = 603;
                        break;
                    }
                    case 5: {
                        n = 605;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return new Event(object, n, new Integer(adjustmentEvent.getValue()));
            }
        }
        return null;
    }

    void setSource(Object object) {
        if (!(this instanceof KeyEvent)) {
            throw new ClassCastException();
        }
        this.source = object;
    }
}

