/* vi:set ts=8 sts=0 sw=8:
 * $Id: toolbar.h,v 1.9 1999/01/18 20:08:09 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __TOOLBAR_H__
#define __TOOLBAR_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <gtk/gtk.h>
#include "win.h"

typedef struct {
	char *text;
	char *tooltip_text;
	char *tooltip_private_text;
	char *icon;
	GtkSignalFunc callback;
	gpointer cbdata;
} toolbar_data_t;

extern void tb_pic_only(GtkWidget *w, gpointer cbdata);
extern void tb_pic_text(GtkWidget *w, gpointer cbdata);
extern void tb_redraw(void *);
extern void tb_text_only(GtkWidget *w, gpointer cbdata);
extern void tb_toggle(GtkWidget *w, gpointer cbdata);
#ifdef APP_GNP
extern void tb_html_toggle(GtkWidget *wgt, gpointer cbdata);
#endif
extern void tb_ttip_toggle(GtkWidget *w, gpointer cbdata);
extern void toolbar_create(win_t *w, GtkWidget *parent, toolbar_data_t tbdata[],
			   GtkWidget **tb, GtkWidget **tb_h);
#ifdef GTK_HAVE_FEATURES_1_1_0
extern void tb_raised_toggle(GtkWidget *wgt, gpointer cbdata);
#endif


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __TOOLBAR_H__ */
