/* vi:set ts=8 sts=0 sw=8:
 * $Id: prefs.h,v 1.15 1999/01/21 21:11:48 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __PREFS_H__
#define __PREFS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <gtk/gtk.h>
#include "main.h"

/* general/global options and macros */
#define AUTO_INDENT			0x00000001
#define SHOW_TABS			0x00000002
#define SHOW_MSGBAR			0x00000004
#define SHOW_TOOLBAR			0x00000008
#define PIC_TEXT_TOOLBAR		0x00000010
#define TEXT_ONLY_TOOLBAR		0x00000020
#define PIC_ONLY_TOOLBAR		0x00000040
#define SHOW_TOOLTIPS			0x00000080
#define USE_WORDWRAP			0x00000100
#define SAVE_WIN_WIDTH			0x00000200
#define SAVE_WIN_HEIGHT			0x00000400
#define SAVE_WIN_POS			0x00000800
#define USE_MSGBOX			0x00001000
#define SHOW_PRJBAR			0x00002000
#define TOOLBAR_RAISED			0x00004000
#define SHOW_HTML_TOOLBAR		0x00008000

#define DEFAULT_OPTIONS (AUTO_INDENT | SHOW_TABS | SHOW_MSGBAR | \
			SHOW_TOOLBAR | PIC_TEXT_TOOLBAR |SHOW_TOOLTIPS | \
			SAVE_WIN_HEIGHT | USE_MSGBOX)

/* these macros operate on the global variable 'options' */
#define IS_AUTO_INDENT()		(prefs.options1 & AUTO_INDENT)
#define IS_SHOW_TABS()			(prefs.options1 & SHOW_TABS)
#define IS_SHOW_MSGBAR()		(prefs.options1 & SHOW_MSGBAR)
#define IS_SHOW_TOOLBAR()		(prefs.options1 & SHOW_TOOLBAR)
#define IS_TEXT_PIC_TOOLBAR()		(prefs.options1 & PIC_TEXT_TOOLBAR)
#define IS_TEXT_TOOLBAR()		(prefs.options1 & TEXT_ONLY_TOOLBAR)
#define IS_PIC_TOOLBAR()		(prefs.options1 & PIC_ONLY_TOOLBAR)
#define IS_SHOW_TOOLTIPS()		(prefs.options1 & SHOW_TOOLTIPS)
#define IS_USE_WORDWRAP()		(prefs.options1 & USE_WORDWRAP)
#define IS_USE_MSGBOX()			(prefs.options1 & USE_MSGBOX)
#define IS_SAVE_WIN_WIDTH()		(prefs.options1 & SAVE_WIN_WIDTH)
#define IS_SAVE_WIN_HEIGHT()		(prefs.options1 & SAVE_WIN_HEIGHT)
#define IS_SAVE_WIN_POS()		(prefs.options1 & SAVE_WIN_POS)
#define IS_SHOW_PRJBAR()		(prefs.options1 & SHOW_PRJBAR)
#define IS_TOOLBAR_RAISED()		(prefs.options1 & TOOLBAR_RAISED)
#define IS_SHOW_HTML_TOOLBAR()		(prefs.options1 & SHOW_HTML_TOOLBAR)

#define SET_AUTO_INDENT()		(prefs.options1 |= AUTO_INDENT)
#define SET_SHOW_TABS()			(prefs.options1 |= SHOW_TABS)
#define SET_SHOW_MSGBAR()		(prefs.options1 |= SHOW_MSGBAR)
#define SET_SHOW_TOOLBAR()		(prefs.options1 |= SHOW_TOOLBAR)
#define SET_TEXT_ONLY_TOOLBAR()		(prefs.options1 |= TEXT_ONLY_TOOLBAR)
#define SET_PIC_ONLY_TOOLBAR()		(prefs.options1 |= PIC_ONLY_TOOLBAR)
#define SET_PIC_TEXT_TOOLBAR()		(prefs.options1 |= PIC_TEXT_TOOLBAR)
#define SET_SHOW_TOOLTIPS()		(prefs.options1 |= SHOW_TOOLTIPS)
#define SET_USE_WORDWRAP()		(prefs.options1 |= USE_WORDWRAP)
#define SET_USE_MSGBOX()		(prefs.options1 |= USE_MSGBOX)
#define SET_SAVE_WIN_WIDTH()		(prefs.options1 |= SAVE_WIN_WIDTH)
#define SET_SAVE_WIN_HEIGHT()		(prefs.options1 |= SAVE_WIN_HEIGHT)
#define SET_SAVE_WIN_POS()		(prefs.options1 |= SAVE_WIN_POS)
#define SET_SHOW_PRJBAR()		(prefs.options1 |= SHOW_PRJBAR)
#define SET_TOOLBAR_RAISED()		(prefs.options1 |= TOOLBAR_RAISED)
#define SET_SHOW_HTML_TOOLBAR()		(prefs.options1 |= SHOW_HTML_TOOLBAR)

#define CLEAR_AUTO_INDENT()		(prefs.options1 &= ~AUTO_INDENT)
#define CLEAR_SHOW_TABS()		(prefs.options1 &= ~SHOW_TABS)
#define CLEAR_SHOW_MSGBAR()		(prefs.options1 &= ~SHOW_MSGBAR)
#define CLEAR_SHOW_TOOLBAR()		(prefs.options1 &= ~SHOW_TOOLBAR)
#define CLEAR_PIC_TEXT_TOOLBAR()	(prefs.options1 &= ~PIC_TEXT_TOOLBAR)
#define CLEAR_TEXT_ONLY_TOOLBAR()	(prefs.options1 &= ~TEXT_ONLY_TOOLBAR)
#define CLEAR_PIC_ONLY_TOOLBAR()	(prefs.options1 &= ~PIC_ONLY_TOOLBAR)
#define CLEAR_SHOW_TOOLTIPS()		(prefs.options1 &= ~SHOW_TOOLTIPS)
#define CLEAR_USE_WORDWRAP()		(prefs.options1 &= ~USE_WORDWRAP)
#define CLEAR_USE_MSGBOX()		(prefs.options1 &= ~USE_MSGBOX)
#define CLEAR_SAVE_WIN_WIDTH()		(prefs.options1 &= ~SAVE_WIN_WIDTH)
#define CLEAR_SAVE_WIN_HEIGHT()		(prefs.options1 &= ~SAVE_WIN_HEIGHT)
#define CLEAR_SAVE_WIN_POS()		(prefs.options1 &= ~SAVE_WIN_POS)
#define CLEAR_SHOW_PRJBAR()		(prefs.options1 &= ~SHOW_PRJBAR)
#define CLEAR_TOOLBAR_RAISED()		(prefs.options1 &= ~TOOLBAR_RAISED)
#define CLEAR_SHOW_HTML_TOOLBAR()	(prefs.options1 &= ~SHOW_HTML_TOOLBAR)

typedef struct {

	/* bit flag options for various categories */
	long		options1;	/* see above for descriptions */

	/* non user configurable */
	char *		appdir;		/* $HOME/PREFS_DIR/ */

	/* appearance settings (most are bit-flag settings) */
	GtkPositionType	tabpos;		/* doc tab position */

	/* document settings */
#ifdef APP_GNP
	guint		autosave;	/* autosave minutes (0 = disables) */
#endif
	ubyte		maxrecent;	/* max num of recently opened docs */

	/* window settings */
	int		win_height;	/* window height */
	int		win_width;	/* window width */
	int		win_xpos;	/* window xposition */
	int		win_ypos;	/* window yposition */

#ifdef APP_GNP
	/* fonts and colors */
	GdkColor	text_fg_color;	/* GDK-styled text fg color */
	char *		text_fg_str;	/* fg color (rgb string) */
	GdkColor	text_bg_color;	/* GDK-styled text bg color */
	char *		text_bg_str;	/* bg color (rgb string) */
	GdkFont *	text_font;	/* GDK-styled text font */
	char *		text_font_str;	/* text font string */
	GdkColor	text_hlfg_color;/* GDK-styled text highlight fg color */
	char *		text_hlfg_str;	/* highlight fg color (rgb string) */
	GdkColor	text_hlbg_color;/* GDK-styled text highlight bg color */
	char *		text_hlbg_str;	/* highlight bg color (rgb string) */
#endif

	/* misc */
	char *		printcmd;	/* print cmd. 'lpr' */
	char *		tmpdir;		/* temp directory. '/var/tmp' */
	guint		msgbox_max_msg;	/* max num of msgs in msg box */
	guint		msgbox_per_del;	/* % of msgs to delete in msg box */

} app_prefs_t;

extern app_prefs_t prefs;


extern void	prefs_init(void);
extern void	prefs_save(void);
extern void	prefs_cb(GtkWidget *wgt, gpointer cbdata);
#ifdef APP_GNP
extern void	prefs_text_color_update(void);
extern void	prefs_update_text_widget_style(GtkWidget *wgt);
#endif	/* APP_GNP */


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __PREFS_H__ */
