/* vi:set ts=8 sts=0 sw=8:
 * $Id: menu.c,v 1.22 1999/01/21 21:11:23 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <string.h>
#include "doc.h"
#include "menu.h"
#include "msgbar.h"
#include "msgbox.h"
#include "about.h"
#include "toolbar.h"
#include "prefs.h"
#include "misc.h"
#ifdef APP_GNP
#include "print.h"
#include "clipboard.h"
#include "search.h"
#include "project.h"
#include "prjbar.h"
#include "htmltags.h"
#endif

#ifdef WANT_GNOME
static GnomeUIInfo file_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("New"), NULL,
		doc_new_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
		'N', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Open..."), NULL,
		doc_new_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
		'O', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Open Recent..."), NULL,
		doc_new_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
		'O', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Save"), NULL,
		doc_save_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
		'S', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Save As..."), NULL,
		doc_saveas_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVEAS
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Close"), NULL,
		doc_close_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
		'W', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Close All"), NULL,
		doc_close_all_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Print"), NULL,
		print_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
		'P', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("File Info"), NULL,
		doc_info_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
		'I', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Exit"), NULL,
		win_close_all_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
		'Q', GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* file_menu */

static GnomeUIInfo edit_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Cut"), NULL,
		cut_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CUT,
		'X', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Copy"), NULL,
		copy_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_COPY,
		'C', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Paste"), NULL,
		paste_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PASTE,
		'V', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Select All"), NULL,
		selall_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
		'A', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Find..."), NULL,
		search_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
		'F', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Find Again"), NULL,
		search_again_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
		NULL, GDK_CONTROL_MASK, NULL
	},
#ifdef NOTYET
	{
		GNOME_APP_UI_ITEM, N_("Replace"), NULL,
		search_replace_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
		NULL, GDK_CONTROL_MASK, NULL
	},
#endif
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Goto Line #..."), NULL,
		goto_line_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* edit_menu */

#ifdef WANT_PROJECT
static GnomeUIInfo project_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Toggle Project Bar"), NULL,
		prjbar_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("New Project"), NULL,
		NULL, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Open Project"), NULL,
		prj_open_cb, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Edit Project"), NULL,
		NULL, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Save Project"), NULL,
		NULL, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Close Project"), NULL,
		prj_close_cb, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Project List"), NULL,
		NULL, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Edit a Project"), NULL,
		NULL, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* project_menu */
#endif	/* WANT_PROJECT */

static GnomeUIInfo window_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Doc List"), NULL,
		doc_list_show, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		'L', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Messages"), NULL,
		msgbox_show, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		'M', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Window List"), NULL,
		win_list_show, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("New Window"), NULL,
		win_new_with_doc, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Close Window"), NULL,
		win_close_cb, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* project_menu */

static GnomeUIInfo toolbar_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Toggle On/Off"), NULL,
		tb_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Toggle Raised"), NULL,
		tb_raised_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Toggle Tooltips"), NULL,
		tb_ttip_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Pic & Text"), NULL,
		tb_pic_text, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Pic Only"), NULL,
		tb_pic_only, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Text Only"), NULL,
		tb_text_only, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* toolbar_menu */

static GnomeUIInfo doctab_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Toggle"), NULL,
		win_dtab_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Top"), NULL,
		win_dtab_top, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Bottom"), NULL,
		win_dtab_bot, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Left"), NULL,
		win_dtab_left, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Right"), NULL,
		win_dtab_right, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* doctab_menu */

static GnomeUIInfo options_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Toggle Message Bar"), NULL,
		msgbar_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Toggle Wordwrap"), NULL,
		win_wwrap_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_SUBTREE, N_("Doc Tabs"), NULL,
		&doctab_menu
	},
	{
		GNOME_APP_UI_SUBTREE, N_("Toolbar"), NULL,
		&toolbar_menu
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Preferences..."), NULL,
		prefs_cb, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* options_menu */

static GnomeUIInfo help_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("About gnotepad+"), NULL,
		msgbar_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* help_menu */

GnomeUIInfo main_menu[] = {
	{
		GNOME_APP_UI_SUBTREE, N_("File"), NULL,
		&file_menu, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL
	},
	{
		GNOME_APP_UI_SUBTREE, N_("Edit"), NULL,
		&edit_menu, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL
	},
	{
		GNOME_APP_UI_SUBTREE, N_("Window"), NULL,
		&window_menu, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL
	},
	{
		GNOME_APP_UI_SUBTREE, N_("Options"), NULL,
		&options_menu, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL
	},
	{
		GNOME_APP_UI_SUBTREE, N_("About"), NULL,
		&about_menu, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL
	},
	GNOMEUIINFO_END
}; /* main_menu */

#endif	/* WANT_GNOME */

/*** local variables ***/
#ifdef GTK_HAVE_FEATURES_1_1_0

#define MENU_PATH_RECENT_DOC	"/File/Open Recent.../"

static void menu_add(GtkItemFactory *menubar, char *submenupath,
		     char *newmenupath, char *accelerator,
		     GtkItemFactoryCallback callback, gpointer cbdata);
static void menu_remove(GtkItemFactory *menubar, char *menupath);

static GtkItemFactory *mainfact;
static GtkItemFactoryEntry mainmenu[] = {
	{ "/_File",		NULL, NULL, 0, "<Branch>" },
	{ "/File/tearoff1",	NULL, NULL, 0, "<Tearoff>" },
	{ "/File/New",		"<control>N",	doc_new_cb },
	{ "/File/Open...",	"<control>O",	doc_open_cb },
	{ MENU_PATH_RECENT_DOC },
	{ "/File/sep1",		NULL, NULL, 0, "<Separator>" },
#ifdef APP_GNP
	{ "/File/Save",		"<control>S",	doc_save_cb },
	{ "/File/Save As...",	NULL, doc_saveas_cb },
#endif
	{ "/File/Close",	"<control>W", doc_close_cb },
	{ "/File/Close All",	NULL, doc_close_all_cb },
#ifdef APP_GNP
	{ "/File/<sep1>",	NULL, NULL, 0, "<Separator>" },
	{ "/File/Print...",	"<control>P", print_cb },
#endif
	{ "/File/<sep1>",	NULL, NULL, 0, "<Separator>" },
	{ "/File/File Info",	"<control>I", doc_info_cb },
	{ "/File/<sep1>",	NULL, NULL, 0, "<Separator>" },
	{ "/File/Exit",		"<control>Q", win_close_all_cb },

	{ "/_Edit",		NULL, NULL, 0, "<Branch>" },
#ifdef APP_GNP
	{ "/Edit/tearoff1",	NULL, NULL, 0, "<Tearoff>" },
	{ "/Edit/Cut",		"<control>X", cut_cb },
	{ "/Edit/Copy",		"<control>C", copy_cb },
	{ "/Edit/Paste",	"<control>V", paste_cb },
	{ "/Edit/Select All",	"<control>A", selall_cb },
	{ "/Edit/<sep1>",	NULL, NULL, 0, "<Separator>" },
	{ "/Edit/Insert HTML/tearoff1",	NULL, NULL, 0, "<Tearoff>" },
	{ "/Edit/Insert HTML/Title",		NULL,
	  html_menu_cb, HtmlTtl },
	{ "/Edit/Insert HTML/Comment",		NULL,
	  html_menu_cb, HtmlCmnt },
	{ "/Edit/Insert HTML/<sep1>",		NULL, NULL, 0, "<Separator>" },
	{ "/Edit/Insert HTML/Links/HyperLink",	NULL,
	  html_menu_cb, HtmlLink },
	{ "/Edit/Insert HTML/Links/Target",	NULL,
	  html_menu_cb, HtmlTarg },
	{ "/Edit/Insert HTML/Links/Image",	NULL,
	  html_menu_cb, HtmlImg },
	{ "/Edit/Insert HTML/Heading/Header1",	NULL,
	  html_menu_cb, HtmlH1 },
	{ "/Edit/Insert HTML/Heading/Header2",	NULL,
	  html_menu_cb, HtmlH2 },
	{ "/Edit/Insert HTML/Heading/Header3",	NULL,
	  html_menu_cb, HtmlH3 },
	{ "/Edit/Insert HTML/Heading/Header4",	NULL,
	  html_menu_cb, HtmlH4 },
	{ "/Edit/Insert HTML/Heading/Header5",	NULL,
	  html_menu_cb, HtmlH5 },
	{ "/Edit/Insert HTML/Heading/Header6",	NULL,
	  html_menu_cb, HtmlH6 },
	{ "/Edit/Insert HTML/Layout/Align Left",	NULL,
	  html_menu_cb, HtmlLeft },
	{ "/Edit/Insert HTML/Layout/Align Center",	NULL,
	  html_menu_cb, HtmlCent },
	{ "/Edit/Insert HTML/Layout/Align Right",	NULL,
	  html_menu_cb, HtmlRght },
	{ "/Edit/Insert HTML/Layout/<sep1>",	NULL, NULL, 0, "<Separator>" },
	{ "/Edit/Insert HTML/Layout/Paragraph",	NULL,
	  html_menu_cb, HtmlPara },
	{ "/Edit/Insert HTML/Layout/Line Break", NULL,
	  html_menu_cb, HtmlLbrk },
	{ "/Edit/Insert HTML/Layout/Separator",	NULL,
	  html_menu_cb, HtmlSep },
	{ "/Edit/Insert HTML/Font/Bold",	NULL,
	  html_menu_cb, HtmlBold },
	{ "/Edit/Insert HTML/Font/Italic",	NULL,
	  html_menu_cb, HtmlItal },
	{ "/Edit/Insert HTML/Font/Underline",	NULL,
	  html_menu_cb, HtmlUlne },
	{ "/Edit/Insert HTML/Font/<sep1>",	NULL, NULL, 0, "<Separator>" },
	{ "/Edit/Insert HTML/Font/Typewriter",	NULL,
	  html_menu_cb, HtmlTty },
	{ "/Edit/Insert HTML/Font/Strikeout",	NULL,
	  html_menu_cb, HtmlStrk },
	{ "/Edit/Insert HTML/Font/<sep1>",	NULL, NULL, 0, "<Separator>" },
	{ "/Edit/Insert HTML/Font/Emphasis",	NULL,
	  html_menu_cb, HtmlEmph },
	{ "/Edit/Insert HTML/Font/Strong",	NULL,
	  html_menu_cb, HtmlStrg },
	{ "/Edit/Insert HTML/Font/<sep1>",	NULL, NULL, 0, "<Separator>" },
	{ "/Edit/Insert HTML/Font/Subscript",	NULL,
	  html_menu_cb, HtmlSub },
	{ "/Edit/Insert HTML/Font/Superscript",	NULL,
	  html_menu_cb, HtmlSup },
	{ "/Edit/Insert HTML/Font/<sep1>",	NULL, NULL, 0, "<Separator>" },
	{ "/Edit/Insert HTML/Font/Big",		NULL,
	  html_menu_cb, HtmlBig },
	{ "/Edit/Insert HTML/Font/Small",	NULL,
	  html_menu_cb, HtmlSmll },
	{ "/Edit/Insert HTML/List/Ordered List",NULL,
	  html_menu_cb, HtmlOrdr },
	{ "/Edit/Insert HTML/List/Unordered List", NULL,
	  html_menu_cb, HtmlUord },
	{ "/Edit/Insert HTML/List/List Item",	NULL,
	  html_menu_cb, HtmlLitm },
	{ "/Edit/<sep1>",			NULL, NULL, 0, "<Separator>" },
	{ "/Edit/Find...",		"<control>F", search_cb },
	{ "/Edit/Find Again",		NULL, search_again_cb },
#ifdef NOTYET
	{ "/Edit/Replace",		"<control>R", search_replace_cb },
#endif
	{ "/Edit/<sep1>",		NULL, NULL, 0, "<Separator>" },
	{ "/Edit/Goto Line #...",	NULL, goto_line_cb },
#endif	/* APP_GNP */

#if defined(WANT_PROJECT) && defined(APP_GNP)
	{ "/_Project",			NULL, NULL, 0, "<Branch>" },
	{ "/Project/tearoff1",		NULL, NULL, 0, "<Tearoff>" },
	{ "/Project/Toggle Project Bar", NULL, prjbar_toggle },
	{ "/Project/<sep1>",		NULL, NULL, 0, "<Separator>" },
	{ "/Project/New Project" },
	{ "/Project/Open Project",	NULL, prj_open_cb },
	{ "/Project/Edit Project" },
	{ "/Project/Save Project" },
	{ "/Project/Close Project",	NULL, prj_close_cb },
	{ "/Project/<sep1>",		NULL, NULL, 0, "<Separator>" },
	{ "/Project/Current Project Info" },
	{ "/Project/Project List" },
	{ "/Project/Edit A Project" },
#endif	/* WANT_PROJECT */

	{ "/_Window",			NULL, NULL, 0, "<Branch>" },
	{ "/Window/tearoff1",		NULL, NULL, 0, "<Tearoff>" },
	{ "/Window/Doc List",		"<control>L", doc_list_show },
	{ "/Window/Messages",		"<control>M", msgbox_show },
	{ "/Window/<sep1>",		NULL, NULL, 0, "<Separator>" },
	{ "/Window/Window List",	NULL, win_list_show },
	{ "/Window/New Window",		NULL, win_new_with_doc },
	{ "/Window/Close Window",	NULL, win_close_cb },

	{ "/_Options",			NULL, NULL, 0, "<Branch>" },
	{ "/Options/tearoff1",		NULL, NULL, 0, "<Tearoff>" },
	{ "/Options/Toggle Message Bar", NULL, msgbar_toggle },
#ifdef APP_GNP
	{ "/Options/Toggle Wordwrap",	NULL, win_wwrap_toggle },
#endif
	{ "/Options/Doc Tabs/tearoff1",	NULL, NULL, 0, "<Tearoff>" },
	{ "/Options/Doc Tabs/Toggle",	NULL, win_dtab_toggle },
	{ "/Options/Doc Tabs/<separator>", NULL, NULL, 0, "<Separator>" },
	{ "/Options/Doc Tabs/Top",	NULL, win_dtab_top },
	{ "/Options/Doc Tabs/Bottom",	NULL, win_dtab_bot },
	{ "/Options/Doc Tabs/Left",	NULL, win_dtab_left },
	{ "/Options/Doc Tabs/Right",	NULL, win_dtab_right },
	{ "/Options/Toolbar/tearoff1",	NULL, NULL, 0, "<Tearoff>" },
#ifdef APP_GNP
	{ "/Options/Toolbar/Toggle HTML Toolbar", NULL, tb_html_toggle },
#endif
	{ "/Options/Toolbar/<separator>",	NULL, NULL, 0, "<Separator>" },
	{ "/Options/Toolbar/Toggle On-Off",	NULL, tb_toggle },
	{ "/Options/Toolbar/Toggle Raised",	NULL, tb_raised_toggle },
	{ "/Options/Toolbar/Toggle Tooltips",	NULL, tb_ttip_toggle },
	{ "/Options/Toolbar/<separator>",	NULL, NULL, 0, "<Separator>" },
	{ "/Options/Toolbar/Pic & Text",	NULL, tb_pic_text },
	{ "/Options/Toolbar/Pic Only",	NULL, tb_pic_only },
	{ "/Options/Toolbar/Text Only",	NULL, tb_text_only },
	{ "/Options/<separator>",	NULL, NULL, 0, "<Separator>" },
	{ "/Options/Preferences...",	NULL, prefs_cb },

	{ "/_Help",			NULL, NULL, 0, "<LastBranch>" },
	{ "/Help/About gnotepad+",	NULL, about_cb },
}; /* mainmenu[] */

#else	/* GTK 1.0.x */

#define MENU_PATH_RECENT_DOC	"<Main>/File/Open Recent.../"

static void menu_add(GtkMenuFactory *menubar, char *submenupath,
	char *newmenupath, char *accel, GtkMenuCallback cb, gpointer cbdata);
static void menu_remove(GtkMenuFactory *menubar, char *menupath);

static GtkMenuFactory *mainfact;
static GtkMenuEntry mainmenu[] = {
	{"<Main>/File/New", "<control>N", doc_new_cb},
	{"<Main>/File/Open...", "<control>O", doc_open_cb},
	{MENU_PATH_RECENT_DOC},
	{"<Main>/File/<separator>"},
	{"<Main>/File/Save", "<control>S", doc_save_cb},
	{"<Main>/File/Save As...", NULL, doc_saveas_cb},
	{"<Main>/File/Close", "<control>W", doc_close_cb},
	{"<Main>/File/Close All", NULL, doc_close_all_cb},
	{"<Main>/File/<separator>"},
	{"<Main>/File/Print...", "<control>P", print_cb},
	{"<Main>/File/<separator>"},
	{"<Main>/File/File Info", "<control>I", doc_info_cb},
	{"<Main>/File/<separator>"},
	{"<Main>/File/Exit", "<control>Q", win_close_all_cb},

#ifdef APP_GNP
	{"<Main>/Edit/Cut", "<control>X", cut_cb},
	{"<Main>/Edit/Copy", "<control>C", copy_cb},
	{"<Main>/Edit/Paste", "<control>V", paste_cb},
	{"<Main>/Edit/Select All", "<control>A", selall_cb},
	{"<Main>/Edit/<separator>"},
	{"<Main>/Edit/Insert HTML/Title",		NULL, html_title_cb },
	{"<Main>/Edit/Insert HTML/Comment",		NULL, html_comment_cb },
	{"<Main>/Edit/Insert HTML/<separator>"},
	{"<Main>/Edit/Insert HTML/Links/HyperLink",	NULL, html_link_cb },
	{"<Main>/Edit/Insert HTML/Links/Target",	NULL, html_target_cb },
	{"<Main>/Edit/Insert HTML/Links/Image",	NULL, html_image_cb },
	{"<Main>/Edit/Insert HTML/Heading/Header1",	NULL, html_h1_cb },
	{"<Main>/Edit/Insert HTML/Heading/Header2",	NULL, html_h2_cb },
	{"<Main>/Edit/Insert HTML/Heading/Header3",	NULL, html_h3_cb },
	{"<Main>/Edit/Insert HTML/Heading/Header4",	NULL, html_h4_cb },
	{"<Main>/Edit/Insert HTML/Heading/Header5",	NULL, html_h5_cb },
	{"<Main>/Edit/Insert HTML/Heading/Header6",	NULL, html_h6_cb },
	{"<Main>/Edit/Insert HTML/Layout/Align Center",	NULL, html_center_cb },
	{"<Main>/Edit/Insert HTML/Layout/<separator>"},
	{"<Main>/Edit/Insert HTML/Layout/Paragraph", NULL, html_paragraph_cb },
	{"<Main>/Edit/Insert HTML/Layout/Line Break", NULL, html_linebreak_cb },
	{"<Main>/Edit/Insert HTML/Layout/Separator", NULL, html_separator_cb },
	{"<Main>/Edit/Insert HTML/Font/Bold",	NULL, html_bold_cb },
	{"<Main>/Edit/Insert HTML/Font/Italic",	NULL, html_italic },
	{"<Main>/Edit/Insert HTML/Font/Underline", NULL, html_underline_cb },
	{"<Main>/Edit/Insert HTML/Font/<separator>"},
	{"<Main>/Edit/Insert HTML/Font/Typewriter", NULL, html_typewriter_cb },
	{"<Main>/Edit/Insert HTML/Font/Strikeout", NULL, html_strikeout_cb },
	{"<Main>/Edit/Insert HTML/Font/<separator>"},
	{"<Main>/Edit/Insert HTML/Font/Emphasis", NULL, html_emphasis_cb },
	{"<Main>/Edit/Insert HTML/Font/Strong",	NULL, html_strong_cb },
	{"<Main>/Edit/Insert HTML/Font/<separator>"},
	{"<Main>/Edit/Insert HTML/Font/Subscript", NULL, html_subscript_cb },
	{"<Main>/Edit/Insert HTML/Font/Superscript", NULL, html_superscript_cb},
	{"<Main>/Edit/Insert HTML/Font/<separator>"},
	{"<Main>/Edit/Insert HTML/Font/Big",		NULL, html_big_cb },
	{"<Main>/Edit/Insert HTML/Font/Small",	NULL, html_small_cb },
	{"<Main>/Edit/Insert HTML/List/Ordered List",NULL, html_ordered_cb },
	{"<Main>/Edit/Insert HTML/List/Unordered List",NULL, html_unordered_cb},
	{"<Main>/Edit/Insert HTML/List/List Item", NULL, html_listitem_cb },
	{"<Main>/Edit/<separator>"},
#endif
	{"<Main>/Edit/Find...", "<control>F", search_cb},
	{"<Main>/Edit/Find Again", NULL, search_again_cb},
#ifdef APP_GNP
#ifdef NOTYET
	{"<Main>/Edit/Replace", "<control>R", search_replace_cb},
#endif
	{"<Main>/Edit/<separator>"},
	{"<Main>/Edit/Goto Line #...", NULL, goto_line_cb},

#ifdef WANT_PROJECT
	{"<Main>/Project/Toggle Project Bar", NULL, prjbar_toggle},
	{"<Main>/Project/<separator>"},
	{"<Main>/Project/New Project"},
	{"<Main>/Project/Open Project", NULL, prj_open_cb},
	{"<Main>/Project/Edit Project"},
	{"<Main>/Project/Save Project"},
	{"<Main>/Project/Close Project", NULL, prj_close_cb},
	{"<Main>/Project/<separator>"},
	{"<Main>/Project/Current Project Info"},
	{"<Main>/Project/Project List"},
	{"<Main>/Project/Edit A Project"},
#endif	/* WANT_PROJECT */
#endif	/* APP_GNP */

	{"<Main>/Window/Doc List", "<control>L", doc_list_show},
	{"<Main>/Window/Messages", "<control>M", msgbox_show},
	{"<Main>/Window/<separator>"},
	{"<Main>/Window/Window List", NULL, win_list_show},
	{"<Main>/Window/New Window", NULL, win_new_with_doc},
	{"<Main>/Window/Close Window", NULL, win_close_cb},

	{"<Main>/Options/Toggle Message Bar", NULL, msgbar_toggle},
	{"<Main>/Options/Toggle Wordwrap", NULL, win_wwrap_toggle},
	{"<Main>/Options/Doc Tabs/Toggle", NULL, win_dtab_toggle},
	{"<Main>/Options/Doc Tabs/<separator>"},
	{"<Main>/Options/Doc Tabs/Top", NULL, win_dtab_top},
	{"<Main>/Options/Doc Tabs/Bottom", NULL, win_dtab_bot},
	{"<Main>/Options/Doc Tabs/Left", NULL, win_dtab_left},
	{"<Main>/Options/Doc Tabs/Right", NULL, win_dtab_right},
	{"<Main>/Options/Toolbar/Toggle HTML Toolbar", NULL, tb_html_toggle},
	{"<Main>/Options/Toolbar/<separator>"},
	{"<Main>/Options/Toolbar/Toggle On-Off", NULL, tb_toggle},
	{"<Main>/Options/Toolbar/Toggle Tooltips", NULL, tb_ttip_toggle},
	{"<Main>/Options/Toolbar/<separator>"},
	{"<Main>/Options/Toolbar/Pic & Text", NULL, tb_pic_text},
	{"<Main>/Options/Toolbar/Pic Only", NULL, tb_pic_only},
	{"<Main>/Options/Toolbar/Text Only", NULL, tb_text_only},
	{"<Main>/Options/<separator>"},
	{"<Main>/Options/Preferences...", NULL, prefs_cb},

	{"<Main>/Help/About gnotepad+", NULL, about_cb},
};
#endif	/* GTK_HAVE_FEATURES_1_1_0 */

#ifdef APP_GNP
static qmenu_t qmenu[] = {
	{ "Cut", cut_cb },
	{ "Copy", copy_cb },
	{ "Paste", paste_cb },
	{ "<separator>", NULL },
	{ "Open in new window", doc_open_in_new_win },
	{ "<separator>", NULL },
	{ "Save", doc_save_cb },
	{ "Close", doc_close_cb },
	{ "Print", print_cb },
	{ NULL, NULL }
};
#endif


/*** global function definitions ***/
/*
 * PUBLIC: menu_main_init
 *
 * initialize the menubar.  called from win_new().
 */
void
menu_main_init(win_t *w)
{
#ifdef GTK_HAVE_FEATURES_1_1_0
	GtkAccelGroup *accgrp;
	int numitems;

	numitems = sizeof(mainmenu) / sizeof(mainmenu[0]);
	accgrp = gtk_accel_group_new();
	mainfact = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accgrp);
#if 0
	/*
	 * words cannot express how stupid some of the gtk folks can be.  they
	 * really need to learn how to write documentation.  but hey, you get
	 * what you paid for, and since it's free, let's not complain any more.
	 *
	 * using gtk_item_factory_create_items() from testgtk.c won't work
	 * unless you change a lot of code.  since i'm trying to preserve the
	 * overall structure from my gtk-1.0.x code base, i can't just blindly
	 * use gtk_item_factory_create_items().  fortunately, i took a look at
	 * yet another public and undocumented routine which happens to do what
	 * was needed: gtk_item_factory_create_items_ac().  here, we can
	 * specify the callback type:
	 *
	 * gtk_item_factory_create_items_ac(mainfact, numitems, mainmenu, w, 2);
	 */
	gtk_item_factory_create_items(mainfact, numitems, mainmenu, NULL);
#endif
	gtk_item_factory_create_items_ac(mainfact, numitems, mainmenu, w, 2);

	gtk_accel_group_attach(accgrp, GTK_OBJECT(w->toplev));
	w->menubar = gtk_item_factory_get_widget(mainfact, "<main>"),

#else	/* GTK 1.0.x */

	GtkMenuPath *mpath;
	GtkMenuFactory *subf;
	GtkMenuEntry *newmenu;
	int numitems, i;

	/* do we really need a copy of the actual menu? */
#if PROBABLY_NOT
	newmenu = (GtkMenuEntry *)g_malloc(sizeof(mainmenu));
	memcpy(newmenu, mainmenu, sizeof(mainmenu));
#else
	newmenu = mainmenu;
#endif
	numitems = sizeof(mainmenu) / sizeof(mainmenu[0]);

	for (i = 0; i < numitems; i++)
		newmenu[i].callback_data = (gpointer)w;
	mainfact = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
	subf = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
	gtk_menu_factory_add_subfactory(mainfact, subf, "<Main>");
	gtk_menu_factory_add_entries(mainfact, newmenu, numitems);

	mpath = gtk_menu_factory_find(mainfact, "<Main>/Help");
	gtk_menu_item_right_justify(GTK_MENU_ITEM(mpath->widget));

	w->menubar = subf->widget;
	gtk_window_add_accelerator_table(GTK_WINDOW(w->toplev), subf->table);
#endif	/* GTK_HAVE_FEATURES_1_1_0 */

	w->menubar_h = gtk_handle_box_new();
	gtk_container_add(GTK_CONTAINER(w->menubar_h), w->menubar);
	gtk_box_pack_start(GTK_BOX(w->mainbox), w->menubar_h, FALSE, TRUE, 0);
	gtk_widget_show(w->menubar);
	gtk_widget_show(w->menubar_h);

} /* menu_main_init */


/*
 * PUBLIC: menu_recent_doc_remove
 *
 * always removes the first entry, since adding to the menu is FIFO.
 * called from recent_list_add().
 */
void
menu_recent_doc_remove(gpointer data)
{
	int len;
	char *menupath;
	doc_new_name_t *dnnp = (doc_new_name_t *)data;

	len = strlen(MENU_PATH_RECENT_DOC) +
	      strlen((const char *)my_basename(dnnp->fname)) + 1;
	menupath = (char *)g_malloc(len);
	g_snprintf(menupath, len, "%s%s",
			MENU_PATH_RECENT_DOC, my_basename(dnnp->fname));

	menu_remove(mainfact, menupath);
	g_free(menupath);
} /* menu_recent_doc_remove */


/*
 * PUBLIC: menu_recent_doc_add
 *
 * called from recent_list_add(), recent_list_init()
 */
void
menu_recent_doc_add(GtkMenuCallback cbfunc, gpointer data)
{
	doc_new_name_t *dnnp = (doc_new_name_t *)data;

	menu_add(mainfact, MENU_PATH_RECENT_DOC,
		(char *)my_basename(dnnp->fname), NULL, cbfunc, (gpointer)dnnp);
} /* menu_recent_doc_add */


#ifdef APP_GNP
/*
 * PUBLIC: quickmenu_init
 *
 * initialize the quick popup menu (right mouse click).  called from win_new().
 */
void
quickmenu_init(win_t *w)
{
	GtkWidget *tmp;
	qmenu_t *qmp = qmenu;

	w->quickmenu = gtk_menu_new();
	while (qmp && qmp->name != NULL) {
		if (strcmp(qmp->name, "<separator>") == 0)
			tmp = gtk_menu_item_new();
		else
			tmp = gtk_menu_item_new_with_label(qmp->name);

		gtk_menu_append(GTK_MENU(w->quickmenu), tmp);
		gtk_widget_show(tmp);

		if (qmp->cb)
			gtk_signal_connect(GTK_OBJECT(tmp), "activate",
				GTK_SIGNAL_FUNC(qmp->cb), w);
		qmp++;
	}
} /* quickmenu_init */


/*
 * PUBLIC: quickmenu_show
 *
 * callback routine invoked when user clicks on right mouse button.
 */
gboolean
quickmenu_show(GtkWidget *wgt, GdkEvent *ev)
{
	if (ev->type == GDK_BUTTON_PRESS) {
		GdkEventButton *event = (GdkEventButton *)ev;
		if (event->button == 3) {
			gtk_menu_popup(GTK_MENU(wgt), NULL, NULL, NULL, NULL,
					event->button, event->time);
			return TRUE;
		}
	}
	return FALSE;
} /* quickmenu_show */
#endif


/*** local functions ***/
/*
 * PRIVATE: menu_remove
 *
 * called only from menu_recent_doc_remove(), to remove an item from the
 * submenu for recent files.
 */
#ifdef GTK_HAVE_FEATURES_1_1_0
static void
menu_remove(GtkItemFactory *menubar, char *menupath)
{
	gtk_item_factory_delete_item(menubar, menupath);
} /* menu_remove */

#else
static void
menu_remove(GtkMenuFactory *menubar, char *menupath)
{
	gtk_menu_factory_remove_paths(menubar, &menupath, 1);
} /* menu_remove */
#endif


/*
 * PRIVATE: menu_add
 *
 * called only from menu_recent_doc_add() to add an item to the submenu for
 * recent files.
 */
#ifdef GTK_HAVE_FEATURES_1_1_0
static void 
menu_add(GtkItemFactory *menubar, char *submenupath, char *newmenupath,
	char *accelerator, GtkItemFactoryCallback callback, gpointer cbdata)
{
	GtkItemFactoryEntry *newentry;
	int len;

	newentry = (GtkItemFactoryEntry *)g_malloc(sizeof(GtkItemFactoryEntry));
	len = strlen(submenupath) + strlen(newmenupath) + 1;
	newentry->path = (char *)g_malloc(len);
	g_snprintf(newentry->path, len, "%s%s", submenupath, newmenupath);
	newentry->accelerator = accelerator;
	newentry->callback = callback;
	newentry->callback_action = 0;
	newentry->item_type = "<Item>";

	/*
	 * again, words cannot express how stupid some of the gtk folks can be.
	 *
	 * the last param to gtk_item_factory_create_item() is the callback
	 * type.  effectively, this specifies what kind of parameters and in
	 * what order they are in for the callback routine.  for more details,
	 * see the *private* function gtk_item_factory_callback_marshal().
	 *
	 * i don't understand why the old menu factory code couldn't have just
	 * been updated to use the new item factory crap instead of having
	 * everyone forcibly switch to item factories.  can you say boneheaded?
	 */
	gtk_item_factory_create_item(menubar, newentry, cbdata, 2);

	/*
	 * although it doesn't say that you can anywhere, it looks like we can
	 * safely free up the space we just allocated
	 */
	g_free(newentry->path);
	g_free(newentry);
} /* menu_add */
#else
static void 
menu_add(GtkMenuFactory *menubar, char *submenupath, char *newmenupath,
	char *accelerator, GtkMenuCallback callback, gpointer cbdata)
{
	GtkMenuEntry *newentry;
	int len;

	newentry = (GtkMenuEntry *)g_malloc(sizeof(GtkMenuEntry));
	len = strlen(submenupath) + strlen(newmenupath) + 1;
	newentry->path = (char *)g_malloc(len);
	g_snprintf(newentry->path, len, "%s%s", submenupath, newmenupath);
	newentry->accelerator = accelerator;
	newentry->callback = callback;
	newentry->callback_data = cbdata;
	newentry->widget = NULL;

	gtk_menu_factory_add_entries(menubar, newentry, 1);

	/*
	 * although it doesn't say that you can anywhere, it looks like we can
	 * safely free up the space we just allocated
	 */
	g_free(newentry->path);
	g_free(newentry);
} /* menu_add */
#endif


/* the end */
