#!/bin/bash
echo "Welcome to Xproc's console version: proc.sh"
echo "Hint: You should run this as ./proc.sh|more and to leave, just press ^C"
menu()
{
echo "*******************************************"
echo "*                  M E N U                *"
echo "*******************************************"
echo "c :  CPU               p :  PCI devices    "
echo "m :  Memory            f :  File systems   "
echo "d :  Detected devices  i :  IRQ/IO/DMA     "
echo "*******************************************"
read c

if [ "$c" = "c" ]; then
 echo "CPU INFORMATION"
 echo "***************"
 cat /proc/cpuinfo
fi
if [ "$c" = "m" ]; then
 echo "MEMORY INFORMATION"
 echo "******************"
 cat /proc/meminfo
fi
if [ "$c" = "d" ]; then
 echo "DEVICES INFORMATION"
 echo "*******************"
 cat /proc/devices
 cat /proc/interrupts
fi
if [ "$c" = "p" ]; then
 echo "PCI INFORMATION"
 echo "***************"
 cat /proc/pci
fi
if [ "$c" = "f" ]; then
 echo "FILESYSTEMS INFORMATION"
 echo "***********************"
 cat /proc/filesystems
 echo "PARTITIONS INFORMATION"
 echo "**********************"
 cat /proc/partitions
fi
if [ "$c" = "i" ]; then
 echo "IRQ INFORMATION"
 echo "***************"
 cat /proc/interrupts
 echo "IO INFORMATION"
 echo "**************"
 cat /proc/ioports
 echo "DMA INFORMATION"
 echo "***************"
 cat /proc/dma
fi

menu
}
menu