/*
 * Decompiled with CFR 0.152.
 */
package netscape.softupdate;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.javascript.JSObject;
import netscape.security.AppletSecurity;
import netscape.security.AppletSecurityException;
import netscape.security.ForbiddenTargetException;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import netscape.softupdate.FolderSpec;
import netscape.softupdate.InstallDelete;
import netscape.softupdate.InstallExecute;
import netscape.softupdate.InstallFile;
import netscape.softupdate.InstallObject;
import netscape.softupdate.InstallPatch;
import netscape.softupdate.ProgressDetails;
import netscape.softupdate.SoftUpdateException;
import netscape.softupdate.Strings;
import netscape.softupdate.UninstallObject;
import netscape.softupdate.VersionInfo;
import netscape.softupdate.VersionRegistry;
import netscape.softupdate.WinProfile;
import netscape.softupdate.WinReg;

public final class SoftwareUpdate {
    public static final int LIMITED_INSTALL = 0;
    public static final int FULL_INSTALL = 1;
    public static final int NO_STATUS_DLG = 2;
    public static final int NO_FINALIZE_DLG = 4;
    protected static final String IMPERSONATOR = "Impersonator";
    public static final String INSTALL_PRIV = "SoftwareInstall";
    public static final String SILENT_PRIV = "SilentInstall";
    public static final String FOLDER_FILE_URL = "file:///";
    public static final int BAD_PACKAGE_NAME = -200;
    public static final int UNEXPECTED_ERROR = -201;
    public static final int ACCESS_DENIED = -202;
    public static final int TOO_MANY_CERTIFICATES = -203;
    public static final int NO_INSTALLER_CERTIFICATE = -204;
    public static final int NO_CERTIFICATE = -205;
    public static final int NO_MATCHING_CERTIFICATE = -206;
    public static final int UNKNOWN_JAR_FILE = -207;
    public static final int INVALID_ARGUMENTS = -208;
    public static final int ILLEGAL_RELATIVE_PATH = -209;
    public static final int USER_CANCELLED = -210;
    public static final int INSTALL_NOT_STARTED = -211;
    public static final int SILENT_MODE_DENIED = -212;
    public static final int NO_SUCH_COMPONENT = -213;
    public static final int FILE_DOES_NOT_EXIST = -214;
    public static final int FILE_READ_ONLY = -215;
    public static final int FILE_IS_DIRECTORY = -216;
    public static final int NETWORK_FILE_IS_IN_USE = -217;
    public static final int APPLE_SINGLE_ERR = -218;
    public static final int INVALID_PATH_ERR = -219;
    public static final int PATCH_BAD_DIFF = -220;
    public static final int PATCH_BAD_CHECKSUM_TARGET = -221;
    public static final int PATCH_BAD_CHECKSUM_RESULT = -222;
    public static final int UNINSTALL_FAILED = -223;
    public static final int SUCCESS = 0;
    public static final int REBOOT_NEEDED = 999;
    protected String packageName;
    protected String userPackageName;
    protected Vector installedFiles;
    protected Hashtable patchList;
    protected VersionInfo versionInfo;
    private boolean bShowProgress;
    private boolean bShowFinalize;
    private FolderSpec packageFolder;
    private ProgressDetails confdlg;
    private int userChoice;
    private int progwin;
    private boolean silent;
    private boolean force;
    private boolean bUninstallPackage;
    private boolean bRegisterPackage;
    private boolean bUserCancelled;
    private int lastError;
    private String filesep;
    private String installerJarName;
    private String jarName;
    private String jarCharset;
    private int zigPtr;
    private Principal installPrincipal;

    private native long NativeDiskSpaceAvailable(String var1);

    private native String NativeFileURLToNative(String var1);

    private native String[] ExtractDirEntries(String var1);

    public SoftwareUpdate(JSObject jSObject, String string) {
        this.userPackageName = string;
        this.installPrincipal = null;
        this.packageName = null;
        this.packageFolder = null;
        this.confdlg = null;
        this.progwin = 0;
        this.patchList = new Hashtable();
        this.zigPtr = 0;
        this.userChoice = -1;
        this.lastError = 0;
        this.bUninstallPackage = false;
        this.bRegisterPackage = false;
        this.bShowProgress = true;
        this.bShowFinalize = true;
        this.bUserCancelled = false;
        this.VerifyJSObject(jSObject);
        this.jarName = (String)jSObject.getMember("src");
        this.jarCharset = (String)jSObject.getMember("jarCharset");
        try {
            this.silent = (Boolean)jSObject.getMember("silent");
            this.force = (Boolean)jSObject.getMember("force");
        }
        catch (Throwable throwable) {
            System.out.println("Unexpected throw getting silent/force");
            this.silent = false;
            this.force = false;
        }
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS")) {
            this.filesep = ":";
            return;
        }
        this.filesep = System.getProperty("file.separator");
    }

    protected void finalize() throws Throwable {
        this.CleanUp();
        super.finalize();
    }

    private native void VerifyJSObject(JSObject var1);

    private void InitializeInstallerCertificate() throws SoftUpdateException {
        Object[] objectArray = null;
        objectArray = this.getCertificates(this.zigPtr, this.installerJarName);
        if (objectArray == null || objectArray.length == 0) {
            throw new SoftUpdateException(Strings.error_NoCertificate(), -204);
        }
        if (objectArray.length > 1) {
            throw new SoftUpdateException(Strings.error_TooManyCertificates(), -203);
        }
        this.installPrincipal = new Principal(14, (byte[])objectArray[0]);
    }

    private void CheckSilentPrivileges() {
        if (!this.silent) {
            return;
        }
        try {
            PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
            Target target = Target.findTarget(IMPERSONATOR);
            privilegeManager.enablePrivilege(target);
            Target target2 = Target.findTarget(SILENT_PRIV);
            privilegeManager.checkPrivilegeGranted(target2, this.GetPrincipal(), null);
            return;
        }
        catch (Throwable throwable) {
            System.out.println(Strings.error_SilentModeDenied());
            this.silent = false;
            return;
        }
    }

    private void RequestSecurityPrivileges() {
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget(IMPERSONATOR);
        privilegeManager.enablePrivilege(target);
        Target target2 = Target.findTarget(INSTALL_PRIV);
        privilegeManager.enablePrivilege(target2, this.GetPrincipal());
    }

    protected final Principal GetPrincipal() {
        return this.installPrincipal;
    }

    protected final String GetUserPackageName() {
        return this.userPackageName;
    }

    protected final String GetRegPackageName() {
        return this.packageName;
    }

    protected final boolean GetSilent() {
        return this.silent;
    }

    protected final Enumeration GetInstallQueue() {
        if (this.installedFiles != null) {
            return this.installedFiles.elements();
        }
        return null;
    }

    public int GetLastError() {
        return this.lastError;
    }

    public void ResetError() {
        this.lastError = 0;
    }

    private int saveError(int n) {
        if (n != 0) {
            this.lastError = n;
        }
        return n;
    }

    public FolderSpec GetComponentFolder(String string) {
        FolderSpec folderSpec = null;
        try {
            int n;
            String string2 = this.GetQualifiedPackageName(string);
            String string3 = VersionRegistry.getDefaultDirectory(string2);
            if (string3 == null && (string3 = VersionRegistry.componentPath(string2)) != null && (n = string3.lastIndexOf(this.filesep)) > 0) {
                char[] cArray = new char[n + 1];
                string3.getChars(0, n + 1, cArray, 0);
                string3 = new String(cArray);
            }
            if (string3 != null) {
                if (!string3.endsWith(this.filesep)) {
                    string3 = String.valueOf(string3) + this.filesep;
                }
                folderSpec = new FolderSpec("Installed", string3, this.userPackageName);
            }
        }
        catch (SoftUpdateException softUpdateException) {
            softUpdateException.GetError();
        }
        return folderSpec;
    }

    public FolderSpec GetComponentFolder(String string, String string2) {
        return this.GetFolder(this.GetComponentFolder(string), string2);
    }

    public void SetPackageFolder(FolderSpec folderSpec) {
        this.packageFolder = folderSpec;
    }

    public Object GetWinProfile(FolderSpec folderSpec, String string) {
        WinProfile winProfile = null;
        String string2 = System.getProperty("os.name");
        try {
            this.SanityCheck();
            if (string2.indexOf("Windows") >= 0 || string2.equals("Win32s") || string2.equals("OS/2")) {
                winProfile = new WinProfile(this, folderSpec, string);
            }
        }
        catch (Throwable throwable) {
            winProfile = null;
            throwable.printStackTrace();
        }
        return winProfile;
    }

    public Object GetWinRegistry() {
        WinReg winReg = null;
        String string = System.getProperty("os.name");
        try {
            this.SanityCheck();
            if (string.indexOf("Windows") >= 0 || string.equals("Win32s")) {
                winReg = new WinReg(this);
            }
        }
        catch (Throwable throwable) {
            winReg = null;
            throwable.printStackTrace();
        }
        return winReg;
    }

    private native void OpenJARFile() throws SoftUpdateException;

    private native void CloseJARFile();

    private native Object[] getCertificates(int var1, String var2);

    protected String ExtractJARFile(String string, String string2) throws SoftUpdateException, AppletSecurityException {
        Object object;
        if (this.zigPtr == 0) {
            throw new SoftUpdateException("JAR file has not been opened", -207);
        }
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget(INSTALL_PRIV);
        privilegeManager.checkPrivilegeEnabled(target);
        boolean bl = false;
        Object[] objectArray = null;
        objectArray = this.getCertificates(this.zigPtr, string);
        if (objectArray == null || objectArray.length == 0) {
            throw new SoftUpdateException("Missing certificate for " + string, -205);
        }
        int n = 0;
        while (n < objectArray.length) {
            object = new Principal(14, (byte[])objectArray[n]);
            if (this.installPrincipal.equals(object)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new SoftUpdateException(String.valueOf(Strings.error_MismatchedCertificate()) + string, -206);
        }
        object = this.NativeExtractJARFile(string, string2);
        return object;
    }

    private void ParseFlags(int n) {
        if ((n & 2) == 2) {
            this.bShowProgress = false;
        }
        if ((n & 4) == 4) {
            this.bShowFinalize = false;
        }
    }

    private native String NativeExtractJARFile(String var1, String var2) throws SoftUpdateException;

    public int StartInstall(String string, VersionInfo versionInfo, int n) {
        int n2 = 0;
        this.ResetError();
        this.ParseFlags(n);
        this.bUserCancelled = false;
        this.packageName = null;
        try {
            Object object;
            if (string == null) {
                throw new SoftUpdateException(Strings.error_BadPackageName(), -200);
            }
            this.packageName = this.GetQualifiedPackageName(string);
            while (this.packageName.endsWith("/")) {
                object = new char[this.packageName.length() - 1];
                this.packageName.getChars(0, this.packageName.length() - 1, (char[])object, 0);
                this.packageName = new String((char[])object);
            }
            this.versionInfo = versionInfo;
            this.installedFiles = new Vector();
            this.OpenJARFile();
            this.InitializeInstallerCertificate();
            this.CheckSilentPrivileges();
            this.RequestSecurityPrivileges();
            if (this.bShowProgress) {
                this.OpenProgressDialog();
            }
            if ((object = (Object)VersionRegistry.getDefaultDirectory(this.packageName)) != null) {
                this.packageFolder = new FolderSpec("Installed", (String)object, this.userPackageName);
            }
        }
        catch (SoftUpdateException softUpdateException) {
            n2 = softUpdateException.GetError();
            this.packageName = null;
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n2 = -202;
            this.packageName = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n2 = -201;
            this.packageName = null;
        }
        this.saveError(n2);
        return n2;
    }

    public int StartInstall(String string, String string2) {
        return this.StartInstall(string, new VersionInfo(string2), 0);
    }

    public int StartInstall(String string, String string2, int n) {
        return this.StartInstall(string, new VersionInfo(string2), n);
    }

    protected void UserCancelled() {
        this.userChoice = 0;
    }

    protected void UserApproved() {
        this.userChoice = 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int FinalizeInstall() {
        int n;
        boolean bl;
        block34: {
            int n2;
            block31: {
                bl = false;
                n = 0;
                try {
                    int n3;
                    block29: {
                        block30: {
                            try {
                                block32: {
                                    Throwable throwable2;
                                    InstallObject installObject;
                                    Enumeration enumeration;
                                    block33: {
                                        this.SanityCheck();
                                        if (this.installedFiles == null || this.installedFiles.size() == 0) {
                                            this.CleanUp();
                                            n3 = 0;
                                            Object var5_5 = null;
                                            if (this.installedFiles == null) break block29;
                                            break block30;
                                        }
                                        if (!this.silent && this.UserWantsConfirm()) {
                                            this.confdlg = new ProgressDetails(this);
                                            while (true) {
                                                if (this.userChoice != -1) {
                                                    this.confdlg = null;
                                                    if (this.userChoice == 1) break;
                                                    this.AbortInstall();
                                                    n2 = this.saveError(-210);
                                                    break block31;
                                                }
                                                Thread.sleep(10L);
                                            }
                                        }
                                        if (this.bShowFinalize) {
                                            this.OpenProgressDialog();
                                        } else {
                                            this.CloseProgressDialog();
                                        }
                                        this.SetProgressDialogItem("");
                                        this.SetProgressDialogRange(this.installedFiles.size());
                                        enumeration = this.GetInstallQueue();
                                        installObject = null;
                                        try {
                                            int n4 = 0;
                                            if (this.bUninstallPackage) {
                                                VersionRegistry.uninstallCreate(this.packageName, this.userPackageName);
                                            }
                                            while (enumeration.hasMoreElements()) {
                                                installObject = (InstallObject)enumeration.nextElement();
                                                try {
                                                    installObject.Complete();
                                                }
                                                catch (SoftUpdateException softUpdateException) {
                                                    if (softUpdateException.GetError() != 999) {
                                                        throw softUpdateException;
                                                    }
                                                    bl = true;
                                                }
                                                this.SetProgressDialogThermo(++n4);
                                            }
                                            break block32;
                                        }
                                        catch (Throwable throwable2) {
                                            if (installObject == null) break block33;
                                            installObject.Abort();
                                        }
                                    }
                                    while (true) {
                                        if (!enumeration.hasMoreElements()) {
                                            throw throwable2;
                                        }
                                        try {
                                            installObject = (InstallObject)enumeration.nextElement();
                                            installObject.Abort();
                                        }
                                        catch (Throwable throwable3) {}
                                    }
                                }
                                if (this.versionInfo != null && this.bRegisterPackage) {
                                    n = VersionRegistry.installComponent(this.packageName, null, this.versionInfo);
                                    if (this.packageFolder != null) {
                                        VersionRegistry.setDefaultDirectory(this.packageName, this.packageFolder.toString());
                                    }
                                }
                                break block34;
                            }
                            catch (SoftUpdateException softUpdateException) {
                                n = softUpdateException.GetError();
                            }
                            catch (ForbiddenTargetException forbiddenTargetException) {
                                n = -202;
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                System.out.println(String.valueOf(Strings.error_Unexpected()) + " FinalizeInstall");
                                n = -201;
                            }
                            break block34;
                        }
                        this.installedFiles.removeAllElements();
                    }
                    this.CleanUp();
                    return n3;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    if (this.installedFiles != null) {
                        this.installedFiles.removeAllElements();
                    }
                    this.CleanUp();
                    throw throwable;
                }
            }
            Object var5_6 = null;
            if (this.installedFiles != null) {
                this.installedFiles.removeAllElements();
            }
            this.CleanUp();
            return n2;
        }
        Object var5_7 = null;
        if (this.installedFiles != null) {
            this.installedFiles.removeAllElements();
        }
        this.CleanUp();
        if (n == 0 && bl) {
            n = 999;
        }
        this.saveError(n);
        return n;
    }

    public synchronized void AbortInstall() {
        Object object2;
        try {
            try {
                if (this.installedFiles != null) {
                    object2 = this.GetInstallQueue();
                    while (object2.hasMoreElements()) {
                        InstallObject installObject = (InstallObject)object2.nextElement();
                        try {
                            installObject.Abort();
                        }
                        catch (Throwable throwable) {}
                    }
                    this.installedFiles.removeAllElements();
                    this.installedFiles = null;
                }
                this.CloseJARFile();
            }
            catch (Throwable throwable) {
                System.out.println(String.valueOf(Strings.error_Unexpected()) + " AbortInstall");
                throwable.printStackTrace();
            }
            Object var2_5 = null;
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            try {
                this.CleanUp();
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.CleanUp();
        }
        catch (Throwable object2) {
            ((Throwable)object2).printStackTrace();
        }
    }

    private synchronized void CleanUp() {
        this.CloseJARFile();
        this.confdlg = null;
        this.zigPtr = 0;
        if (this.installedFiles != null) {
            Enumeration enumeration = this.GetInstallQueue();
            while (enumeration.hasMoreElements()) {
                InstallObject installObject = (InstallObject)enumeration.nextElement();
                installObject.Abort();
            }
            this.installedFiles.removeAllElements();
        }
        this.installedFiles = null;
        this.packageName = null;
        this.CloseProgressDialog();
    }

    protected void ScheduleForInstall(InstallObject installObject) throws SoftUpdateException {
        this.SetProgressDialogItem(installObject.toString());
        installObject.Prepare();
        this.installedFiles.addElement(installObject);
        if (installObject.CanUninstall()) {
            this.bUninstallPackage = true;
        }
        if (installObject.RegisterPackageNode()) {
            this.bRegisterPackage = true;
        }
    }

    private String GetQualifiedRegName(String string) throws SoftUpdateException {
        String string2;
        String string3 = string2 = this.packageName.length() == 0 ? "" : String.valueOf(this.packageName) + "/";
        if (string.toUpperCase().startsWith("=COMM=/")) {
            string = (String.valueOf(string.substring(7)) + "===").substring(0, string.length() - 7);
        } else if (string.toUpperCase().startsWith("=USER=/")) {
            string = String.valueOf(this.CurrentUserNode()) + string.substring(7);
        } else if (string.charAt(0) != '/') {
            string = String.valueOf(string2) + string;
        }
        if (this.BadRegName(string)) {
            throw new SoftUpdateException(Strings.error_BadPackageName(), -200);
        }
        return string;
    }

    private String GetQualifiedPackageName(String string) throws SoftUpdateException {
        if (string.toUpperCase().startsWith("=USER=/")) {
            string = String.valueOf(this.CurrentUserNode()) + string.substring(7);
        }
        if (this.BadRegName(string)) {
            throw new SoftUpdateException(Strings.error_BadPackageName(), -200);
        }
        return string;
    }

    private void SanityCheck() throws SoftUpdateException {
        if (this.packageName == null) {
            throw new SoftUpdateException(Strings.error_MustCallStart(), -211);
        }
        if (this.bUserCancelled) {
            this.AbortInstall();
            this.saveError(-210);
            throw new SoftUpdateException("", -210);
        }
    }

    private native String NativeProfileName();

    private String CurrentUserNode() {
        return "/Netscape/Users/" + this.NativeProfileName() + "/";
    }

    private boolean BadRegName(String string) {
        if (string == null) {
            return true;
        }
        if (string.startsWith(" ") || string.endsWith(" ")) {
            return true;
        }
        if (string.indexOf("//") > -1) {
            return true;
        }
        if (string.indexOf("/ ") > -1 || string.indexOf(" /") > -1) {
            return true;
        }
        return string.indexOf("=") > -1;
    }

    public int AddSubcomponent(String string, VersionInfo versionInfo, String string2, FolderSpec folderSpec, String string3, boolean bl) {
        int n = 0;
        try {
            if (string2 == null || string2.length() == 0 || folderSpec == null) {
                throw new SoftUpdateException("", -208);
            }
            this.SanityCheck();
            string = string == null || string.length() == 0 ? this.GetQualifiedRegName(string2) : this.GetQualifiedRegName(string);
            if (string3 == null || string3.length() == 0) {
                string3 = string2;
            }
            boolean bl2 = false;
            if (!bl && versionInfo != null && VersionRegistry.validateComponent(string) == 0) {
                VersionInfo versionInfo2 = VersionRegistry.componentVersion(string);
                if (versionInfo.compareTo(versionInfo2) >= 0) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                InstallFile installFile = new InstallFile(this, string, versionInfo, string2, folderSpec, string3, bl);
                this.ScheduleForInstall(installFile);
            }
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n = -202;
        }
        catch (Throwable throwable) {
            System.out.println(String.valueOf(Strings.error_Unexpected()) + "AddSubcomponent");
            throwable.printStackTrace();
            n = -201;
        }
        this.saveError(n);
        return n;
    }

    public int AddSubcomponent(String string) {
        return this.AddSubcomponent("", this.versionInfo, string, this.packageFolder, "", this.force);
    }

    public int AddSubcomponent(String string, String string2, FolderSpec folderSpec, String string3) {
        return this.AddSubcomponent(string, this.versionInfo, string2, folderSpec, string3, this.force);
    }

    public int AddSubcomponent(String string, String string2, String string3, FolderSpec folderSpec, String string4) {
        return this.AddSubcomponent(string, new VersionInfo(string2), string3, folderSpec, string4, this.force);
    }

    public int AddSubcomponent(String string, String string2, String string3, FolderSpec folderSpec, String string4, boolean bl) {
        return this.AddSubcomponent(string, new VersionInfo(string2), string3, folderSpec, string4, bl);
    }

    public int Execute(String string) {
        return this.Execute(string, null);
    }

    public int Execute(String string, String string2) {
        int n = 0;
        try {
            this.SanityCheck();
            InstallExecute installExecute = new InstallExecute(this, string, string2);
            this.ScheduleForInstall(installExecute);
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n = -202;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println(String.valueOf(Strings.error_Unexpected()) + "Execute");
            n = -201;
        }
        this.saveError(n);
        return n;
    }

    public int[] Gestalt(String string) {
        int[] nArray = new int[]{0, 0};
        try {
            nArray[1] = this.NativeGestalt(string);
        }
        catch (SoftUpdateException softUpdateException) {
            nArray[0] = softUpdateException.GetError();
        }
        catch (Throwable throwable) {
            nArray[0] = -1;
            System.out.println(String.valueOf(Strings.error_Unexpected()) + "Gestalt");
        }
        return nArray;
    }

    private native int NativeGestalt(String var1) throws SoftUpdateException;

    public int Patch(String string, VersionInfo versionInfo, String string2, FolderSpec folderSpec, String string3) {
        if (folderSpec == null || string == null || string.length() == 0 || string2 == null) {
            return this.saveError(-208);
        }
        int n = 0;
        try {
            this.SanityCheck();
            String string4 = this.GetQualifiedRegName(string);
            InstallPatch installPatch = new InstallPatch(this, string4, versionInfo, string2, folderSpec, string3);
            this.ScheduleForInstall(installPatch);
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n = -202;
        }
        catch (Throwable throwable) {
            System.out.println(String.valueOf(Strings.error_Unexpected()) + "Patch");
            throwable.printStackTrace();
            n = -201;
        }
        this.saveError(n);
        return n;
    }

    public int Patch(String string, String string2, FolderSpec folderSpec, String string3) {
        return this.Patch(string, this.versionInfo, string2, folderSpec, string3);
    }

    public int Patch(String string, String string2, String string3, FolderSpec folderSpec, String string4) {
        return this.Patch(string, new VersionInfo(string2), string3, folderSpec, string4);
    }

    private native int NativeMakeDirectory(String var1);

    public int DeleteFile(FolderSpec folderSpec, String string) {
        int n = 0;
        try {
            this.SanityCheck();
            InstallDelete installDelete = new InstallDelete(this, folderSpec, string);
            this.ScheduleForInstall(installDelete);
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
            if (n == -214) {
                n = 0;
            }
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n = -202;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            n = -201;
        }
        this.saveError(n);
        return n;
    }

    public int DeleteComponent(String string) {
        int n = 0;
        try {
            this.SanityCheck();
            String string2 = this.GetQualifiedRegName(string);
            InstallDelete installDelete = new InstallDelete(this, string2);
            this.ScheduleForInstall(installDelete);
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
            if (n == -214) {
                n = 0;
            }
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n = -202;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            n = -201;
        }
        if (n == -214) {
            n = 0;
        }
        this.saveError(n);
        return n;
    }

    public FolderSpec GetFolder(String string) {
        try {
            if (!string.equalsIgnoreCase("Installed") && !string.equalsIgnoreCase(FOLDER_FILE_URL)) {
                FolderSpec folderSpec = new FolderSpec(string, this.packageName, this.userPackageName);
                if (folderSpec.GetDirectoryPath() == null) {
                    return null;
                }
                return folderSpec;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return null;
    }

    public FolderSpec GetFolder(Object object, String string) {
        if (object instanceof FolderSpec) {
            return this.GetFolder((FolderSpec)object, string);
        }
        if (object instanceof String) {
            return this.GetFolder((String)object, string);
        }
        return null;
    }

    public FolderSpec GetFolder(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase(FOLDER_FILE_URL)) {
            String string3 = this.NativeFileURLToNative("/" + string2);
            if (string3 != null) {
                if (string3.endsWith(this.filesep)) {
                    return new FolderSpec("Installed", string3, this.userPackageName);
                }
                String string4 = String.valueOf(string3) + this.filesep;
                return new FolderSpec("Installed", string4, this.userPackageName);
            }
            return null;
        }
        return this.GetFolder(this.GetFolder(string), string2);
    }

    public FolderSpec GetFolder(FolderSpec folderSpec, String string) {
        if (string == null || string.length() == 0) {
            return folderSpec;
        }
        if (folderSpec != null) {
            String string2;
            try {
                string2 = folderSpec.MakeFullPath(string);
            }
            catch (Exception exception) {
                return null;
            }
            if (string2 != null) {
                if (string2.endsWith(this.filesep)) {
                    return new FolderSpec("Installed", string2, this.userPackageName);
                }
                String string3 = String.valueOf(string2) + this.filesep;
                return new FolderSpec("Installed", string3, this.userPackageName);
            }
        }
        return null;
    }

    public long DiskSpaceAvailable(FolderSpec folderSpec) {
        String string = folderSpec.toString();
        if (string == null) {
            return 0L;
        }
        return this.NativeDiskSpaceAvailable(string);
    }

    public int AddDirectory(String string, VersionInfo versionInfo, String string2, FolderSpec folderSpec, String string3, boolean bl) {
        int n = 0;
        try {
            if (string2 == null || string2.length() == 0 || folderSpec == null) {
                throw new SoftUpdateException("", -208);
            }
            this.SanityCheck();
            string = string == null || string.length() == 0 ? this.GetQualifiedRegName(string2) : this.GetQualifiedRegName(string);
            if (string3 == null) {
                string3 = "";
            } else if (string3.length() != 0) {
                string3 = String.valueOf(string3) + "/";
            }
            String[] stringArray = this.ExtractDirEntries(string2);
            int n2 = 0;
            while (n2 < stringArray.length) {
                VersionInfo versionInfo2;
                String string4 = String.valueOf(string) + "/" + stringArray[n2];
                boolean bl2 = !bl && versionInfo != null && VersionRegistry.validateComponent(string4) == 0 ? versionInfo.compareTo(versionInfo2 = VersionRegistry.componentVersion(string4)) >= 0 : true;
                if (bl2) {
                    InstallFile installFile = new InstallFile(this, string4, versionInfo, String.valueOf(string2) + "/" + stringArray[n2], folderSpec, String.valueOf(string3) + stringArray[n2], bl);
                    this.ScheduleForInstall(installFile);
                }
                ++n2;
            }
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n = -202;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println(String.valueOf(Strings.error_Unexpected()) + "AddDirectory");
            n = -201;
        }
        this.saveError(n);
        return n;
    }

    public int AddDirectory(String string) {
        return this.AddDirectory("", this.versionInfo, string, this.packageFolder, "", this.force);
    }

    public int AddDirectory(String string, String string2, FolderSpec folderSpec, String string3) {
        return this.AddDirectory(string, this.versionInfo, string2, folderSpec, string3, this.force);
    }

    public int AddDirectory(String string, String string2, String string3, FolderSpec folderSpec, String string4) {
        return this.AddDirectory(string, new VersionInfo(string2), string3, folderSpec, string4, this.force);
    }

    public int AddDirectory(String string, String string2, String string3, FolderSpec folderSpec, String string4, boolean bl) {
        return this.AddDirectory(string, new VersionInfo(string2), string3, folderSpec, string4, bl);
    }

    public int Uninstall(String string) {
        int n = 0;
        try {
            this.SanityCheck();
            String string2 = this.GetQualifiedPackageName(string);
            UninstallObject uninstallObject = new UninstallObject(this, string2);
            this.ScheduleForInstall(uninstallObject);
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n = -202;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println(String.valueOf(Strings.error_Unexpected()) + "Uninstall");
            n = -201;
        }
        this.saveError(n);
        return n;
    }

    void OpenProgressDialog() {
        if (!this.silent && this.progwin == 0) {
            this.progwin = this.NativeOpenProgDlg(this.GetUserPackageName());
        }
    }

    void CloseProgressDialog() {
        if (this.progwin != 0) {
            this.NativeCloseProgDlg(this.progwin);
            this.progwin = 0;
        }
    }

    void SetProgressDialogItem(String string) {
        if (this.progwin != 0) {
            this.NativeSetProgDlgItem(this.progwin, string);
        }
    }

    void SetProgressDialogRange(int n) {
        if (this.progwin != 0) {
            this.NativeSetProgDlgRange(this.progwin, n);
        }
    }

    void SetProgressDialogThermo(int n) {
        if (this.progwin != 0) {
            this.NativeSetProgDlgThermo(this.progwin, n);
        }
    }

    private native int NativeOpenProgDlg(String var1);

    private native void NativeCloseProgDlg(int var1);

    private native void NativeSetProgDlgItem(int var1, String var2);

    private native void NativeSetProgDlgRange(int var1, int var2);

    private native void NativeSetProgDlgThermo(int var1, int var2);

    private native boolean UserWantsConfirm();
}

