/*
 * $Id: test3.c,v 1.2 1997/07/14 21:37:04 u27113 Exp $
 *
 * Test initially created to simulate a problem in nedit.
 * Then augmented to observe callback structures.
 */

#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <Xm/PushB.h>
#include <stdio.h>

XtAppContext app;
Widget toplevel, box, push;

int	popdown;

void
cb(Widget w, XtPointer client, XtPointer call)
{
	XmFileSelectionBoxCallbackStruct *cbp =
		(XmFileSelectionBoxCallbackStruct *)call;

	/* Print stuff */
	fprintf(stderr, "Callback Structure :\n");
	fprintf(stderr, "\tReason %s, event %p\n",
		XdbReason2String(cbp->reason),
		cbp->event);
	fprintf(stderr, "\tvalue '%s', length %d\n",
		XdbXmString2String(cbp->value),
		cbp->length);
	fprintf(stderr, "\tmask '%s', length %d\n",
		cbp->mask ? XdbXmString2String(cbp->mask) : "(null)",
		cbp->mask_length);
	fprintf(stderr, "\tdir '%s', length %d\n",
		cbp->dir ? XdbXmString2String(cbp->dir) : "(null)",
		cbp->dir_length);
	fprintf(stderr, "\tpattern '%s', length %d\n",
		cbp->pattern ? XdbXmString2String(cbp->pattern) : "(null)",
		cbp->pattern_length);

	/* Trigger popping down */
	popdown = 1;
}

void
pushme(Widget w, XtPointer client, XtPointer call)
{
	box = XmCreateFileSelectionDialog(toplevel, "Box", NULL, 0);
	XtAddCallback(box, XmNokCallback, cb, NULL);

	popdown = 0;
	XtManageChild(box);

	while (popdown == 0) {
	        XtAppProcessEvent(XtWidgetToApplicationContext(w), XtIMAll);
	}

	fprintf(stderr, "Destroying the FSB\n");
	XtDestroyWidget(box);
}

int
main(int argc, char **argv)
{

	toplevel = XtVaAppInitialize(&app, "listTest", NULL, 0,
		&argc, argv, NULL, NULL);

	push = XmCreatePushButton(toplevel, "push", NULL, 0);
	XtVaSetValues(push,
			XtVaTypedArg, XmNlabelString, XtRString, "Push me !", 9,
		NULL);

	XtAddCallback(push, XmNactivateCallback, pushme, NULL);

	XtManageChild(push);

	XtRealizeWidget(toplevel);
	XtAppMainLoop(app);
	exit(0);
}
