/**
 *
 * $Id: ToolBar.c,v 1.1 1998/06/03 21:55:10 rwscott Exp $
 *
 * Copyright (C) 1996 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Extension Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <X11/xpm.h>
#include <BubbleButton.h>

static const char rcsid[] = "$Id: ToolBar.c,v 1.1 1998/06/03 21:55:10 rwscott Exp $";

/* ******************** */

Widget XltToolBarAddItem(Widget ToolBar, char *Label, char **PixmapData)
{
Widget Button;
Pixmap pixmap;
Pixmap pixmap_insens;
Pixmap mask;
XpmAttributes attrib;
GC gc;
Pixel bg;

	Button = XltCreateBubbleButton(ToolBar,Label,NULL,0);

	if (PixmapData != NULL)
	{
		attrib.valuemask = XpmCloseness;
		attrib.closeness = 40000;
		XpmCreatePixmapFromData(XtDisplay(ToolBar),
			XRootWindowOfScreen(XtScreen(ToolBar)),
			PixmapData,
			&pixmap,
			&mask,
			&attrib);

		pixmap_insens = XCreatePixmap(XtDisplay(ToolBar),
					pixmap,
					attrib.width,
					attrib.height,
					DefaultDepthOfScreen(XtScreen(ToolBar)));
		gc = XDefaultGCOfScreen(XtScreen(ToolBar));
		if (mask != (Pixmap)NULL)
		{
			XtVaGetValues(Button,
				XmNbackground, &bg,
				NULL);
			XSetBackground(XtDisplay(ToolBar),gc,bg);
			XSetFunction(XtDisplay(ToolBar),gc,GXor);
			XCopyPlane(XtDisplay(ToolBar),
				mask,pixmap,
				gc,
				0,0,attrib.width,attrib.height,
				0,0,
				1);
			XFreePixmap(XtDisplay(ToolBar),mask);
		}
		XSetFunction(XtDisplay(ToolBar),gc,GXcopy);
		XCopyArea(XtDisplay(ToolBar),
			pixmap,
			pixmap_insens,
			gc,
			0, 0,
			attrib.width, attrib.height,
			0, 0);
		XSetFillStyle(XtDisplay(ToolBar), gc, FillStippled);
		XSetStipple(XtDisplay(ToolBar), gc, 
		    XmGetPixmapByDepth(XtScreen(ToolBar),
		    	"50_foreground",
		    	WhitePixelOfScreen(XtScreen(ToolBar)),
		    	BlackPixelOfScreen(XtScreen(ToolBar)),
		    	1)
		    );
		XFillRectangle(XtDisplay(ToolBar),
			pixmap_insens,
			gc,
			0, 0,
			attrib.width + 1, attrib.height + 1);

		XpmFreeAttributes(&attrib);

		XtVaSetValues(Button,
			XmNlabelType,XmPIXMAP,
			XmNlabelPixmap,pixmap,
			XmNlabelInsensitivePixmap,pixmap_insens,
			NULL);
	}
	return(Button);
}

