.if t .ds LX L\\h'-0.36m'\\v'-0.15v'\\s-2A\\s+2\\h'-0.15m'\\v'0.15v'T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds LX LaTeX
.if t .ds TX T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds TX TeX
.ds Ts T\s-2RAN\s+2S\s-2CRIPT\s+2
.if t .ds Uc \fIU\\h'-0.12m'C\\v'0.27m'\\h'-.23m'S\\h'-0.11m'F\\v'-0.27m'\fP
.if n .ds Uc UCSF
.ds Et \\f(boE\\h'-0.1667m'\\v'-0.20v'T\\v'0.20v'\\h'-0.125m'T\\fP
.TH MAKEINDEX 1L "10 December 1991"
.\"=====================================================================
.SH NAME
makeindex \- a general purpose, formatter-independent index processor
.SH SYNOPSIS
.B makeindex
.BR [ \-c ]
.BR [ \-g ]
.BR [ \-i ]
.BR [ \-l ]
.BR [ \-o
.IR ind ]
.BR [ \-p
.IR num ]
.BR [ \-q ]
.BR [ \-r ]
.BR [ \-s
.IR sfile ]
.BR [ \-t
.IR log ]
.BI [ idx0
.I idx1
.IR idx2 .\|.\|.]
.\"=====================================================================
.SH DESCRIPTION
The program
.I makeindex
is a general purpose hierarchical index generator; it accepts one or
more input files (often produced by a text formatter such as \*(TX
.RI ( tex (1L))
or
.IR troff (1),
sorts the entries, and produces an output file which can be formatted.
The index can have up to three levels (0, 1, and 2) of subitem nesting.
The way in which words are flagged for indexing within the main document
is specific to the formatter used;
.I makeindex
does
.I not
automate the process of selecting these words.  As the output index
is hierarchical,
.I makeindex
can be considered complimentary to the
.IR awk (1)-based
.IR make.index (1L)
system of Bentley and Kernighan, which is specific to
.IR troff (1),
generates non-hierarchical indices, and employs a much simpler syntax
for indicating index entries.  For illustration of use with
.I troff
and
.IR \*(TX ,
see the section \s-2EXAMPLES\s+2 below.
.LP
The formats of the input and output files are
specified in a style file; by default, input is assumed to be a
.I \&.idx
file, as generated by \*(LX.
.LP
Unless specified explicitly, the base name of the first input file
.RI ( idx0 )
is used to determine the names of other files.  For each input file
name specified, a file of that name is sought.  If this file is not
found and the file name has no extension, the extension
.I \&.idx
is appended.  If no file with this name is found,
.I makeindex
aborts.
.LP
If exactly one input file was given and no explicit style file was
specified using
.BR \-s ,
.I makeindex
uses a file with the extension
.I \&.mst
as default style file (when present).
.LP
For important notes on how to select index keywords, see the document
by Lamport cited below.  As an issue separate from selecting index
keywords, a systematic mechanism for placing index terms in a document
is suggested in
.IR "Index Preparation and Processing" ,
a paper cited below.
.\"=====================================================================
.SH OPTIONS
.TP 10
.B \-c
Compress intermediate blanks (ignoring leading and trailing blanks and
tabs).  By default, blanks in the index key are retained.
.TP 10
.B \-g
Employ German word ordering in the index, in accord with rules set forth
in DIN 5007.  By default,
.I makeindex
employs a word ordering in which precedence is: symbols, numbers,
uppercase letters, lowercase letters.  The sequence in German word
ordering is: symbols, lowercase letters, uppercase letters, numbers.
Additionally, this option enables
.I makeindex
to recognize the German \*(TX-commands {"a, "o, "u and "s} as {ae, oe,
ue and ss} during the sorting of the entries.  The quote character
must be redefined in a style file (for example, redefine quote
as '+').  If the quote character is not redefined,
.I makeindex
will produce an error message and abort.
.TP 10
.B \-i
Take input from
.IR stdin .
When this option is specified and
.B \-o
is not, output is written to
.IR stdout .
.TP 10
.B \-l
Letter ordering; by default, word ordering is used (see
the \s-2ORDERING\s+2 section).
.TP 10
.BI \-o " ind"
Employ
.I ind
as the output index file.  By default, the file name
is created by appending the extension
.I .ind
to the base name of
the first input file
.RI ( idx0 ).
.TP 10
.BI \-p " num"
Set the starting page number of the output index file to be
.I num
(useful when the index file is to be formatted separately).  The
argument
.I num
may be numerical or one of the following:
.RS
.TP 10
.I any
The starting page is the last source page number plus 1.
.TP
.I odd
The starting page is the first odd page following the last source page
number.
.TP
.I even
The starting page is the first even page following the last source
page number.
.RE
.IP
The last source page is obtained by searching backward in the log file
for the first instance of a number included within paired square
brackets
.RB ( [ .\|.\|. ] ).
If a page number is missing or the log file is not found, no attempt
will be made to set the starting page number.  The source log file
name is determined by appending the extension
.I \&.log
to the base name of the first input file
.RI ( idx0 ).
.TP 10
.B \-q
Quiet mode; send no messages to
.IR stderr .
By default, progress
and error messages are sent to
.I stderr
as well as to the
transcript file.
.TP 10
.B \-r
Disable implicit page range formation; page ranges must be created by
using explicit range operators; see \s-2SPECIAL EFFECTS\s+2 below.  By
default, three or more successive pages are automatically abbreviated
as a range (e.g. 1\(em5).
.TP 10
.BR \-s " sty"
Employ
.I sty
as the style file (no default).  The environment
variable \s-2INDEXSTYLE\s+2 defines the path where the style file
should be found.
.TP 10
.BR \-t " log"
Employ
.I log
as the transcript file.  By default, the file name is
created by appending the extension
.I .ilg
to the base name of the
first input file
.RI ( idx0 ).
.\"=====================================================================
.SH "STYLE FILE"
The style file informs
.I makeindex
about the format of the
.I \&.idx
input files and the intended format of the final output file; examples
appear below.  This file can reside anywhere in the path defined by
the environment variable \s-2INDEXSTYLE\s+2.  The style file contains
a list of
.RI < specifier , " attribute" >
pairs.  There are two types of specifiers: input and output.
Pairs do not have to appear in any particular order.
A line begun by `%' is a comment.  In the following list of
specifiers and arguments, <string> is an arbitrary string delimited by
double quotes (".\|.\|."), <char> is a single letter embraced by
single quotes ('.\|.\|.'), and <number> is a nonnegative integer.
The maximum length of a <string> is 2048.  A literal backslash or
quote must be escaped (by a backslash).  Anything not specified in the
style file will be assigned a default value, which is shown at the
head of the rightmost column.
.\"----------------------------------------------------------------------
.SS "INPUT STYLE SPECIFIERS"
.TP 25
.BR actual " <char>"
\'@\'
.RS
Symbol indicating that the next entry is to appear in the output file.
.RE
.TP
.BR arg_close " <char>"
\'}\'
.RS
Closing delimiter for the index entry argument.
.RE
.TP
.BR arg_open " <char>"
\'{\'
.RS
Opening delimiter for the index entry argument.
.RE
.TP
.BR encap " <char>"
\'|\'
.RS
Symbol indicating that the rest of the argument list
is to be used as the encapsulating command for the page number.
.RE
.TP
.BR escape " <char>"
\'\\\\\'
.RS
Symbol which escapes the following letter, unless its preceding letter
is
.BR escape .
Note:
.B quote
is used to escape the letter which immediately follows it, but if it is
preceded by
.BR escape ,
it is treated as a ordinary character.  These two symbols
.I must
be distinct.
.RE
.TP
.BR keyword " <string>"
"\\\\indexentry"
.RS
Command which tells
.I makeindex
that its argument is an index entry.
.RE
.TP
.BR level " <char>"
\'!\'
.RS
Delimiter denoting a new level of subitem.
.RE
.TP
.BR quote " <char>"
\'"\'
.RS
Note:
.B quote
is used to escape the letter which immediately follows it, but if it is
preceded by
.BR escape ,
it is treated as a ordinary character.  These two symbols
.I must
be distinct.
.RE
.TP
.BR range_close " <char>"
\')\'
.RS
Closing delimiter indicating the end of an explicit page range.
.RE
.TP
.BR range_open " <char>"
\'(\'
.RS
Opening delimiter indicating the beginning of an explicit page range.
.RE
.\"---------------------------------------------------------------------
.SS "OUTPUT STYLE SPECIFIERS"
.TP 25
.BR preamble " <string>"
"\\\\begin{theindex}\\n"
.RS
Preamble of output file.
.RE
.TP
.BR postamble " <string>"
"\\n\\n\\\\end{theindex}\\n"
.RS
Postamble of output file.
.RE
.TP
.BR setpage_prefix " <string>"
"\\n  \\\\setcounter{page}{"
.RS
Prefix of command which sets the starting page number.
.RE
.TP
.BR setpage_suffix " <string>"
"}\\n"
.RS
Suffix of command which sets the starting page number.
.RE
.TP
.BR group_skip " <string>"
"\\n\\n  \\\\indexspace\\n"
.RS
Vertical space to be inserted before a new group begins.
.RE
.TP
.BR headings_flag " <string>"
0
.RS
Flag indicating treatment of new group headers, which are inserted
when before a new group (symbols, numbers, and the 26 letters):
positive values cause an uppercase letter to be inserted between
prefix and suffix, and negative values cause a lowercase letter to be
inserted (default is 0, which produces no header).
.RE
.TP
.BR heading_prefix " <string>"
""
.RS
Header prefix to be inserted before a new letter begins.
.RE
.TP
.BR symhead_positive " <string>"
"Symbols"
.RS
Heading for symbols to be inserted if
.B headings_flag
is positive.
.RE
.TP
.BR symhead_negative " <string>"
"symbols"
.RS
Heading for symbols to be inserted if
.B headings_flag
is negative.
.RE
.TP
.BR numhead_positive " <string>"
"Numbers"
.RS
Heading for numbers to be inserted if
.B headings_flag
is positive.
.RE
.TP
.BR numhead_negative " <string>"
"numbers"
.RS
Heading for numbers to be inserted if
.B headings_flag
is negative.
.RE
.TP
.BR item_0 " <string>"
"\\n  \\\\item "
.RS
Command to be inserted between two primary (level 0) items.
.RE
.TP
.BR item_1 " <string>"
"\\n     \\\\subitem "
.RS
Command to be inserted between two secondary (level 1) items.
.RE
.TP
.BR item_2 " <string>"
"\\n       \\\\subsubitem "
.RS
Command to be inserted between two level 2 items.
.RE
.TP
.B item_01 " <string>"
"\\n    \\\\subitem "
.RS
Command to be inserted between a level 0 item and a level 1 item.
.RE
.TP
.BR item_x1 " <string>"
"\\n    \\\\subitem "
.RS
Command to be inserted between a level 0 item and a level 1 item,
where the level 0 item does not have associated page numbers.
.RE
.TP
.BR item_12 " <string>"
"\\n    \\\\subsubitem "
.RS
Command to be inserted between a level 1 item and a level 2 item.
.RE
.TP
.BR item_x2 " <string>"
"\\n    \\\\subsubitem "
.RS
Command to be inserted between a level 1 item and a level 2 item,
where the level 1 item does not have associated page numbers.
.RE
.TP
.BR delim_0 " <string>"
", "
.RS
Delimiter to be inserted between a level 0 key and its first page number
(default: comma followed by a blank).
.RE
.TP
.BR delim_1 " <string>"
", "
.RS
Delimiter to be inserted between a level 1 key and its first page number
(default: comma followed by a blank).
.RE
.TP
.BR delim_2 " <string>"
", "
.RS
Delimiter to be inserted between a level 2 key and its first page number
(default: comma followed by a blank).
.RE
.TP
.BR delim_n " <string>"
", "
.RS
Delimiter to be inserted between two page numbers for the same key
in any level (default: comma followed by a blank).
.RE
.TP
.BR delim_r " <string>"
"--"
.RS
Delimiter to be inserted between the starting and ending page numbers
of a range.
.RE
.TP
.BR delim_t " <string>"
""
.RS
Delimiter to be inserted at the end of a page list.  This delimiter
has no effect on entries which have no associated page list.
.RE
.TP
.BR encap_prefix " <string>"
"\\\\"
.RS
First part of prefix for the command which encapsulates the page number.
.RE
.TP
.BR encap_infix " <string>"
"{"
.RS
Second part of prefix for the command which encapsulates the page
number.
.RE
.TP
.BR encap_suffix " <string>"
"}".
.RS
Suffix for the command which encapsulates the page number.
.RE
.TP
.BR line_max " <number>"
72
.RS
Maximum length of a line in the output, beyond which a line wraps.
.RE
.TP
.BR indent_space " <string>"
"\\t\\t"
.RS
Space to be inserted in front of a wrapped line (default: two tabs).
.RE
.TP
.BR indent_length " <number>"
16
.RS
Length of
.B indent_space
(default: 16, equivalent to 2 tabs).
.RE
.TP
.BR suffix_2p " <string>"
""
.RS
Delimiter to replace the range delimiter and the second page number of
a two page list. When present, it overrides
.BR delim_r .
Example: "f.".
.RE
.TP
.BR suffix_3p " <string>"
""
.RS
Delimiter to replace the range delimiter and the second page number of
a three page list. When present, it overrides
.B delim_r
and
.BR suffix_mp .
Example: "ff.".
.RE
.TP
.BR suffix_mp " <string>"
""
.RS
Delimiter to replace the range delimiter and the second page number of
a multiple page list (three or more pages). When present, it overrides
.BR delim_r .
Example: "f.".
.RE
.\"=====================================================================
.SH EXAMPLES
.\"---------------------------------------------------------------------
.SS "\*(TX EXAMPLE"
The following example shows a style file called
.IR book.ist ,
which defines an index for a book which can be formatted independently
of the main source:
.LP
.RS
.nf
\fCpreamble
"\\\\documentstyle[12pt]{book}
\\\\begin{document}
\\\\begin{theindex}
{\\\\small\\n"
postamble
"\\n\\n}
\\\\end{theindex}
\\\\end{document}\\n\fP"
.fi
.RE
.LP
Assuming that a particular book style requires the index (as well as any
chapters) to start from an odd page number, and that the input file is
named
.IR foo.idx ,
the following command line produces output in file
.IR footmp.ind :
.LP
.RS
\fCmakeindex  \-s book.ist  \-o footmp.ind  \-p odd  foo\fP
.RE
.LP
Here a non-default output file name is used to avoid clobbering the
output for the book itself (presumably
.IR foo.dvi ,
which would have been the default name for the index output file!).
.\"---------------------------------------------------------------------
.SS "TROFF EXAMPLE"
A sample control file for creating an index, which we will assume
resides in the file
.IR sample.ist :
.LP
.RS
.nf
\&\fCkeyword "IX:"
\&preamble
\&".\\\\\\" start of index output
\&\\".\\\\\\" enter two column mode
\&.2C
\&.SH
\&.ce
\&INDEX
\&.XS
\&INDEX
\&.XE
\&.R
\&.ps 9p
\&.vs 11p
\&.sp
\&.de I1
\&.ti 0.25i
\&..
\&.de I2
\&.ti 0.5i
\&.."
\&postamble "\\n.\\\\\\" end of index output"
\&setpage_prefix "\\n.nr % "
\&setpage_suffix ""
\&group_skip "\\n.sp 1.0"
\&headings_flag 1
\&heading_prefix "\\n.IS\\n"
\&heading_suffix "\\n.IE"
\&item_0 "\\n.br\\n"
\&item_1 "\\n.I1\\n"
\&item_2 "\\n.I2\\n"
\&item_01 "\\n.I1\\n"
\&item_x1 "\\n.I1\\n"
\&item_12 "\\n.I2\\n"
\&item_x2 "\\n.I2\\n"
\&delim_0 ", "
\&delim_1 ", "
\&delim_2 ", "
\&delim_r "-"
\&delim_t "."
\&encap_prefix "\\\\fB"
\&encap_infix ""
\&encap_suffix "\\\\fP"
\&indent_space ""
\&indent_length 0\fP
.fi
.RE
.LP
The local macro package may require modification, as in this example
of an extension to the
.B \-ms
macros (note that at some sites, this macro should
.I replace
a pre-existing macro of the same name):
.LP
.RS
.nf
\fC\&.\" IX - index words to stderr
\&.de IX
\&.ie '\\\\n(.z'' .tm IX: \\\\$1 \\\\$2 \\\\$3 \\\\$4 \\\\$5 \\\\$6 \\\\$7 \\\\$8 \\\\$9 {\\\\n(PN}
\&.el \\\\!.IX \\\\$1 \\\\$2 \\\\$3 \\\\$4 \\\\$5 \\\\$6 \\\\$7 \\\\$8 \\\\$9 {\\\\n(PN}
\&..\fP
.fi
.RE
.LP
(note that the string {\fC\\\\n(PN\fP} is separated from the rest of the
line by a tab.
If your local macro package does not contain this extension,
just include those lines at the beginning of your file.
Here is a simple
.IR troff (1)
input file, which we will assume is named
.IR sample.txt :
.LP
.RS
.nf
\fC\&This is a sample file to test the \\fImakeindex\\fP(1L)
\&program, and see
\&.IX {indexing!programs!C language}
\&.IX {makeindex@\\fImakeindex\\fP(1L)}
\&.bp
\&.rs
\&.IX {Knuth}
\&.IX {typesetting!computer-aided}
\&how well it functions in the \\fItroff\\fP(1) environment.\fP
.fi
.RE
.LP
Note that index entries are indicated by the
.B .IX
macro, which
causes the following text to be written to
.I stdout
along with the
current page number.
.\"---------------------------------------------------------------------
.SS "CREATING THE INDEX FILE IN THE BOURNE SHELL"
To create an input file for
.IR makeindex ,
.B "in the Bourne shell"
environment, do the equivalent at your site of the command:
.LP
.nf
\fCpsroff -ms -Tpsc -t sample.txt > /dev/null 2> sample.tmp\fP
.fi
.LP
Some sites will require
.I ditroff
instead of
.IR psroff .
To filter out any genuine error messages, invoke
.IR grep (1):
.LP
.RS
\fCgrep '^IX: ' sample.tmp > sample.idx\fP
.RE
.\"---------------------------------------------------------------------
.SS "CREATING THE INDEX FILE USING \*(Uc ENHANCED TROFF/\*(Ts"
With \*(Uc Enhanced troff/\*(Ts, the
.B \-I
option of
.IR psroff (1L)
can produce both formatter output and an index file:
.LP
.RS
\fCpsroff -ms -I sample.inp -Tpsc sample.txt\fP
.RE
.LP
If it is wished to suppress the formatter output:
.RS
.LP
.nf
\fCpsroff -ms -I sample.inp -Tpsc -t sample.txt > /dev/null\fP
.fi
.RE
.\"---------------------------------------------------------------------
.SS "COMPLETING THE INDEX"
Any of the above procedures leaves the input for
.I makeindex
in
.IR sample.inp .
The next step is to invoke
.IR makeindex :
.LP
.RS
\fCmakeindex -s sample.ist sample.idx\fP
.RE
.LP
This leaves
.IR troff (1)-ready
output in the file
.IR sample.ind .
.\"=====================================================================
.SH "ORDERING"
By default,
.I makeindex
assumes
.IR "word ordering" ;
if the
.B \-l
option is in effect,
.I "letter ordering"
is used.  In word ordering, a blank precedes any letter in the
alphabet, whereas in letter ordering, it does not count at all.  This
is illustrated by the following example:
.LP
.RS
\fIword order                      letter order\fP
.br
sea lion                        seal
.br
seal                            sea lion
.RE
.LP
Numbers are always sorted in numeric order.  For instance,
.LP
.RS
9 (nine),  123
.br
10 (ten), see Derek, Bo
.RE
.LP
Letters are first sorted without regard to case; when words are
identical, the uppercase version precedes its lowercase counterpart.
.LP
A special symbol is defined here to be any character not appearing in
the union of digits and the English alphabetic characters.  Patterns
starting with special symbols precede numbers, which precede patterns
starting with letters.  As a special case, a string starting with a
digit but mixed with non-digits is considered to be a pattern starting
with a special character.
.\"=====================================================================
.SH "SPECIAL EFFECTS"
Entries such as
.LP
.RS
.nf
\fC\\indexentry{alpha}{1}
\\indexentry{alpha!beta}{3}
\\indexentry{alpha!beta!gamma}{10}\fP
.fi
.RE
.LP
in the input file will be converted to
.LP
.RS
.nf
\fC\\item alpha, 1
\0\0\0\\subitem beta, 3
\0\0\0\0\0\0\\subsubitem gamma, 10\fP
.fi
.RE
.LP
in the output index file.
Notice that the
.B level
symbol (`!') is used above to delimit
hierarchical levels.
.LP
It is possible to make an item appear in a designated form by
using the
.B actual
(`@') operator.  For instance,
.LP
.RS
\fC\\indexentry{alpha@{\\it alpha\\/}}{1}\fP
.RE
.LP
will become
.LP
.RS
\fC\\item {\\it alpha\\/},  1\fP
.RE
.LP
after processing.  The pattern preceding `@' is
used as sort key, whereas the one following it is written to the
output file.  Note that two appearances of the same key, one with and
one without the
.B actual
operator, are regarded as
.I distinct
entries.
.LP
The item, subitem, and subsubitem fields may have individual sort keys:
.LP
.RS
.nf
\fC\\indexentry{aa@{\\it aa\\/}!bb@{\\it bb\\/}!cc@{\\it cc\\/}}{1}\fP
.fi
.RE
.LP
This will be converted to
.LP
.RS
.nf
\fC\\item {\\it aa}, 1
\0\0\0\\subitem {\\it bb}, 3
\0\0\0\0\0\0\\subsubitem {\\it cc}, 10\fP
.fi
.RE
.LP
It is possible to encapsulate a page number with a designated
command using the
.B encap
(`|') operator:
.LP
.RS
\fC\\indexentry{alpha|bold}{1}\fP
.RE
.LP
will be converted to
.LP
.RS
\fC\\item alpha, \\bold{1}\fP
.RE
.LP
where, with a suitable definition for \*(TX, \fC\\bold{n}\fP
will expand to \fC{\\bf n}\fP.
In this example, the three output attributes associated with page
encapsulation
.BR encap_prefix ,
.BR encap_infix ,
and
.BR encap_suffix ,
correspond to backslash, left brace, and right brace, respectively.
This mechanism allows page numbers to be set in different fonts.  For
example, the page where the definition of a keyword appears can be in
one font, the location of a primary example can be in another font,
and other appearances in yet a third font.
.LP
The
.B encap
operator can also be used to create cross references in
the index:
.LP
.RS
\fC\\indexentry{alpha|see{beta}}{1}\fP
.RE
.LP
will become
.LP
.RS
\fC\\item alpha, \\see{beta}{1}\fP
.RE
.LP
in the output file, where
.LP
.RS
\fC\\see{beta}{1}\fP
.RE
.LP
will expand to
.LP
.RS
\fC{\\it see\\/} beta\fP
.RE
.LP
Note that in a cross reference like this the page number disappears.
.LP
A pair of
.B encap
concatenated with
.B range_open
(`|(') and
.B range_close
(`|)') creates an explicit page range:
.LP
.RS
.nf
\fC\\indexentry{alpha|(}{1}
\\indexentry{alpha|)}{5}\fP
.fi
.RE
.LP
will become
.LP
.RS
\fC\\item alpha, 1\(em5\fP
.RE
.LP
Intermediate pages indexed by the same key will be merged into the
range implicitly.  This is especially useful when an entire section
about a particular subject is to be indexed, in which case only the
range opening and closing operators need to be inserted at the
beginning and end of the section.  Explicit page range formation can
also include an extra command to set the page range in a designated
font:
.LP
.RS
.nf
\fC\\indexentry{alpha|(bold}{1}
\\indexentry{alpha|)}{5}\fP
.fi
.RE
.LP
will become
.LP
.RS
\fC\\item alpha, \\bold{1--5}\fP
.RE
.LP
Several potential problems are worth mentioning.  First, entries like
.LP
.RS
.nf
\fC\\indexentry{alpha|(}{1}
\\indexentry{alpha|bold}{3}
\\indexentry{alpha|)}{5}\fP
.fi
.RE
.LP
will be interpreted as
.LP
.RS
\fC\\item alpha, \\bold{3}, 1--5\fP
.RE
.LP
but with a warning message in the transcript about encountering an
inconsistent page encapsulator.
An explicit range beginning in a Roman page number and ending
in Arabic is also considered an error.  In this instance, (if
possible) the range is broken into two subranges, one in Roman and the
other in Arabic.  For instance,
.LP
.RS
.nf
\fC\\indexentry{alpha|(}{i}
\\indexentry{alpha}{iv}
\\indexentry{alpha}{3}
\\indexentry{alpha|)}{7}\fP
.fi
.RE
.LP
will be turned into
.LP
.RS
\fC\\item alpha, i--iv, 3--7\fP
.RE
.LP
with a warning message in the transcript file complaining about an
illegal range formation.
.LP
Finally, every special symbol mentioned in this section may be
escaped by the
.B quote
operator (`"').  Thus
.LP
.RS
\fC\\indexentry{alpha"@beta}{1}\fP
.RE
.LP
will actually become
.LP
.RS
\fC\\item alpha@beta,  1\fP
.RE
.LP
as a result of executing
.IR makeindex .
The quoting power of
.B quote
is eliminated if it is immediately preceded
by
.B escape
(`\\').  For example,
.LP
.RS
\fC\\indexentry{f\\"ur}{1}\fP
.RE
.LP
becomes
.LP
.RS
\fC\\item f\\"ur, 1\fP
.RE
.LP
which represents an umlaut-accented `u' to the \*(TX family of
processors.
.PP
From version 2.11 of
.IR makeindex ,
the
.B quote
operator may quote
.I any
character in the range 1 .\|.\|. 255.   Character 0 is excluded because
it is used internally in the
.I makeindex
source code as a string terminator.  With this change, sort keys can
be created for all eight-bit characters except 0.  The sorting order
is
.RS
.nf

punctuation characters (in ASCII order),
digits,
control characters (1 .\|.\|. 31),
space (32),
letters (ignoring case),
characters 127 .\|.\|. 255.

.fi
.RE
Here is an example showing the indexing of all printable ASCII
characters other than letters and digits, assuming the default
\*(TX format.  For convenience, the page number references are
the corresponding ASCII ordinal values.
.RS
.nf

\fC\\indexentry{" @"  (space)}{32}
\\indexentry{"!@"! (exclamation point)}{33}
\\indexentry{""@"" (quotation mark)}{34}
\\indexentry{"#@"\\# (sharp sign)}{35}
\\indexentry{"$@"\\$ (dollar sign)}{36}
\\indexentry{"%@"\\% (percent sign)}{37}
\\indexentry{"&@"\\& (ampersand)}{38}
\\indexentry{"<@"$<$ (left angle bracket)}{60}
\\indexentry{"=@"= (equals)}{61}
\\indexentry{">@"$>$ (right angle bracket)}{62}
\\indexentry{"?@"? (query)}{63}
\\indexentry{"@@"@ (at sign)}{64}
\\indexentry{"[@"[ (left square bracket)}{91}
\\indexentry{"\\@"\\verb=\\= (backslash)}{92}
\\indexentry{"]@"] (right square bracket)}{93}
\\indexentry{"^@"\\verb=^= (caret)}{94}
\\indexentry{"_@"\\verb=_= (underscore)}{95}
\\indexentry{"`@"\\verb=~= (grave accent)}{96}
\\indexentry{"{@"\\"{ (left brace)}{123}
\\indexentry{"|@"\\verb="|= (vertical bar)}{124}
\\indexentry{"}@"\\"} (right brace)}{125}
\\indexentry{"~@"\\verb=~= (tilde)}{126}\fP

.fi
.RE
Characters in the actual fields following the `@' character which
have special significance to \*(TX must be represented as control
sequences, or as math mode characters.  Note particularly how the
entries for the at sign, left and right braces, and the vertical
bar, are coded.  The index file output by
.I makeindex
for this example looks like this:
.RS
.nf

\fC\\begin{theindex}

  \\item ! (exclamation point), 33
  \\item " (quotation mark), 34
  \\item \\# (sharp sign), 35
  \\item \\$ (dollar sign), 36
  \\item \\% (percent sign), 37
  \\item \\& (ampersand), 38
  \\item $<$ (left angle bracket), 60
  \\item = (equals), 61
  \\item $>$ (right angle bracket), 62
  \\item ? (query), 63
  \\item @ (at sign), 64
  \\item [ (left square bracket), 91
  \\item \\verb=\\= (backslash), 92
  \\item ] (right square bracket), 93
  \\item \\verb=^= (caret), 94
  \\item \\verb=_= (underscore), 95
  \\item \\verb=~= (grave accent), 96
  \\item \\{ (left brace), 123
  \\item \\verb=|= (vertical bar), 124
  \\item \\} (right brace), 125
  \\item \\verb=~= (tilde), 126

  \\indexspace

  \\item   (space), 32

\\end{theindex}\fP
.fi
.RE
.\"=====================================================================
.SH "FILES"
.TP 2.2i
.I /usr/local/bin/makeindex
executable file
.TP
.I /usr/local/lib/tex/macros/idxmac-amstex.tex
\*(TX macro file used by
.I makeindex
.TP
.I /usr/local/lib/tex/macros/idxmac.tex
\*(TX macro file used by
.I makeindex
.TP
.I /usr/local/lib/tex/macros/makeidx.doc
\*(TX macro file used by
.I makeindex
.TP
.I /usr/local/lib/tex/macros/makeidx.sty
\*(TX macro file used by
.I makeindex
.\"=====================================================================
.SH "SEE ALSO"
ditroff(1L),
latex(1L),
make.index (1L),
qsort(3),
tex(1L),
troff(1L)
.LP
.IR "\*(Uc Enhanced troff/\*(Ts \(em An Overview" ,
R. P. C. Rodgers and Conrad Huang, LSMB Technical Report 90-2,
UCSF School of Pharmacy, San Francisco, 1990.
.LP
.IR "Index Preparation and Processing" ,
Pehong Chen and Michael A. Harrison,
.IR "Software: Practice and Experience" ,
.BR 19 (9),
897\(en915,
September 1988.
.LP
.IR "Automating Index Preparation" ,
Pehong Chen and Michael A. Harrison.  Technical Report 87/347,
Computer Science Division, University of California, Berkeley, 1987
(a \*(LX document supplied with
.IR makeindex ).
.LP
.IR "MakeIndex: An Index Processor for \*(LX" ,
Leslie Lamport, February 1987 (a \*(LX document supplied
with
.IR makeindex ).
.LP
.IR "Tools for Printing Indices" ,
Jon L. Bentley and Brian W. Kernighan,
.IR "Electronic Publishing \(em Origination, Dissemination, and Design" ,
1(1), 3\(en18, June 1988 (also available as: Computing Science
Technical Report No. 128,
AT&T Bell Laboratories, Murray Hill, NJ 07974, 1986).
.\"=====================================================================
.SH "AUTHOR"
Pehong Chen, Chen & Harrison International Systems, Inc.
Palo Alto, California, USA <chen@renoir.berkeley.edu>.
.br
Manual page extensively revised and corrected, and
.IR troff (1)
examples created by Rick P. C. Rodgers, UCSF School
of Pharmacy <rodgers@cca.ucsf.edu>.
.\"=====================================================================
.SH ACKNOWLEDGMENTS
Leslie Lamport contributed significantly to the design.
Michael Harrison provided valuable comments and suggestions.
Nelson Beebe improved on the portable version, and maintains the
source distribution for the \*(TX Users Group.
Andreas Brosig contributed to the German word ordering.
The modification to the
.B \-ms
macros was derived from a method proposed by Ravi Sethi of AT&T
Bell Laboratories.
The
.I LOG
and
.I CONTRIB
files in the
.I makeindex
source distribution record other contributions.
