/*****************************************************************************/
/*									     */
/*									     */
/*	CP/M emulator version 0.1					     */
/*									     */
/*	written by Michael Bischoff (mbi@mo.math.nat.tu-bs.de)		     */
/*	June-1994							     */
/*									     */
/*	This file is distributed under the GNU COPYRIGHT		     */
/*	see COPYRIGHT.GNU for Copyright details				     */
/*									     */
/*									     */
/*****************************************************************************/
#include "cpmemu.h"
#include <unistd.h>

int debug = 0;
int prompt = 1;
int bdos_emulate = 1;	/* default = ON */
int silent_exit = 0;
int restricted_mode = 0;
int hardware_access = 0;
jmp_buf mainloop;

int main(int argc, char *argv[]) {
    int i;
    const char *systemfile = CPMLIBDIR "/cpm.sys";
    const char *load_file = NULL;
    const char *cpmtty = NULL;
    const char *startdir = NULL;
    /* which disk to use? */
    const char *imagefile = "/dev/fd1";	/* use setfdprm to set 10 sectors/track */
    /* when setting dpb, you may ignore the fields BLM, EXM, AL0, and AL1. They are set by bios.c */
    static struct dpb dpb0 = { 80, 4, 15, 0, 394, 255, 0xf0, 0x00, 64, 1 };

    for (i = 1; i < argc; ++i) {
	if (!strcmp(argv[i], "-?") || !strcmp(argv[i], "-h")) {
	    fprintf(stderr, "usage: cpm [options] CP/M-command\n"
		    "where options are\n"
		    "-h or -?        display this message\n"
		    "-s (systemfile) use a different CCP/BDOS\n"
		    "-i (imagefile)  use a different Cp/M disk image\n"
		    "-p              no debugging prompt (for batch)\n"
		    "-d              enter debugging mode\n"
		    "-e              do not emulate BDOS (use imagefile)\n"
		    "-t (tty)        use (tty) for Cp/M console\n"
		    "-r              restricted mode: do not allow changing directories\n"
		    "-D (dir)        specify starting directory\n"
		    "-d              enter debugging mode at start\n"
		    "Note: Pressing ctrl-@ will enter the debugger\n");
	    exit(1);
	} else if (!strcmp(argv[i], "-d"))
	    debug = 1;
	else if (!strcmp(argv[i], "-e"))
	    bdos_emulate ^= 1;
	else if (!strcmp(argv[i], "-r"))
	    restricted_mode ^= 1;
	else if (!strcmp(argv[i], "-p"))
	    prompt = 0;
	else if (!strcmp(argv[i], "-H"))
	    hardware_access = 1;	/* must be root to use this! */
	else if (!strcmp(argv[i], "-t"))
	    cpmtty = argv[++i];
	else if (!strcmp(argv[i], "-l"))
	    load_file = argv[++i];
	else if (!strcmp(argv[i], "-s"))
	    systemfile = argv[++i];
	else if (!strcmp(argv[i], "-D"))
	    startdir = argv[++i];
	else if (!strcmp(argv[i], "-i"))
	    imagefile = argv[++i];
	else
	    break;
    }

    /* setup BIOS part of memory image */
    if (hardware_access)
	lowlevel_init();
    cpm_init(imagefile, systemfile, &dpb0);
    setup_io(cpmtty);		/* setting I/O to no-echo */
    if (load_file)
	loadfile(load_file);
    cpminit2(argc-i, argv+i);
    if (startdir)
	if (chdir(startdir)) {
	    fprintf(stderr, "Cannot change directory to %s\n", startdir);
	    exit(1);
	}
    for (;;) {
	while (setjmp(mainloop))
	    ;
	if (debug) {
	    debug = 1;
	    commandloop();
	} else {
	    z80run();	/* run until trap */
	    debug = 1;
	    /* break; */
	}
    }
    return 0;
}
