#
# Put a nologin file in /etc to prevent people from logging in before
# system startup is complete.
#
if [ "$DELAYLOGIN" = yes ]
then
  echo "System bootup in progress - please wait" > /etc/nologin
  cp /etc/nologin /etc/nologin.boot
fi

#
# Wipe /tmp (and don't erase `lost+found', `quota.user' or `quota.group')!
# Note that files _in_ lost+found _are_ deleted.
#
[ "$VERBOSE" != no ] && echo -n "Cleaning: /tmp "
( cd /tmp && \
  find . -xdev \
  ! -ctime -$TMPTIME \
  ! -name . \
  ! \( -name lost+found -uid 0 \) \
  ! \( -name quota.user -uid 0 \) \
  ! \( -name quota.group -uid 0 \) \
    -depth -exec rm -rf -- {} \; )
#
# Clean up any stale locks.
#
[ "$VERBOSE" != no ] && echo -n "/var/lock "
( cd /var/lock && find . -type f -exec rm -f -- {} \; )
#
# Clean up /var/run and create /var/run/utmp so that we can login.
#
[ "$VERBOSE" != no ] && echo -n "/var/run "
( cd /var/run && \
	find . ! -type d ! -name utmp ! -name innd.pid ! -name random-seed \
	-exec rm -f -- {} \; )
: > /var/run/utmp
[ "$VERBOSE" != no ] && echo "."

#
# Set pseudo-terminal access permissions.
#
chmod 666 /dev/tty[p-za-e][0-9a-f]
chown root:tty /dev/tty[p-za-e][0-9a-f]

#
# Update /etc/motd.
#
if [ "$EDITMOTD" != no ]
then
	uname -a > /etc/motd.tmp
	sed 1d /etc/motd >> /etc/motd.tmp
	mv /etc/motd.tmp /etc/motd
fi

