/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class Serializer
extends FilterOutputStream {
    private static boolean[] unsafeChars;
    private static int SMALL_STRING_LIMIT;
    private final int BUF_LEN = 128;
    private byte[] buf = new byte[128];
    private int bufIndex;

    public Serializer(OutputStream outputStream) {
        super(outputStream);
    }

    private void flushBuffer() throws IOException {
        if (this.bufIndex > 0) {
            this.write(this.buf, 0, this.bufIndex);
            this.bufIndex = 0;
        }
    }

    final void writeOutput(int n) throws IOException {
        if (this.bufIndex >= 128) {
            this.flushBuffer();
        }
        this.buf[this.bufIndex++] = (byte)n;
    }

    private final void serializeHashtable(Hashtable hashtable) throws IOException {
        Enumeration enumeration = hashtable.keys();
        this.writeOutput(123);
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = hashtable.get(object);
            if (object instanceof String) {
                this.serializeString((String)object);
            } else {
                this.serializeObjectInternal(object);
            }
            this.writeOutput(61);
            if (object2 instanceof String) {
                this.serializeString((String)object2);
            } else {
                this.serializeObjectInternal(object2);
            }
            this.writeOutput(59);
        }
        this.writeOutput(125);
    }

    private final void serializeArray(Object[] objectArray) throws IOException {
        this.writeOutput(91);
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object object = objectArray[n];
            if (object instanceof String) {
                this.serializeString((String)object);
            } else {
                this.serializeObjectInternal(object);
            }
            if (n < n2 - 1) {
                this.writeOutput(44);
            }
            ++n;
        }
        this.writeOutput(93);
    }

    private final void serializeVector(Vector vector) throws IOException {
        this.writeOutput(40);
        int n = 0;
        int n2 = vector.count();
        while (n < n2) {
            Object object = vector.elementAt(n);
            if (object instanceof String) {
                this.serializeString((String)object);
            } else {
                this.serializeObjectInternal(object);
            }
            if (n < n2 - 1) {
                this.writeOutput(44);
            }
            ++n;
        }
        this.writeOutput(41);
    }

    final boolean stringRequiresQuotes(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c >= '\u007f') {
                return true;
            }
            if (unsafeChars[c]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final boolean stringRequiresQuotes(char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            char c = cArray[n];
            if (c >= '\u007f') {
                return true;
            }
            if (unsafeChars[c]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final int fourBitToAscii(int n) {
        if (n < 10) {
            return 48 + n;
        }
        return 65 + (n - 10);
    }

    void serializeString(String string) throws IOException {
        int n;
        boolean bl = false;
        boolean bl2 = true;
        char[] cArray = null;
        if (string == null || (n = string.length()) == 0) {
            this.writeOutput(34);
            this.writeOutput(34);
            return;
        }
        if (n <= 8) {
            bl2 = false;
        } else {
            bl2 = true;
            cArray = string.toCharArray();
        }
        bl = n > SMALL_STRING_LIMIT ? true : (bl2 ? this.stringRequiresQuotes(cArray) : this.stringRequiresQuotes(string));
        if (bl) {
            this.writeOutput(34);
        }
        int n2 = 0;
        while (n2 < n) {
            char c = bl2 ? cArray[n2] : string.charAt(n2);
            if (c < '\u00ff') {
                if (c >= '#' && c <= '~' && c != '\\') {
                    this.writeOutput(c);
                } else {
                    switch (c) {
                        case ' ': 
                        case '!': {
                            this.writeOutput(c);
                            break;
                        }
                        case '\"': {
                            this.writeOutput(92);
                            this.writeOutput(34);
                            break;
                        }
                        case '\t': {
                            this.writeOutput(92);
                            this.writeOutput(116);
                            break;
                        }
                        case '\n': {
                            this.writeOutput(92);
                            this.writeOutput(110);
                            break;
                        }
                        case '\r': {
                            this.writeOutput(92);
                            this.writeOutput(114);
                            break;
                        }
                        case '\\': {
                            this.writeOutput(92);
                            this.writeOutput(92);
                            break;
                        }
                        default: {
                            this.writeOutput(92);
                            this.writeOutput(48 + (c >> 6));
                            this.writeOutput(48 + (c >> 3 & 7));
                            this.writeOutput(48 + (c & 7));
                            break;
                        }
                    }
                }
            } else {
                this.writeOutput(92);
                this.writeOutput(117);
                this.writeOutput(this.fourBitToAscii(c >> 12));
                this.writeOutput(this.fourBitToAscii(c >> 8 & 0xF));
                this.writeOutput(this.fourBitToAscii(c >> 4 & 0xF));
                this.writeOutput(this.fourBitToAscii(c & 0xF));
            }
            ++n2;
        }
        if (bl2) {
            cArray = null;
        }
        if (bl) {
            this.writeOutput(34);
        }
    }

    final void serializeNull() throws IOException {
        this.writeOutput(64);
    }

    private final void serializeObjectInternal(Object object) throws IOException {
        if (object instanceof String) {
            this.serializeString((String)object);
            return;
        }
        if (object instanceof Hashtable) {
            this.serializeHashtable((Hashtable)object);
            return;
        }
        if (object instanceof Object[]) {
            this.serializeArray((Object[])object);
            return;
        }
        if (object instanceof Vector) {
            this.serializeVector((Vector)object);
            return;
        }
        if (object == null) {
            this.serializeNull();
            return;
        }
        this.serializeString(object.toString());
    }

    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    public void writeObject(Object object) throws IOException {
        this.serializeObjectInternal(object);
    }

    public static String serializeObject(Object object) {
        String string = null;
        if (object == null) {
            string = null;
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            Serializer serializer = new Serializer(byteArrayOutputStream);
            try {
                serializer.writeObject(object);
                serializer.flush();
            }
            catch (IOException iOException) {}
            string = byteArrayOutputStream.toString();
            try {
                serializer.close();
                ((OutputStream)byteArrayOutputStream).close();
            }
            catch (IOException iOException) {}
            byteArrayOutputStream = null;
            serializer = null;
        }
        return string;
    }

    public static boolean writeObject(OutputStream outputStream, Object object) {
        try {
            Serializer serializer = new Serializer(outputStream);
            serializer.writeObject(object);
            serializer.flush();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static {
        SMALL_STRING_LIMIT = 40;
        unsafeChars = new boolean[127];
        int n = 0;
        while (n < 32) {
            Serializer.unsafeChars[n] = true;
            ++n;
        }
        Serializer.unsafeChars[32] = true;
        Serializer.unsafeChars[34] = true;
        Serializer.unsafeChars[91] = true;
        Serializer.unsafeChars[93] = true;
        Serializer.unsafeChars[44] = true;
        Serializer.unsafeChars[40] = true;
        Serializer.unsafeChars[41] = true;
        Serializer.unsafeChars[123] = true;
        Serializer.unsafeChars[125] = true;
        Serializer.unsafeChars[61] = true;
        Serializer.unsafeChars[59] = true;
        Serializer.unsafeChars[47] = true;
        Serializer.unsafeChars[64] = true;
        Serializer.unsafeChars[33] = true;
        Serializer.unsafeChars[35] = true;
        Serializer.unsafeChars[36] = true;
        Serializer.unsafeChars[37] = true;
        Serializer.unsafeChars[38] = true;
        Serializer.unsafeChars[39] = true;
        Serializer.unsafeChars[58] = true;
        Serializer.unsafeChars[60] = true;
        Serializer.unsafeChars[62] = true;
        Serializer.unsafeChars[63] = true;
        Serializer.unsafeChars[92] = true;
        Serializer.unsafeChars[94] = true;
        Serializer.unsafeChars[96] = true;
        Serializer.unsafeChars[124] = true;
        Serializer.unsafeChars[126] = true;
    }
}

