// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

// File   : $__self$
// Name   : $__alias$
// Status : $__status$
// Changed: $__mtime$

// This is a class to simply the job of maintaining a fixed 
// frames-per-second animation rate in the program.
// Search for "Timer::" in sasteroids.c to see how its used.


#ifndef __Timer__
#define __Timer__

#include <sys/time.h>
#include <unistd.h>


// used to get fixed animation rates on different
// speed computers
class Timer {
    public:
    
    	// set frame rate to 'f' frames per second
    	static void setFrameRate( int f );
	static int  FrameRate() { return VframeRate; }
	    	
    	// call once before entering animation loops
    	static void init();
    
    	// pause required amount of time to get proper frame rate
    	// returns the amount of time passed since last sync() or
    	// init() call in usec.
    	static long sync();

    private:
    	static timeval	VlastClk, VnewClk;
	static long	Vlast, Vnew;
	static long	VfTime, VendSleep;
    	static int VframeRate;
    };


#endif
