/* ARM support for 32-bit ELF
   Copyright 1993, 1995, 1996, 1997 Free Software Foundation, Inc.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "bfd.h"
#include "sysdep.h"
#include "bfdlink.h"
#include "libbfd.h"
#include "elf-bfd.h"

#define USE_REL			/* we want REL relocations, not RELA */

/* ARM relocations */
enum arm_reloc_type
{
  R_ARM_NONE			=   0,
  R_ARM_ADDR32			=   1,
  R_ARM_ADDR16			=   2,
  R_ARM_ADDR8			=   3,
  R_ARM_PCREL_BRANCH		=   4,
  R_ARM_PCREL_BRANCH_DONE	=   5,
  R_ARM_max
};

/* The name of the dynamic interpreter.  This is put in the .interp
   section.  */

#define ELF_DYNAMIC_INTERPRETER "/usr/lib/ld.so.1"

static bfd_reloc_status_type
elf32_arm_fix_pcrel_26	 PARAMS ((bfd *, arelent *, asymbol *, PTR,
				  asection *, bfd *, char **));

static bfd_reloc_status_type
elf32_arm_fix_pcrel_26_done PARAMS ((bfd *, arelent *, asymbol *, PTR,
				  asection *, bfd *, char **));

static reloc_howto_type *arm_elf_howto_table[ (int)R_ARM_max ];

static reloc_howto_type arm_elf_howto_raw[] =
{
  /* This reloc does nothing.  */
  HOWTO (R_ARM_NONE,		/* type */
	 0,			/* rightshift */
	 2,			/* size (0 = byte, 1 = short, 2 = long) */
	 32,			/* bitsize */
	 false,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_bitfield, /* complain_on_overflow */
	 bfd_elf_generic_reloc,	/* special_function */
	 "R_ARM_NONE",		/* name */
	 false,			/* partial_inplace */
	 0,			/* src_mask */
	 0,			/* dst_mask */
	 false),		/* pcrel_offset */

  /* A standard 32 bit relocation.  */
  HOWTO (R_ARM_ADDR32,		/* type */
	 0,			/* rightshift */
	 2,			/* size (0 = byte, 1 = short, 2 = long) */
	 32,			/* bitsize */
	 false,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_bitfield, /* complain_on_overflow */
	 bfd_elf_generic_reloc,	/* special_function */
	 "R_ARM_ADDR32",	/* name */
	 false,			/* partial_inplace */
	 0,			/* src_mask */
	 0xffffffff,		/* dst_mask */
	 false),		/* pcrel_offset */

  /* A standard 16 bit relocation.  */
  HOWTO (R_ARM_ADDR16,		/* type */
	 0,			/* rightshift */
	 1,			/* size (0 = byte, 1 = short, 2 = long) */
	 16,			/* bitsize */
	 false,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_bitfield, /* complain_on_overflow */
	 bfd_elf_generic_reloc,	/* special_function */
	 "R_ARM_ADDR16",	/* name */
	 false,			/* partial_inplace */
	 0,			/* src_mask */
	 0xffff,		/* dst_mask */
	 false),		/* pcrel_offset */

  /* A standard 8 bit relocation.  */
  HOWTO (R_ARM_ADDR8,		/* type */
	 0,			/* rightshift */
	 0,			/* size (0 = byte, 1 = short, 2 = long) */
	 8,			/* bitsize */
	 false,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_bitfield, /* complain_on_overflow */
	 bfd_elf_generic_reloc,	/* special_function */
	 "R_ARM_ADDR16",	/* name */
	 false,			/* partial_inplace */
	 0,			/* src_mask */
	 0xff,			/* dst_mask */
	 false),		/* pcrel_offset */

  /* An ARM 26-bit PC-relative relocation (branch).  */
  HOWTO (R_ARM_PCREL_BRANCH,	/* type */
	 0,			/* rightshift */
	 2,			/* size (0 = byte, 1 = short, 2 = long) */
	 26,			/* bitsize */
	 true,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_signed, /* complain_on_overflow */
	 elf32_arm_fix_pcrel_26, /* special_function */
	 "R_ARM_PCREL26",	/* name */
	 true,			/* partial_inplace */
	 0xffffff,		/* src_mask */
	 0xffffff,		/* dst_mask */
	 true),			/* pcrel_offset */

  /* A done version of the above.  */
  HOWTO (R_ARM_PCREL_BRANCH_DONE, /* type */
	 0,			/* rightshift */
	 2,			/* size (0 = byte, 1 = short, 2 = long) */
	 26,			/* bitsize */
	 false,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_signed, /* complain_on_overflow */
	 elf32_arm_fix_pcrel_26_done, /* special_function */
	 "R_ARM_PCREL26_DONE",	/* name */
	 true,			/* partial_inplace */
	 0,			/* src_mask */
	 0,			/* dst_mask */
	 false),		/* pcrel_offset */
};

/* Initialize the ELF howto_table, so that linear accesses can be done.  */

static void
arm_elf_howto_init ()
{
  unsigned int i, type;

  for (i = 0; i < sizeof (arm_elf_howto_raw) / sizeof (arm_elf_howto_raw[0]); 
       i++)
    {
      type = arm_elf_howto_raw[i].type;
      BFD_ASSERT (type < sizeof(arm_elf_howto_table) / 
		  sizeof(arm_elf_howto_table[0]));
      arm_elf_howto_table[type] = &arm_elf_howto_raw[i];
    }
}

/* Set the howto pointer for an ARM ELF reloc.  */

static void
arm_elf_info_to_howto (abfd, cache_ptr, dst)
     bfd *abfd;
     arelent *cache_ptr;
     Elf32_Internal_Rela *dst;
{
  abort();
}

static void
arm_elf_info_to_howto_rel (abfd, cache_ptr, dst)
     bfd *abfd;
     arelent *cache_ptr;
     Elf32_Internal_Rel *dst;
{
  enum arm_reloc_type type;

  /* Initialize howto table if needed */
  if (!arm_elf_howto_table[R_ARM_ADDR32])
    arm_elf_howto_init ();

  type = (enum reloc_type) ELF32_R_TYPE (dst->r_info);
  BFD_ASSERT (type < R_ARM_max);

  cache_ptr->howto = arm_elf_howto_table[(int) type];
}

static reloc_howto_type *
arm_elf_reloc_type_lookup (abfd, code)
     bfd *abfd;
     bfd_reloc_code_real_type code;
{
  enum arm_reloc_type arm_reloc = R_ARM_NONE;

  /* Initialize howto table if needed */
  if (!arm_elf_howto_table[R_ARM_ADDR32])
    arm_elf_howto_init ();

  switch ((int)code)
    {
    case BFD_RELOC_NONE:		arm_reloc = R_ARM_NONE;			break;
    case BFD_RELOC_32:			arm_reloc = R_ARM_ADDR32;		break;
    case BFD_RELOC_16:			arm_reloc = R_ARM_ADDR16;		break;
    case BFD_RELOC_8:			arm_reloc = R_ARM_ADDR8;		break;
    case BFD_RELOC_ARM_PCREL_BRANCH:	arm_reloc = R_ARM_PCREL_BRANCH;		break;

    default:
      return (reloc_howto_type *)NULL;
    }

  return arm_elf_howto_table[ (int)arm_reloc ];
}



/* Perform a PCREL26 reloc */

static bfd_reloc_status_type
elf32_arm_fix_pcrel_26 (abfd, reloc_entry, symbol, data, input_section,
		       output_bfd, error_message)
     bfd *abfd;
     arelent *reloc_entry;
     asymbol *symbol;
     PTR data;
     asection *input_section;
     bfd *output_bfd;
     char **error_message;
{
  bfd_vma relocation;
  bfd_size_type addr = reloc_entry->address;
  long target = bfd_get_32 (abfd, (bfd_byte *) data + addr);
  bfd_reloc_status_type flag = bfd_reloc_ok;

  /* If this is an undefined symbol, return error */
  if (symbol->section == &bfd_und_section
      && (symbol->flags & BSF_WEAK) == 0)
    return output_bfd ? bfd_reloc_ok : bfd_reloc_undefined;

  /* If the sections are different, and we are doing a partial relocation,
     just ignore it for now.  */
  if (symbol->section->name != input_section->name
      && output_bfd != (bfd *)NULL)
    return bfd_reloc_ok;

  relocation = (target & 0x00ffffff) << 2;
  relocation = (relocation ^ 0x02000000) - 0x02000000; /* Sign extend */
  relocation += symbol->value;
  relocation += symbol->section->output_section->vma;
  relocation += symbol->section->output_offset;
  relocation += reloc_entry->addend;
  relocation -= input_section->output_section->vma;
  relocation -= input_section->output_offset;
  relocation -= addr;
  if (relocation & 3)
    return bfd_reloc_overflow;

  /* Check for overflow */
  if (relocation & 0x02000000)
    {
      if ((relocation & ~0x03ffffff) != ~0x03ffffff)
	flag = bfd_reloc_overflow;
    }
  else if (relocation & ~0x03ffffff)
    flag = bfd_reloc_overflow;

  target &= ~0x00ffffff;
  target |= (relocation >> 2) & 0x00ffffff;
  bfd_put_32 (abfd, target, (bfd_byte *) data + addr);

  /* Now the ARM magic... Change the reloc type so that it is marked as done.
     Strictly this is only necessary if we are doing a partial relocation.  */
  reloc_entry->howto = arm_elf_howto_table[R_ARM_PCREL_BRANCH_DONE];
  
  return flag;
}

static bfd_reloc_status_type
elf32_arm_fix_pcrel_26_done (abfd, reloc_entry, symbol, data, input_section,
		       output_bfd, error_message)
     bfd *abfd;
     arelent *reloc_entry;
     asymbol *symbol;
     PTR data;
     asection *input_section;
     bfd *output_bfd;
     char **error_message;
{
  /* This is dead simple at present.  */
  return bfd_reloc_ok;
}



#define TARGET_LITTLE_SYM		bfd_elf32_arm_vec
#define TARGET_LITTLE_NAME		"elf32-arm"
#define ELF_MACHINE_CODE		EM_ARM
#define ELF_MAXPAGESIZE			0x8000
#define ELF_ARCH		        bfd_arch_arm

#define elf_info_to_howto		arm_elf_info_to_howto
#define elf_info_to_howto_rel		arm_elf_info_to_howto_rel
#define bfd_elf32_bfd_reloc_type_lookup	arm_elf_reloc_type_lookup

#include "elf32-target.h"
