#    Copyright (C) 1995, 1996 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of GNU Ghostscript.
# 
# GNU Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
# anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer to
# the GNU General Public License for full details.
# 
# Everyone is granted permission to copy, modify and redistribute GNU
# Ghostscript, but only under the conditions described in the GNU General
# Public License.  A copy of this license is supposed to have been given to
# you along with GNU Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.
# 
# Aladdin Enterprises is not affiliated with the Free Software Foundation or
# the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
# does not depend on any other GNU software.

# makefile for zlib library code.

# This partial makefile compiles the zlib library for use in Ghostscript.
# You can get the source code for this library from:
#   ftp://ftp.uu.net/pub/archiving/zip/zlib102.zip   (zlib 1.0.2)
#		or zlib-1.0.2.tar.gz
# Please see Ghostscript's `make.txt' file for instructions about how to
# unpack these archives.

# Define the name of this makefile.
ZLIB_MAK=zlib.mak

# ZSRCDIR is defined in the platform-specific makefile, not here,
# as the directory where the zlib sources are stored.
#ZSRCDIR=zlib
ZSRC=$(ZSRCDIR)$(D)
CCCZ=$(CCC) -I$(ZSRCDIR)

# We keep all of the zlib code in a separate directory so as not to
# inadvertently mix it up with Aladdin Enterprises' own code.
ZDEP=$(AK)

# Code common to compression and decompression.

zlibc_=zutil.$(OBJ)
zlibc.dev: $(ZLIB_MAK) $(ECHOGS_XE) $(zlibc_)
	$(SETMOD) zlibc $(zlibc_)

zutil.$(OBJ): $(ZSRC)zutil.c $(ZDEP)
	$(CCCZ) $(ZSRC)zutil.c

# Encoding (compression) code.

zlibe.dev: $(MAKEFILE) zlibe_$(SHARE_ZLIB).dev
	$(CP_) zlibe_$(SHARE_ZLIB).dev zlibe.dev

zlibe_1.dev: $(ZLIB_MAK) $(ECHOGS_XE)
	$(SETMOD) zlibe_1 -lib gz

zlibe_=adler32.$(OBJ) deflate.$(OBJ) trees.$(OBJ)
zlibe_0.dev: $(ZLIB_MAK) $(ECHOGS_XE) zlibc.dev $(zlibe_)
	$(SETMOD) zlibe_0 $(zlibe_)
	$(ADDMOD) zlibe_0 -include zlibc

adler32.$(OBJ): $(ZSRC)adler32.c $(ZDEP)
	$(CCCZ) $(ZSRC)adler32.c

deflate.$(OBJ): $(ZSRC)deflate.c $(ZDEP)
	$(CCCZ) $(ZSRC)deflate.c

trees.$(OBJ): $(ZSRC)trees.c $(ZDEP)
	$(CCCZ) $(ZSRC)trees.c

# Decoding (decompression) code.

zlibd.dev: $(MAKEFILE) zlibd_$(SHARE_ZLIB).dev
	$(CP_) zlibd_$(SHARE_ZLIB).dev zlibd.dev

zlibd_1.dev: $(ZLIB_MAK) $(ECHOGS_XE)
	$(SETMOD) zlibd_1 -lib gz

zlibd1_=infblock.$(OBJ) infcodes.$(OBJ) inffast.$(OBJ)
zlibd2_=inflate.$(OBJ) inftrees.$(OBJ) infutil.$(OBJ)
zlibd_ = $(zlibd1_) $(zlibd2_)
zlibd_0.dev: $(ZLIB_MAK) $(ECHOGS_XE) zlibc.dev $(zlibd_)
	$(SETMOD) zlibd_0 $(zlibd1_)
	$(ADDMOD) zlibd_0 -obj $(zlibd2_)
	$(ADDMOD) zlibd_0 -include zlibc

infblock.$(OBJ): $(ZSRC)infblock.c $(ZDEP)
	$(CCCZ) $(ZSRC)infblock.c

infcodes.$(OBJ): $(ZSRC)infcodes.c $(ZDEP)
	$(CCCZ) $(ZSRC)infcodes.c

inffast.$(OBJ): $(ZSRC)inffast.c $(ZDEP)
	$(CCCZ) $(ZSRC)inffast.c

inflate.$(OBJ): $(ZSRC)inflate.c $(ZDEP)
	$(CCCZ) $(ZSRC)inflate.c

inftrees.$(OBJ): $(ZSRC)inftrees.c $(ZDEP)
	$(CCCZ) $(ZSRC)inftrees.c

infutil.$(OBJ): $(ZSRC)infutil.c $(ZDEP)
	$(CCCZ) $(ZSRC)infutil.c
