/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.peer.DialogPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

class WDialogPeer
extends WWindowPeer
implements DialogPeer {
    Thread currentThread;

    native void create(WComponentPeer var1);

    public native void setTitle(String var1);

    public native void setResizable(boolean var1);

    private native void showModal(boolean var1);

    private native void hideModal();

    private native void disableBrowser();

    private void disableBrowserCheck() {
        if (SecurityManager.isPrivilegeEnabled("UniversalDialogModality")) {
            this.disableBrowser();
        }
    }

    WDialogPeer(Dialog dialog) {
        super(dialog);
        if (dialog.getTitle() != null) {
            this.setTitle(dialog.getTitle());
        }
        this.setResizable(dialog.isResizable());
    }

    public void dispose() {
        this.hide();
        super.dispose();
    }

    public void show() {
        if (((Dialog)this.target).isModal()) {
            this.currentThread = Thread.currentThread();
            if (this.applet != null && this.currentThread == this.applet.getAppletThread()) {
                this.showModal(false);
                this.disableBrowserCheck();
                this.applet.enterModal();
                return;
            }
            if (((WToolkit)this.getToolkit()).getCallbackThread() == this.currentThread) {
                this.disableBrowserCheck();
                this.showModal(true);
                return;
            }
            this.showModal(false);
            Component component = this.target;
            synchronized (component) {
                try {
                    this.target.wait(0L);
                }
                catch (InterruptedException interruptedException) {}
                return;
            }
        }
        super.show();
    }

    public void hide() {
        if (((Dialog)this.target).isModal()) {
            if (this.applet != null && this.currentThread == this.applet.getAppletThread()) {
                this.applet.exitModal();
            } else if (this.currentThread != ((WToolkit)this.getToolkit()).getCallbackThread()) {
                Component component = this.target;
                synchronized (component) {
                    try {
                        this.target.notifyAll();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {}
                }
            }
            this.hideModal();
            return;
        }
        super.hide();
    }

    public synchronized void handleMoved(long l, int n, int n2, int n3) {
        this.target.postEvent(new Event(this.target, 0L, 205, n2, n3, 0, 0));
    }

    public void handleIconify(long l) {
        this.target.postEvent(new Event(this.target, 203, null));
    }

    public void handleDeiconify(long l) {
        this.target.postEvent(new Event(this.target, 204, null));
    }

    protected void handleResize(long l, int n, int n2, int n3, int n4, int n5) {
        this.target.invalidate();
        this.target.validate();
        this.target.repaint();
    }
}

