/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import sun.awt.DrawingSurface;
import sun.awt.DrawingSurfaceInfo;
import sun.awt.ObjectPeer;
import sun.awt.ScreenUpdater;
import sun.awt.UpdateClient;
import sun.awt.windows.WDrawingSurfaceInfo;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WGraphics;
import sun.awt.windows.WImage;
import sun.awt.windows.WToolkit;

public abstract class WComponentPeer
extends ObjectPeer
implements ComponentPeer,
UpdateClient,
DrawingSurface {
    private int updateX1;
    private int updateY1;
    private int updateX2;
    private int updateY2;
    Component target;
    int pNativeWidget;
    int pWinMsg;

    WComponentPeer(Component component) {
        this.target = component;
        Container container = component.getParent();
        this.create((WComponentPeer)(container != null ? container.getPeer() : null));
        this.initialize();
    }

    protected void finalize() {
        if (this.pNativeWidget != 0) {
            this.dispose();
        }
    }

    abstract void create(WComponentPeer var1);

    public void dispose() {
        this.dispose0();
        super.dispose();
    }

    public synchronized native void dispose0();

    public native void show();

    public native void hide();

    public native void enable();

    public native void disable();

    public native void setForeground(Color var1);

    public native void setBackground(Color var1);

    public native void setFont(Font var1);

    public synchronized native void requestFocus();

    public native void nextFocus();

    public native void reshape(int var1, int var2, int var3, int var4);

    public synchronized native boolean handleEvent(Event var1);

    public Dimension minimumSize() {
        return this.target.size();
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public ColorModel getColorModel() {
        return WToolkit.getStaticColorModel();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public Graphics getGraphics() {
        WGraphics wGraphics = new WGraphics(this);
        ((Graphics)wGraphics).setColor(this.target.getForeground());
        ((Graphics)wGraphics).setFont(this.target.getFont());
        return wGraphics;
    }

    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.addRepaintArea(n, n2, n3, n4);
        ScreenUpdater.updater.notify(this, l);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        this.target.paint(graphics);
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        this.target.update(graphics);
    }

    public void print(Graphics graphics) {
        Dimension dimension = this.target.size();
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        this.target.print(graphics);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new WImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return new WImage(n, n2);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public int updatePriority() {
        return 5;
    }

    public void updateClient(Object object) {
        int n;
        int n2;
        int n3;
        int n4;
        WComponentPeer wComponentPeer = this;
        synchronized (wComponentPeer) {
            n4 = this.updateX1;
            n3 = this.updateY1;
            n2 = this.updateX2;
            n = this.updateY2;
            this.updateX1 = this.updateX2;
        }
        if (n4 != n2) {
            this.widget_repaint(n4, n3, n2 - n4, n - n3);
        }
    }

    protected native void widget_repaint(int var1, int var2, int var3, int var4);

    void initialize() {
        Font font;
        if (this.target.isVisible()) {
            this.show();
        } else {
            this.hide();
        }
        Color color = this.target.getForeground();
        if (color != null) {
            this.setForeground(color);
        }
        if ((font = this.target.getFont()) != null) {
            this.setFont(font);
        }
        if (!this.target.isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = this.target.bounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private synchronized void addRepaintArea(int n, int n2, int n3, int n4) {
        if (this.updateX1 == this.updateX2) {
            this.updateX1 = n;
            this.updateY1 = n2;
            this.updateX2 = n + n3;
            this.updateY2 = n2 + n4;
            return;
        }
        if (n < this.updateX1) {
            this.updateX1 = n;
        }
        if (n2 < this.updateY1) {
            this.updateY1 = n2;
        }
        if (n + n3 > this.updateX2) {
            this.updateX2 = n + n3;
        }
        if (n2 + n4 > this.updateY2) {
            this.updateY2 = n2 + n4;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.target + "]";
    }

    private native Event setData(int var1, Event var2);

    protected void handleQuit(long l) {
        Event event = new Event(this.target, 201, null);
        this.target.postEvent(event);
    }

    protected void handleMoved(long l, int n, int n2, int n3) {
    }

    protected void handleResize(long l, int n, int n2, int n3, int n4, int n5) {
    }

    protected void handleGotFocus(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, 1004, null));
        this.target.postEvent(event);
    }

    protected void handleLostFocus(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, 1005, null));
        this.target.postEvent(event);
    }

    protected void handleActionKey(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, l, 403, n2, n3, n4, n5));
        this.target.postEvent(event);
    }

    protected void handleActionKeyRelease(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, l, 404, n2, n3, n4, n5));
        this.target.postEvent(event);
    }

    protected void handleKeyPress(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, l, 401, n2, n3, n4, n5));
        this.target.postEvent(event);
    }

    protected void handleKeyRelease(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, l, 402, n2, n3, n4, n5));
        this.target.postEvent(event);
    }

    protected void handleMouseEnter(long l, int n, int n2, int n3) {
        Event event = new Event(this.target, l, 504, n2, n3, 0, 0, null);
        this.target.postEvent(event);
    }

    protected void handleMouseExit(long l, int n, int n2, int n3) {
        Event event = new Event(this.target, l, 505, n2, n3, 0, 0, null);
        this.target.postEvent(event);
    }

    protected void handleMouseDown(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, l, 501, n2, n3, 0, n5, null));
        event.clickCount = n4;
        this.target.postEvent(event);
    }

    protected void handleMouseUp(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, l, 502, n2, n3, 0, n5, null));
        this.target.postEvent(event);
    }

    protected void handleMouseMoved(long l, int n, int n2, int n3, int n4) {
        Event event = this.setData(n, new Event(this.target, l, 503, n2, n3, 0, n4, null));
        this.target.postEvent(event);
    }

    protected void handleMouseDrag(long l, int n, int n2, int n3, int n4) {
        Event event = this.setData(n, new Event(this.target, l, 506, n2, n3, 0, n4, null));
        this.target.postEvent(event);
    }

    protected void handleExpose(long l, int n, int n2, int n3, int n4, int n5) {
        Graphics graphics = null;
        graphics = this.getGraphics();
        graphics.clipRect(n2, n3, n4, n5);
        this.paint(graphics);
        graphics.dispose();
    }

    protected void handleRepaint(long l, int n, int n2, int n3, int n4, int n5) {
        Graphics graphics = null;
        graphics = this.getGraphics();
        graphics.clipRect(n2, n3, n4, n5);
        this.update(graphics);
        graphics.dispose();
    }

    protected void nativeDragEnter(long l, int n, int n2, int n3, int n4, int n5) {
        System.out.println("nativeDragEnter:\n\tX: " + n2 + "\n\tY: " + n3 + "\n\tpData: " + n4 + "\n\tkeyState: " + n5);
    }

    protected void nativeDragOver(long l, int n, int n2, int n3, int n4) {
        System.out.println("nativeDragOver:\n\tX: " + n2 + "\n\tY: " + n3 + "\n\tkeyState: " + n4);
    }

    protected void nativeDragLeave(long l, int n) {
        System.out.println("nativeDragLeave:");
    }

    protected void nativeDragDrop(long l, int n, int n2, int n3, int n4, int n5) {
        System.out.println("nativeDragEnter:\n\tX: " + n2 + "\n\tY: " + n3 + "\n\tpData: " + n4 + "\n\tkeyState: " + n5);
    }

    public DrawingSurfaceInfo getDrawingSurfaceInfo() {
        return new WDrawingSurfaceInfo(this);
    }
}

