/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.peer.ChoicePeer;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MChoiceMenu;
import sun.awt.motif.XEvent;

class MTinyChoicePeer
extends MCanvasPeer
implements ChoicePeer {
    MChoiceMenu menu;

    public MTinyChoicePeer(Choice choice) {
        super(choice);
    }

    public Dimension minimumSize() {
        int n = 0;
        int n2 = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        Choice choice = (Choice)this.target;
        int n3 = 0;
        int n4 = choice.countItems();
        while (n4-- > 0) {
            n = fontMetrics.stringWidth(choice.getItem(n4));
            n3 = Math.max(n, n3);
        }
        n2 = fontMetrics.getHeight();
        return new Dimension(n3 + 10 + 18, n2 + 10);
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        this.paint(graphics);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.target.repaint();
    }

    public void paint(Graphics graphics) {
        Choice choice = (Choice)this.target;
        Dimension dimension = this.target.size();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
        graphics.draw3DRect(dimension.width - 18, dimension.height / 2 - 3, 12, 6, true);
        graphics.setColor(Color.black);
        graphics.setFont(choice.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = choice.getSelectedItem();
        graphics.drawString(string, 5, (dimension.height + fontMetrics.getAscent()) / 2);
        this.target.paint(graphics);
    }

    protected void handleMouseDown(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.target.isEnabled()) {
            return;
        }
        Dimension dimension = this.target.size();
        Choice choice = (Choice)this.target;
        String[] stringArray = new String[choice.countItems()];
        int n8 = 0;
        while (n8 < stringArray.length) {
            stringArray[n8] = choice.getItem(n8);
            ++n8;
        }
        Component component = this.target;
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        SecurityManager.enablePrivilege("UniversalTopLevelWindow");
        this.menu = new MChoiceMenu((Frame)component, this, n4, n5, dimension.width - 20, dimension.height, choice.getSelectedIndex(), stringArray);
        this.menu.show();
    }

    protected void handleMouseUp(long l, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.target.isEnabled()) {
            return;
        }
        Choice choice = (Choice)this.target;
        choice.select(this.menu.selected);
        this.menu.hide();
        this.menu.dispose();
        this.menu = null;
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 1001, choice.getSelectedItem()), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 1001, choice.getSelectedItem()));
    }

    protected void handleMouseDrag(long l, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.target.isEnabled()) {
            return;
        }
        Rectangle rectangle = this.menu.bounds();
        Point point = new Point(n4 - rectangle.x, n5 - rectangle.y);
        this.menu.handleWindowEvent(new Event(this.target, l, 506, point.x, point.y, 0, n6, null));
    }

    public void select(int n) {
        this.target.repaint();
    }

    public void addItem(String string, int n) {
        this.target.repaint();
    }
}

