/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.FramePeer;
import java.util.Vector;
import sun.awt.image.ImageRepresentation;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.X11Image;
import sun.awt.motif.XEvent;

class MFramePeer
extends MPanelPeer
implements FramePeer {
    Insets insets;
    Vector windowList = new Vector();
    static Vector allFrames = new Vector();

    native void create(MComponentPeer var1, Object var2);

    native void pSetTitle(String var1);

    native void pShow();

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    native void pSetIconImage(ImageRepresentation var1);

    public native void setResizable(boolean var1);

    MFramePeer(Frame frame) {
        super(frame, new Insets(Integer.getInteger("awt.frame.topInset", 25), Integer.getInteger("awt.frame.leftInset", 5), Integer.getInteger("awt.frame.bottomInset", 5), Integer.getInteger("awt.frame.rightInset", 5)));
        Image image;
        Color color;
        Font font;
        allFrames.addElement(this);
        if (frame.getTitle() != null) {
            this.pSetTitle(frame.getTitle());
        }
        if ((font = frame.getFont()) == null) {
            font = new Font("Dialog", 0, 12);
            frame.setFont(font);
            this.setFont(font);
        }
        if ((color = frame.getBackground()) == null) {
            frame.setBackground(Color.lightGray);
            this.setBackground(Color.lightGray);
        }
        if ((color = frame.getForeground()) == null) {
            frame.setForeground(Color.black);
            this.setForeground(Color.black);
        }
        if ((image = frame.getIconImage()) != null) {
            this.setIconImage(image);
        }
        if (frame.getCursorType() != 0) {
            this.setCursor(frame.getCursorType());
        }
        this.setResizable(frame.isResizable());
    }

    public void setTitle(String string) {
        this.pSetTitle(string);
    }

    public void dispose() {
        Vector vector = this.windowList;
        synchronized (vector) {
            while (!this.windowList.isEmpty()) {
                Window window = (Window)this.windowList.firstElement();
                window.dispose();
            }
        }
        allFrames.removeElement(this);
        super.dispose();
    }

    public void setIconImage(Image image) {
        ImageRepresentation imageRepresentation = ((X11Image)image).getImageRep(-1, -1);
        imageRepresentation.reconstruct(32);
        this.pSetIconImage(imageRepresentation);
    }

    public void setMenuBar(MenuBar menuBar) {
        this.pSetMenuBar(menuBar);
        if (this.target.isVisible()) {
            Rectangle rectangle = this.target.bounds();
            this.pReshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.target.invalidate();
            this.target.validate();
        }
    }

    native void pSetMenuBar(MenuBar var1);

    public void handleQuit() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 201, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 201, null));
    }

    public void handleIconify() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 203, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 203, null));
    }

    public void handleDeiconify() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 204, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 204, null));
    }

    public void toFront() {
        this.pShow();
    }

    public native void toBack();

    public synchronized void handleMoved(int n, int n2) {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 0L, 205, n, n2, 0, 0), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 0L, 205, n, n2, 0, 0));
    }

    public synchronized void handleResize(int n, int n2) {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 207, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.invalidate();
        this.target.validate();
        this.target.repaint();
    }

    public Insets insets() {
        return this.insets;
    }

    public native void setCursor(int var1);

    void addWindow(Window window) {
        Vector vector = this.windowList;
        synchronized (vector) {
            if (window != null) {
                this.windowList.addElement(window);
            }
            return;
        }
    }

    void removeWindow(Window window) {
        Vector vector = this.windowList;
        synchronized (vector) {
            if (window != null) {
                this.windowList.removeElement(window);
            }
            return;
        }
    }
}

