/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class VariableGridLayout
extends GridLayout {
    double[] rowFractions;
    double[] colFractions;
    int rows;
    int cols;
    int hgap;
    int vgap;

    public VariableGridLayout(int n, int n2) {
        this(n, n2, 0, 0);
        if (n != 0) {
            this.stdRowFractions(n);
        }
        if (n2 != 0) {
            this.stdColFractions(n2);
        }
    }

    public VariableGridLayout(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
        if (n != 0) {
            this.stdRowFractions(n);
        }
        if (n2 != 0) {
            this.stdColFractions(n2);
        }
    }

    void stdRowFractions(int n) {
        this.rowFractions = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.rowFractions[n2] = 1.0 / (double)n;
            ++n2;
        }
    }

    void stdColFractions(int n) {
        this.colFractions = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.colFractions[n2] = 1.0 / (double)n;
            ++n2;
        }
    }

    public void setRowFraction(int n, double d) {
        this.rowFractions[n] = d;
    }

    public void setColFraction(int n, double d) {
        this.colFractions[n] = d;
    }

    public double getRowFraction(int n) {
        return this.rowFractions[n];
    }

    public double getColFraction(int n) {
        return this.colFractions[n];
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n = container.countComponents();
        int n2 = this.rows;
        int n3 = this.cols;
        if (n2 > 0) {
            n3 = (n + n2 - 1) / n2;
        } else {
            n2 = (n + n3 - 1) / n3;
        }
        if (this.rows == 0) {
            this.stdRowFractions(n2);
        }
        if (this.cols == 0) {
            this.stdColFractions(n3);
        }
        Dimension dimension = container.size();
        int n4 = dimension.width - (insets.left + insets.right);
        int n5 = dimension.height - (insets.top + insets.bottom);
        n4 -= (n3 - 1) * this.hgap;
        n5 -= (n2 - 1) * this.vgap;
        int n6 = 0;
        int n7 = insets.left;
        while (n6 < n3) {
            int n8 = (int)(this.getColFraction(n6) * (double)n4);
            int n9 = 0;
            int n10 = insets.top;
            while (n9 < n2) {
                int n11 = n9 * n3 + n6;
                int n12 = (int)(this.getRowFraction(n9) * (double)n5);
                if (n11 < n) {
                    container.getComponent(n11).reshape(n7, n10, n8, n12);
                }
                n10 += n12 + this.vgap;
                ++n9;
            }
            n7 += n8 + this.hgap;
            ++n6;
        }
    }

    static String fracsToString(double[] dArray) {
        String string = "[" + dArray.length + "]";
        int n = 0;
        while (n < dArray.length) {
            string = String.valueOf(string) + "<" + dArray[n] + ">";
            ++n;
        }
        return string;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + ",rowFracs=" + VariableGridLayout.fracsToString(this.rowFractions) + ",colFracs=" + VariableGridLayout.fracsToString(this.colFractions) + "]";
    }
}

