/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import sun.awt.ScreenUpdaterEntry;
import sun.awt.UpdateClient;

public class ScreenUpdater
extends Thread {
    private final int PRIORITY = 4;
    private ScreenUpdaterEntry first;
    public static final ScreenUpdater updater = ScreenUpdater.newScreenUpdater();

    static ThreadGroup findSystemThreadGroup() {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        while (threadGroup != null && !threadGroup.getName().equals("main")) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    static ScreenUpdater newScreenUpdater() {
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        SecurityManager.enablePrivilege("UniversalThreadGroupAccess");
        return new ScreenUpdater(ScreenUpdater.findSystemThreadGroup(), "ScreenUpdater");
    }

    private ScreenUpdater(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
        this.start();
    }

    private ScreenUpdater() {
        this.start();
    }

    private synchronized ScreenUpdaterEntry nextEntry() throws InterruptedException {
        while (true) {
            ScreenUpdaterEntry screenUpdaterEntry;
            if (this.first == null) {
                screenUpdaterEntry = null;
                this.wait();
                continue;
            }
            long l = this.first.when - System.currentTimeMillis();
            if (l <= 0L) {
                screenUpdaterEntry = this.first;
                this.first = this.first.next;
                return screenUpdaterEntry;
            }
            screenUpdaterEntry = null;
            this.wait(l);
        }
    }

    public void run() {
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        this.setName("ScreenUpdater");
        try {
            while (true) {
                this.setPriority(4);
                ScreenUpdaterEntry screenUpdaterEntry = this.nextEntry();
                this.setPriority(screenUpdaterEntry.client.updatePriority());
                try {
                    screenUpdaterEntry.client.updateClient(screenUpdaterEntry.arg);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                screenUpdaterEntry = null;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void notify(UpdateClient updateClient) {
        this.notify(updateClient, 100L, null);
    }

    public synchronized void notify(UpdateClient updateClient, long l) {
        this.notify(updateClient, l, null);
    }

    public synchronized void notify(UpdateClient updateClient, long l, Object object) {
        ScreenUpdaterEntry screenUpdaterEntry;
        long l2;
        long l3 = System.currentTimeMillis() + l;
        long l4 = l2 = this.first != null ? this.first.when : -1L;
        if (this.first != null) {
            if (this.first.client == updateClient) {
                l3 = Math.min(this.first.when, l3);
                this.first = this.first.next;
            } else {
                screenUpdaterEntry = this.first;
                while (screenUpdaterEntry.next != null) {
                    if (screenUpdaterEntry.next.client == updateClient && screenUpdaterEntry.next.arg == object) {
                        l3 = Math.min(screenUpdaterEntry.next.when, l3);
                        screenUpdaterEntry.next = screenUpdaterEntry.next.next;
                        break;
                    }
                    screenUpdaterEntry = screenUpdaterEntry.next;
                }
            }
        }
        if (this.first == null || this.first.when > l3) {
            this.first = new ScreenUpdaterEntry(updateClient, l3, object, this.first);
        } else {
            screenUpdaterEntry = this.first;
            while (true) {
                if (screenUpdaterEntry.next == null || screenUpdaterEntry.next.when > l3) {
                    screenUpdaterEntry.next = new ScreenUpdaterEntry(updateClient, l3, object, screenUpdaterEntry.next);
                    break;
                }
                screenUpdaterEntry = screenUpdaterEntry.next;
            }
        }
        if (l2 != this.first.when) {
            super.notify();
        }
    }
}

