/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

import netscape.security.Privilege;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.Hashtable;

public class PrivilegeTable
implements Cloneable,
Codable {
    static final int VERSION = 1;
    private Hashtable itsTable = null;
    private static Hashtable theEmptyTable = new Hashtable();

    public int size() {
        if (this.itsTable != null) {
            return this.itsTable.size();
        }
        return 0;
    }

    public boolean isEmpty() {
        if (this.itsTable == null) {
            return true;
        }
        return this.itsTable.isEmpty();
    }

    public Enumeration keys() {
        if (this.itsTable == null) {
            return theEmptyTable.keys();
        }
        return this.itsTable.keys();
    }

    public Enumeration elements() {
        if (this.itsTable == null) {
            return theEmptyTable.elements();
        }
        return this.itsTable.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.itsTable == null) {
            return "Empty Table";
        }
        Hashtable hashtable = this.itsTable;
        synchronized (hashtable) {
            Enumeration enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                stringBuffer.append(object.toString());
                stringBuffer.append(" ");
                stringBuffer.append(this.get(object).toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public Privilege get(Object object) {
        if (this.itsTable == null) {
            return Privilege.findPrivilege(2, 1);
        }
        Privilege privilege = (Privilege)this.itsTable.get(object);
        if (privilege == null) {
            return Privilege.findPrivilege(2, 1);
        }
        return privilege;
    }

    public Privilege get(Target target) {
        return this.get((Object)target);
    }

    public synchronized Privilege put(Object object, Privilege privilege) {
        if (this.itsTable == null) {
            this.itsTable = new Hashtable();
        }
        return (Privilege)this.itsTable.put(object, privilege);
    }

    public synchronized Privilege put(Target target, Privilege privilege) {
        return this.put((Object)target, privilege);
    }

    public synchronized Privilege remove(Object object) {
        if (this.itsTable == null) {
            return (Privilege)theEmptyTable.remove(object);
        }
        return (Privilege)this.itsTable.remove(object);
    }

    public synchronized Privilege remove(Target target) {
        if (this.itsTable == null) {
            return (Privilege)theEmptyTable.remove(target);
        }
        return (Privilege)this.itsTable.remove(target);
    }

    public synchronized void clear() {
        if (this.itsTable != null) {
            this.itsTable.clear();
        }
    }

    public Object clone() {
        PrivilegeTable privilegeTable = new PrivilegeTable();
        privilegeTable.itsTable = this.itsTable == null ? null : (Hashtable)this.itsTable.clone();
        return privilegeTable;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("PrivilegeTable", 1);
        classInfo.addField("Table", (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject("Table", (Object)this.itsTable);
    }

    public void decode(Decoder decoder) throws CodingException {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager != null && privilegeManager.isSecurityInited()) {
            return;
        }
        this.itsTable = (Hashtable)decoder.decodeObject("Table");
    }

    public void finishDecoding() throws CodingException {
    }
}

