/*
 * Decompiled with CFR 0.152.
 */
package netscape.secfile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import netscape.secfile.SecureFileException;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;

public class SecureFile
extends File {
    private static String indexDir = null;
    private static String indexDirSep;
    private static Hashtable prinToReldirHashtable;
    private String prepend;
    private Principal prin;
    private String path;
    private String canonicalPath;
    public static final String separator;
    public static final char separatorChar;
    public static final String pathSeparator;
    public static final char pathSeparatorChar;

    private static long random() {
        PrivilegeManager.enableTarget("UniversalPropertyRead");
        PrivilegeManager.enableTarget("UniversalFileRead");
        File file = new File(System.getProperty("user.home"));
        long l = 0L;
        if (file.list() != null) {
            int n = 0;
            while (n < file.list().length) {
                File file2 = new File(String.valueOf(System.getProperty("user.home")) + File.separator + file.list()[n]);
                l += file2.length();
                ++n;
            }
        }
        long l2 = System.currentTimeMillis();
        return (l & 0xFFFFL) << 16 | l2 & 0xFFFFL;
    }

    private static synchronized void getIndexDir() {
        if (indexDir == null) {
            PrivilegeManager.enableTarget("UniversalPropertyRead");
            indexDir = String.valueOf(System.getProperty("user.home")) + separator + "secfile";
            indexDirSep = String.valueOf(indexDir) + separator;
            File file = new File(indexDir);
            PrivilegeManager.enableTarget("UniversalFileRead");
            if (!file.exists()) {
                PrivilegeManager.enableTarget("UniversalFileWrite");
                if (!file.mkdir()) {
                    throw new SecureFileException("Error creating secfile directory");
                }
            }
        }
    }

    private static void putIndexfileIntoHashtable() {
        Hashtable hashtable = prinToReldirHashtable;
        synchronized (hashtable) {
            if (prinToReldirHashtable.size() == 0) {
                File file = new File(String.valueOf(indexDirSep) + "index.txt");
                PrivilegeManager.enableTarget("UniversalFileRead");
                if (file.exists()) {
                    try {
                        String string;
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(String.valueOf(indexDirSep) + "index.txt"));
                        while ((string = bufferedReader.readLine()) != null) {
                            int n = string.indexOf(" ");
                            if (n <= 0 || n >= string.length() - 1) {
                                bufferedReader.close();
                                file.renameTo(new File(String.valueOf(indexDirSep) + "index.bad"));
                                throw new SecureFileException("Syntax error in index file");
                            }
                            prinToReldirHashtable.put(string.substring(n + 1), string.substring(0, n));
                        }
                    }
                    catch (IOException iOException) {
                        file.renameTo(new File(String.valueOf(indexDirSep) + "index.bad"));
                        throw new SecureFileException("Error reading index file" + iOException);
                    }
                }
            }
            return;
        }
    }

    private static void addNewPrincipal(String string) {
        Hashtable hashtable = prinToReldirHashtable;
        synchronized (hashtable) {
            if (prinToReldirHashtable.get(string) == null) {
                String string2;
                String string3;
                PrivilegeManager.enableTarget("UniversalFileRead");
                do {
                    string2 = Long.toString(SecureFile.random(), 16);
                } while (new File(string3 = String.valueOf(indexDirSep) + string2).exists());
                PrivilegeManager.enableTarget("UniversalFileWrite");
                if (!new File(string3).mkdir()) {
                    throw new SecureFileException("Error creating directory for " + string);
                }
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(String.valueOf(indexDirSep) + "index.txt", true));
                    bufferedWriter.write(String.valueOf(string2) + ' ' + string);
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
                catch (IOException iOException) {
                    throw new SecureFileException("Error writing index file");
                }
                prinToReldirHashtable.put(string, string2);
            }
            return;
        }
    }

    static String getPrepend(Principal principal, int n) {
        String string = principal.toString();
        if (!SecureFile.checkPrincipal(principal, n + 1)) {
            throw new SecureFileException("Unauthorized principal:" + string);
        }
        if (indexDir == null) {
            SecureFile.getIndexDir();
        }
        if (prinToReldirHashtable.size() == 0) {
            SecureFile.putIndexfileIntoHashtable();
        }
        if (prinToReldirHashtable.get(string) == null) {
            SecureFile.addNewPrincipal(string);
        }
        return String.valueOf(indexDirSep) + prinToReldirHashtable.get(string);
    }

    static String getPrependedPath(String string, String string2) {
        if (string2 == null || string2 == "") {
            return string;
        }
        if (string2.startsWith(separator)) {
            return String.valueOf(string) + string2;
        }
        return String.valueOf(string) + separator + string2;
    }

    private static boolean checkPrincipal(Principal principal, int n) {
        if (principal.isCodebaseExact() && principal.toString().equals("Common")) {
            return true;
        }
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            return false;
        }
        return privilegeManager.isCalledByPrincipal(principal, n + 1);
    }

    static String checkCanonicalPath(String string, String string2) {
        String string3;
        PrivilegeManager.enableTarget("UniversalFileRead");
        try {
            string3 = string.startsWith(separator) ? new File(String.valueOf(string2) + string).getCanonicalPath() : new File(String.valueOf(string2) + separator + string).getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new SecureFileException("Unable to verify canonical path");
        }
        if (!string3.startsWith(string2)) {
            throw new SecureFileException("Canonical path is outside of principal's subdirectory");
        }
        return string3.substring(string2.length());
    }

    static Principal getClassPrincipal(int n) {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            return null;
        }
        return privilegeManager.getClassPrincipalsFromStack(n + 1)[0];
    }

    public SecureFile(String string) {
        this(string, SecureFile.getClassPrincipal(1), 1);
    }

    public SecureFile(String string, String string2) {
        this(string, string2, SecureFile.getClassPrincipal(1), 1);
    }

    public SecureFile(SecureFile secureFile, String string) {
        this(secureFile.getPath(), string, secureFile.getPrincipal(), 1);
    }

    public SecureFile(String string, Principal principal) {
        this(string, principal, 1);
    }

    private SecureFile(String string, Principal principal, int n) {
        super(SecureFile.getPrependedPath(SecureFile.getPrepend(principal, n + 1), string));
        this.prepend = SecureFile.getPrepend(principal, n + 1);
        this.path = string != null ? string : "";
        this.prin = principal;
        this.canonicalPath = SecureFile.checkCanonicalPath(this.path, this.prepend);
    }

    public SecureFile(String string, String string2, Principal principal) {
        this(string, string2, principal, 1);
    }

    private SecureFile(String string, String string2, Principal principal, int n) {
        super(SecureFile.getPrependedPath(SecureFile.getPrepend(principal, n + 1), string), string2);
        this.prepend = SecureFile.getPrepend(principal, n + 1);
        this.path = string != null ? (string.endsWith(separator) ? String.valueOf(string) + string2 : String.valueOf(string) + separator + string2) : string2;
        this.prin = principal;
        this.canonicalPath = SecureFile.checkCanonicalPath(this.path, this.prepend);
    }

    public Principal getPrincipal() {
        return this.prin;
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsolutePath() {
        if (this.path.startsWith(separator)) {
            return this.path;
        }
        return String.valueOf(separator) + this.path;
    }

    public String getCanonicalPath() throws IOException {
        return this.canonicalPath;
    }

    public String getParent() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n < 0) {
            return null;
        }
        if (n > 0) {
            return this.path.substring(0, n);
        }
        if (this.path.length() > 1) {
            return this.path.substring(0, 1);
        }
        return null;
    }

    public boolean exists() {
        PrivilegeManager.enableTarget("UniversalFileRead");
        return super.exists();
    }

    public boolean canWrite() {
        PrivilegeManager.enableTarget("UniversalFileWrite");
        return super.canWrite();
    }

    public boolean canRead() {
        PrivilegeManager.enableTarget("UniversalFileRead");
        return super.canRead();
    }

    public boolean isFile() {
        PrivilegeManager.enableTarget("UniversalFileRead");
        return super.isFile();
    }

    public boolean isDirectory() {
        PrivilegeManager.enableTarget("UniversalFileRead");
        return super.isDirectory();
    }

    public long lastModified() {
        PrivilegeManager.enableTarget("UniversalFileRead");
        return super.lastModified();
    }

    public long length() {
        PrivilegeManager.enableTarget("UniversalFileRead");
        return super.length();
    }

    public boolean mkdir() {
        PrivilegeManager.enableTarget("UniversalFileWrite");
        return super.mkdir();
    }

    public boolean renameTo(SecureFile secureFile) {
        PrivilegeManager.enableTarget("UniversalFileWrite");
        return super.renameTo(new File(String.valueOf(SecureFile.getPrepend(secureFile.getPrincipal(), 1)) + secureFile.getAbsolutePath()));
    }

    public boolean mkdirs() {
        PrivilegeManager.enableTarget("UniversalFileWrite");
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        String string = this.getParent();
        return string != null && new SecureFile(string, SecureFile.getClassPrincipal(1), 1).mkdirs() && this.mkdir();
    }

    public String[] list() {
        PrivilegeManager.enableTarget("UniversalFileRead");
        return super.list();
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            if (filenameFilter == null || filenameFilter.accept(this, stringArray[n])) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean delete() {
        PrivilegeManager.enableTarget("UniversalFileDelete");
        return super.delete();
    }

    public int hashCode() {
        return this.path.hashCode() ^ 0x12D591;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SecureFile) {
            return this.path.equals(((SecureFile)object).getPath());
        }
        return false;
    }

    public String toString() {
        return this.getPath();
    }

    public long lastAccessed() {
        PrivilegeManager.enableTarget("UniversalFileRead");
        return super.lastAccessed();
    }

    public long lastStatusChange() {
        PrivilegeManager.enableTarget("UniversalFileRead");
        return super.lastStatusChange();
    }

    public boolean isLink() {
        PrivilegeManager.enableTarget("UniversalFileRead");
        return super.isLink();
    }

    static {
        prinToReldirHashtable = new Hashtable();
        separator = File.separator;
        separatorChar = File.separatorChar;
        pathSeparator = File.pathSeparator;
        pathSeparatorChar = File.pathSeparatorChar;
    }
}

