/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.peer.TextComponentPeer;

public class TextComponent
extends Component {
    String text;
    boolean editable = true;
    int selStart;
    int selEnd;

    TextComponent(String string) {
        this.text = string;
    }

    public synchronized void removeNotify() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
            this.selStart = textComponentPeer.getSelectionStart();
            this.selEnd = textComponentPeer.getSelectionEnd();
        }
        super.removeNotify();
    }

    public void setText(String string) {
        this.text = string;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.setText(string);
        }
    }

    public String getText() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
        }
        return this.text;
    }

    public String getSelectedText() {
        return this.getText().substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.setEditable(bl);
        }
    }

    public int getSelectionStart() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.selStart = textComponentPeer.getSelectionStart();
        }
        return this.selStart;
    }

    public int getSelectionEnd() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.selEnd = textComponentPeer.getSelectionEnd();
        }
        return this.selEnd;
    }

    public void select(int n, int n2) {
        String string = this.getText();
        if (n < 0) {
            n = 0;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n > n2) {
            n = n2;
        }
        this.selStart = n;
        this.selEnd = n2;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.select(n, n2);
        }
    }

    public void selectAll() {
        this.getText();
        this.selStart = 0;
        this.selEnd = this.getText().length();
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.select(this.selStart, this.selEnd);
        }
    }

    protected String paramString() {
        String string = String.valueOf(super.paramString()) + ",text=" + this.getText();
        if (this.editable) {
            string = String.valueOf(string) + ",editable";
        }
        return String.valueOf(string) + ",selection=" + this.getSelectionStart() + "-" + this.getSelectionEnd();
    }
}

