/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.peer.ListPeer;
import java.util.Vector;

public class List
extends Component {
    Vector items = new Vector();
    int rows;
    boolean multipleSelections = false;
    int[] selected = new int[0];
    int visibleIndex = -1;

    public List() {
        this(0, false);
    }

    public List(int n, boolean bl) {
        this.rows = n;
        this.multipleSelections = bl;
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createList(this);
        }
        super.addNotify();
        this.visibleIndex = -1;
    }

    public synchronized void removeNotify() {
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            this.selected = listPeer.getSelectedIndexes();
        }
        super.removeNotify();
    }

    public int countItems() {
        return this.items.size();
    }

    public String getItem(int n) {
        return (String)this.items.elementAt(n);
    }

    public synchronized void addItem(String string) {
        this.addItem(string, -1);
    }

    public synchronized void addItem(String string, int n) {
        if (n < -1 || n >= this.items.size()) {
            n = -1;
        }
        if (n == -1) {
            this.items.addElement(string);
        } else {
            this.items.insertElementAt(string, n);
        }
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.addItem(string, n);
        }
    }

    public synchronized void replaceItem(String string, int n) {
        this.delItem(n);
        this.addItem(string, n);
    }

    public synchronized void clear() {
        if (this.peer != null) {
            ((ListPeer)this.peer).clear();
        }
        this.items = new Vector();
        this.selected = new int[0];
    }

    public synchronized void delItem(int n) {
        this.delItems(n, n);
    }

    public synchronized void delItems(int n, int n2) {
        int n3 = n2;
        while (n3 >= n) {
            this.items.removeElementAt(n3);
            --n3;
        }
        if (this.peer != null) {
            ((ListPeer)this.peer).delItems(n, n2);
        }
    }

    public synchronized int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray.length == 1) {
            return nArray[0];
        }
        return -1;
    }

    public synchronized int[] getSelectedIndexes() {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            this.selected = listPeer.getSelectedIndexes();
        }
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.getItem(n);
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.getItem(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public synchronized void select(int n) {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.select(n);
            return;
        }
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                return;
            }
            ++n2;
        }
        if (!this.multipleSelections) {
            this.selected = new int[1];
            this.selected[0] = n;
            return;
        }
        int[] nArray = new int[this.selected.length + 1];
        System.arraycopy(this.selected, 0, nArray, 0, this.selected.length);
        nArray[this.selected.length] = n;
        this.selected = nArray;
    }

    public synchronized void deselect(int n) {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.deselect(n);
        }
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                int[] nArray = new int[this.selected.length - 1];
                System.arraycopy(this.selected, 0, nArray, 0, n2);
                System.arraycopy(this.selected, n2 + 1, nArray, n2, this.selected.length - (n2 + 1));
                this.selected = nArray;
                return;
            }
            ++n2;
        }
    }

    public synchronized boolean isSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean allowsMultipleSelections() {
        return this.multipleSelections;
    }

    public void setMultipleSelections(boolean bl) {
        if (bl != this.multipleSelections) {
            this.multipleSelections = bl;
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                listPeer.setMultipleSelections(bl);
            }
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public void makeVisible(int n) {
        ListPeer listPeer = (ListPeer)this.peer;
        this.visibleIndex = n;
        if (listPeer != null) {
            listPeer.makeVisible(n);
        }
    }

    public Dimension preferredSize(int n) {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            return listPeer.preferredSize(n);
        }
        return super.preferredSize();
    }

    public Dimension preferredSize() {
        if (this.rows > 0) {
            return this.preferredSize(this.rows);
        }
        return super.preferredSize();
    }

    public Dimension minimumSize(int n) {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            return listPeer.minimumSize(n);
        }
        return super.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.rows > 0) {
            return this.minimumSize(this.rows);
        }
        return super.minimumSize();
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",selected=" + this.getSelectedItem();
    }
}

