/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;

public class Font
implements Serializable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    private transient int pData;
    private transient String family;
    protected String name;
    protected int style;
    protected int size;

    public Font(String string, int n, int n2) {
        SecurityManager.enablePrivilege("UniversalPropertyRead");
        this.family = System.getProperty("awt.font." + string.toLowerCase(), string);
        this.name = string;
        this.style = n;
        this.size = n2;
    }

    public String getFamily() {
        return this.family;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public void finalize() {
        this.dispose();
    }

    public synchronized native void dispose();

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    public static Font getFont(String string, Font font) {
        String string2;
        try {
            string2 = System.getProperty(string);
        }
        catch (Exception exception) {
            string2 = null;
        }
        if (string2 == null) {
            return font;
        }
        String string3 = string2;
        int n = 12;
        int n2 = 0;
        int n3 = string2.indexOf(45);
        if (n3 >= 0) {
            string3 = string2.substring(0, n3);
            if ((n3 = (string2 = string2.substring(n3 + 1)).indexOf(45)) >= 0) {
                if (string2.startsWith("bold-")) {
                    n2 = 1;
                } else if (string2.startsWith("italic-")) {
                    n2 = 2;
                } else if (string2.startsWith("bolditalic-")) {
                    n2 = 3;
                }
                string2 = string2.substring(n3 + 1);
            }
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new Font(string3, n2, n);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.style ^ this.size;
    }

    public boolean equals(Object object) {
        if (object instanceof Font) {
            Font font = (Font)object;
            return this.size == font.size && this.style == font.style && this.name.equals(font.name);
        }
        return false;
    }

    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return String.valueOf(this.getClass().getName()) + "[family=" + this.family + ",name=" + this.name + ",style=" + string + ",size=" + this.size + "]";
    }
}

