/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.io.PrintStream;
import java.io.Serializable;

public abstract class Component
implements ImageObserver,
Serializable {
    transient ComponentPeer peer;
    transient Container parent;
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    boolean visible = true;
    boolean enabled = true;
    boolean valid = false;
    String name;
    static final Object LOCK = new Object();

    Component() {
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public Toolkit getToolkit() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.getToolkit();
        }
        Container container = this.parent;
        if (container != null) {
            return container.getToolkit();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.peer != null && this.valid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowing() {
        if (this.visible && this.peer != null) {
            Container container = this.parent;
            return container == null || container.isShowing();
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public synchronized void enable() {
        if (!this.enabled) {
            this.enabled = true;
            if (this.peer != null) {
                this.peer.enable();
            }
        }
    }

    public void enable(boolean bl) {
        if (bl) {
            this.enable();
            return;
        }
        this.disable();
    }

    public synchronized void disable() {
        if (this.enabled) {
            this.enabled = false;
            if (this.peer != null) {
                this.peer.disable();
            }
        }
    }

    public void setVisible(boolean bl) {
        this.show(bl);
    }

    public synchronized void show() {
        if (!this.visible) {
            this.visible = true;
            if (this.peer != null) {
                this.peer.show();
                if (this.parent != null) {
                    this.parent.invalidate();
                }
            }
        }
    }

    public void show(boolean bl) {
        if (bl) {
            this.show();
            return;
        }
        this.hide();
    }

    public synchronized void hide() {
        if (this.visible) {
            this.visible = false;
            if (this.peer != null) {
                this.peer.hide();
                if (this.parent != null) {
                    this.parent.invalidate();
                }
            }
        }
    }

    public Color getForeground() {
        Color color = this.foreground;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getForeground();
        }
        return null;
    }

    public synchronized void setForeground(Color color) {
        this.foreground = color;
        if (this.peer != null && (color = this.getForeground()) != null) {
            this.peer.setForeground(color);
        }
    }

    public Color getBackground() {
        Color color = this.background;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getBackground();
        }
        return null;
    }

    public synchronized void setBackground(Color color) {
        this.background = color;
        if (this.peer != null && (color = this.getBackground()) != null) {
            this.peer.setBackground(color);
        }
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getFont();
        }
        return null;
    }

    public synchronized void setFont(Font font) {
        this.font = font;
        if (this.peer != null && (font = this.getFont()) != null) {
            this.peer.setFont(font);
        }
    }

    public synchronized ColorModel getColorModel() {
        if (this.peer == null) {
            return this.getToolkit().getColorModel();
        }
        return this.peer.getColorModel();
    }

    public void move(int n, int n2) {
        this.reshape(n, n2, this.width, this.height);
    }

    public void resize(int n, int n2) {
        this.reshape(this.x, this.y, n, n2);
    }

    public void resize(Dimension dimension) {
        this.reshape(this.x, this.y, dimension.width, dimension.height);
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = this.width != n3 || this.height != n4;
        if (bl || this.x != n || this.y != n2) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            if (this.peer != null) {
                this.peer.reshape(n, n2, n3, n4);
                if (bl) {
                    this.invalidate();
                }
                if (this.parent != null) {
                    this.parent.invalidate();
                }
            }
        }
    }

    public Dimension preferredSize() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.preferredSize();
        }
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.minimumSize();
        }
        return this.size();
    }

    public void layout() {
    }

    public void validate() {
        while (!this.valid && this.peer != null) {
            this.layout();
            this.valid = true;
        }
    }

    public void invalidate() {
        this.valid = false;
        if (this.parent != null && this.parent.valid) {
            this.parent.invalidate();
        }
    }

    public Graphics getGraphics() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.getGraphics();
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.getFontMetrics(font);
        }
        return this.getToolkit().getFontMetrics(font);
    }

    public void paint(Graphics graphics) {
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(this.getForeground());
        this.paint(graphics);
    }

    public void paintAll(Graphics graphics) {
        ComponentPeer componentPeer = this.peer;
        if (this.visible && componentPeer != null) {
            this.validate();
            componentPeer.paint(graphics);
        }
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(long l) {
        this.repaint(l, 0, 0, this.width, this.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.repaint(0L, n, n2, n3, n4);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && n3 > 0 && n4 > 0) {
            componentPeer.repaint(l, n, n2, n3, n4);
        }
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void printAll(Graphics graphics) {
        ComponentPeer componentPeer = this.peer;
        if (this.visible && componentPeer != null) {
            this.validate();
            componentPeer.print(graphics);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        String string;
        int n6 = -1;
        if ((n & 0x30) != 0) {
            n6 = 0;
        } else if ((n & 8) != 0 && ((string = System.getProperty("awt.image.incrementaldraw")) == null || string.equals("true"))) {
            String string2 = System.getProperty("awt.image.redrawrate");
            try {
                int n7 = n6 = string2 != null ? Integer.parseInt(string2) : 100;
                if (n6 < 0) {
                    n6 = 0;
                }
            }
            catch (Exception exception) {
                n6 = 100;
            }
        }
        if (n6 >= 0) {
            this.repaint(n6, 0, 0, this.width, this.height);
        }
        return (n & 0xA0) == 0;
    }

    public Image createImage(ImageProducer imageProducer) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.createImage(imageProducer);
        }
        return this.getToolkit().createImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.createImage(n, n2);
        }
        return null;
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return this.prepareImage(image, -1, -1, imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.prepareImage(image, n, n2, imageObserver);
        }
        return this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return this.checkImage(image, -1, -1, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.checkImage(image, n, n2, imageObserver);
        }
        return this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public synchronized boolean inside(int n, int n2) {
        return n >= 0 && n < this.width && n2 >= 0 && n2 < this.height;
    }

    public Component locate(int n, int n2) {
        if (this.inside(n, n2)) {
            return this;
        }
        return null;
    }

    public void deliverEvent(Event event) {
        this.postEvent(event);
    }

    public boolean postEvent(Event event) {
        ComponentPeer componentPeer = this.peer;
        if (this.handleEvent(event)) {
            return true;
        }
        Container container = this.parent;
        if (container != null) {
            event.translate(this.x, this.y);
            if (container.postEvent(event)) {
                return true;
            }
        }
        if (componentPeer != null) {
            return componentPeer.handleEvent(event);
        }
        return false;
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 504: {
                return this.mouseEnter(event, event.x, event.y);
            }
            case 505: {
                return this.mouseExit(event, event.x, event.y);
            }
            case 503: {
                return this.mouseMove(event, event.x, event.y);
            }
            case 501: {
                return this.mouseDown(event, event.x, event.y);
            }
            case 506: {
                return this.mouseDrag(event, event.x, event.y);
            }
            case 502: {
                return this.mouseUp(event, event.x, event.y);
            }
            case 401: 
            case 403: {
                return this.keyDown(event, event.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(event, event.key);
            }
            case 1001: {
                return this.action(event, event.arg);
            }
            case 1004: {
                return this.gotFocus(event, event.arg);
            }
            case 1005: {
                return this.lostFocus(event, event.arg);
            }
        }
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return false;
    }

    public boolean keyDown(Event event, int n) {
        return false;
    }

    public boolean keyUp(Event event, int n) {
        return false;
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    public void addNotify() {
        this.valid = false;
    }

    public synchronized void removeNotify() {
        if (this.peer != null) {
            this.peer.dispose();
            this.peer = null;
        }
    }

    public boolean gotFocus(Event event, Object object) {
        return false;
    }

    public boolean lostFocus(Event event, Object object) {
        return false;
    }

    public void requestFocus() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            componentPeer.requestFocus();
        }
    }

    public void nextFocus() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            componentPeer.nextFocus();
        }
    }

    protected String paramString() {
        String string = String.valueOf(this.x) + "," + this.y + "," + this.width + "x" + this.height;
        if (!this.valid) {
            string = String.valueOf(string) + ",invalid";
        }
        if (!this.visible) {
            string = String.valueOf(string) + ",hidden";
        }
        if (!this.enabled) {
            string = String.valueOf(string) + ",disabled";
        }
        return string;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream printStream) {
        this.list(printStream, 0);
    }

    public void list(PrintStream printStream, int n) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print("  ");
            ++n2;
        }
        printStream.println(this);
    }
}

