/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class PropertyChangeSupport
implements Serializable {
    private transient Vector listeners;
    private Object source;
    private int propertyChangeSupportSerializedDataVersion = 1;

    public PropertyChangeSupport(Object object) {
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        Vector vector;
        if (object != null && object.equals(object2)) {
            return;
        }
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                Object var6_5 = null;
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        serializable = new PropertyChangeEvent(this.source, string, object, object2);
        int n = 0;
        while (n < vector.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
            propertyChangeListener.propertyChange((PropertyChangeEvent)serializable);
            ++n;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Vector vector = null;
        PropertyChangeSupport propertyChangeSupport = this;
        synchronized (propertyChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
                if (propertyChangeListener instanceof Serializable) {
                    objectOutputStream.writeObject(propertyChangeListener);
                }
                ++n;
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            this.addPropertyChangeListener((PropertyChangeListener)object);
        }
    }
}

