/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.ApplicationEvent;
import netscape.application.Event;
import netscape.application.EventFilter;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class EventLoop
implements Runnable {
    Vector events = new Vector();
    Thread mainThread;
    private boolean shouldRun = false;
    static boolean letAwtThreadRun = true;
    Application application;

    public void addEvent(Event event) {
        Vector vector = this.events;
        synchronized (vector) {
            this.events.addElement((Object)event);
            this.events.notify();
            return;
        }
    }

    final void letAWTThreadRun() {
        if (letAwtThreadRun) {
            if (!this.shouldProcessSynchronously()) {
                return;
            }
            Thread thread = Thread.currentThread();
            int n = thread.getPriority();
            int n2 = n - 1;
            if (n2 < 1) {
                n2 = 1;
            }
            try {
                thread.setPriority(n2);
                Thread.yield();
                thread.setPriority(n);
                return;
            }
            catch (SecurityException securityException) {
                letAwtThreadRun = false;
                return;
            }
        }
    }

    public void removeEvent(Event event) {
        Vector vector = this.events;
        synchronized (vector) {
            this.events.removeElement((Object)event);
            return;
        }
    }

    public Object filterEvents(EventFilter eventFilter) {
        Object object;
        this.letAWTThreadRun();
        Vector vector = this.events;
        synchronized (vector) {
            object = eventFilter.filterEvents(this.events);
            this.events.notify();
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Event getNextEvent() {
        Event event = null;
        Vector vector = this.events;
        synchronized (vector) {
            while (true) {
                if (this.events.count() != 0) {
                    return (Event)this.events.removeFirstElement();
                }
                try {
                    this.events.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Event peekNextEvent() {
        Event event;
        this.letAWTThreadRun();
        Vector vector = this.events;
        synchronized (vector) {
            event = (Event)this.events.firstElement();
        }
        return event;
    }

    public void processEvent(Event event) {
        Object object = event.synchronousLock();
        Application application = Application.application();
        application.willProcessInternalEvent(event);
        application.willProcessEvent(event);
        event.processor().processEvent(event);
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                event.clearSynchronousLock();
                object.notify();
            }
        }
        application.didProcessEvent(event);
        application.didProcessInternalEvent(event);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var2_1 = this;
        synchronized (var2_1) {
            if (this.mainThread != null) {
                throw new InconsistencyException("Only one thread may run an EventLoop");
            }
            this.mainThread = Thread.currentThread();
            this.shouldRun = true;
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var2_1
            if (true) ** GOTO lbl22
        }
        do {
            var1_3 = this.getNextEvent();
            if (!this.shouldRun) continue;
            try {
                this.processEvent(var1_3);
            }
            catch (Exception var2_2) {
                System.err.println(Application.application().exceptionHeader());
                var2_2.printStackTrace(System.err);
                System.err.println("Restarting EventLoop.");
            }
lbl22:
            // 4 sources

        } while (this.shouldRun);
        var2_1 = this;
        synchronized (var2_1) {
            this.mainThread = null;
            return;
        }
    }

    public synchronized void stopRunning() {
        ApplicationEvent applicationEvent = new ApplicationEvent();
        this.shouldRun = false;
        applicationEvent.type = -25;
        this.addEvent(applicationEvent);
    }

    public synchronized boolean isRunning() {
        return this.shouldRun;
    }

    synchronized boolean shouldProcessSynchronously() {
        return this.mainThread == null || Thread.currentThread() == this.mainThread;
    }

    public void addEventAndWait(Event event) {
        Object object;
        if (Thread.currentThread() == this.mainThread) {
            throw new InconsistencyException("Can't call addEventAndWait from within the EventLoop's main thread");
        }
        Object object2 = object = event.createSynchronousLock();
        synchronized (object2) {
            this.addEvent(event);
            while (event.synchronousLock() != null) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    public synchronized String toString() {
        return this.events.toString();
    }
}

