/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.client.JDAPBERTagDecoder;

public class LDAPVirtualListResponse
extends LDAPControl {
    public static final String VIRTUALLISTRESPONSE = "2.16.840.1.113730.3.4.10";
    private int m_firstPosition;
    private int m_contentCount;
    private int m_resultCode = -1;

    LDAPVirtualListResponse() {
        super(VIRTUALLISTRESPONSE, true, null);
    }

    public LDAPVirtualListResponse(byte[] byArray) {
        super(VIRTUALLISTRESPONSE, true, null);
        this.m_value = byArray;
        this.parseResponse();
    }

    public int getContentCount() {
        return this.m_contentCount;
    }

    public int getFirstPosition() {
        return this.m_firstPosition;
    }

    public int getResultCode() {
        return this.m_resultCode;
    }

    private void parseResponse() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getValue());
        new BERSequence();
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        int[] nArray = new int[]{0};
        try {
            BERSequence bERSequence = (BERSequence)BERElement.getElement(jDAPBERTagDecoder, byteArrayInputStream, nArray);
            this.m_firstPosition = ((BERInteger)bERSequence.elementAt(0)).getValue();
            this.m_contentCount = ((BERInteger)bERSequence.elementAt(1)).getValue();
            BEREnumerated bEREnumerated = (BEREnumerated)bERSequence.elementAt(2);
            this.m_resultCode = bEREnumerated.getValue();
            return;
        }
        catch (Throwable throwable) {
            this.m_resultCode = -1;
            this.m_contentCount = -1;
            this.m_firstPosition = -1;
            return;
        }
    }

    public static LDAPVirtualListResponse parseResponse(LDAPControl[] lDAPControlArray) {
        LDAPVirtualListResponse lDAPVirtualListResponse = null;
        int n = 0;
        while (lDAPControlArray != null && n < lDAPControlArray.length) {
            if (lDAPControlArray[n].getID().equals(VIRTUALLISTRESPONSE)) {
                lDAPVirtualListResponse = new LDAPVirtualListResponse(lDAPControlArray[n].getValue());
                lDAPVirtualListResponse.parseResponse();
                break;
            }
            ++n;
        }
        if (lDAPVirtualListResponse != null) {
            super.parseResponse();
        }
        return lDAPVirtualListResponse;
    }
}

