/*
 * @(#)BidirBubbleSortAlgorithm.java	1.6f 95/01/31 James Gosling
 *                                  modified 96/04/24 Jim Hagen
 * Copyright (c) 1994-1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL or COMMERCIAL purposes and
 * without fee is hereby granted. 
 * Please refer to the file http://java.sun.com/copy_trademarks.html
 * for further important copyright and trademark information and to
 * http://java.sun.com/licensing.html for further important licensing
 * information for the Java (tm) Technology.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
 * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
 * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
 * NAVIGATION OR COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE
 * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
 * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
 * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  SUN
 * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR
 * HIGH RISK ACTIVITIES.
 */

/**
 * A bi-directional bubble sort demonstration algorithm
 * SortAlgorithm.java, Thu Oct 27 10:32:35 1994
 *
 * @author James Gosling
 * @version 	1.6f, 31 Jan 1995
 */
class BidirBubbleSortAlgorithm extends SortAlgorithm {
    void sort(int a[]) throws Exception {
	int j;
	int limit = a.length;
	int st = -1;
	while (st < limit) {
	    boolean flipped = false;
	    st++;
	    limit--;
	    for (j = st; j < limit; j++) {
		if (stopRequested) {
		    return;
		}
		if (a[j] > a[j + 1]) {
		    int T = a[j];
		    a[j] = a[j + 1];
		    a[j + 1] = T;
		    flipped = true;
		    pause(st, limit);
		}
	    }
	    if (!flipped) {
		return;
	    }
	    for (j = limit; --j >= st;) {
		if (stopRequested) {
		    return;
		}
		if (a[j] > a[j + 1]) {
		    int T = a[j];
		    a[j] = a[j + 1];
		    a[j + 1] = T;
		    flipped = true;
		    pause(st, limit);
		}
	    }
	    if (!flipped) {
		return;
	    }
	}
	pause(st, limit);
    }
}
