/* FvwmBacker Module for Fvwm. 
 *
 *  Copyright 1994,  Mike Finger (mfinger@mermaid.micro.umn.edu or
 *                               Mike_Finger@atk.com)
 *
 * The author makes not guarantees or warantees, either express or
 * implied.  Feel free to use any contained here for any purpose, as long
 * and this and any other applicible copyrights are kept intact.

 * The functions in this source file that are based on part of the FvwmIdent
 * module for Fvwm are noted by a small copyright atop that function, all others
 * are copyrighted by Mike Finger.  For those functions modified/used, here is
 *  the full, origonal copyright:
 *
 * Copyright 1994, Robert Nation and Nobutaka Suzuki.
 * No guarantees or warantees or anything
 * are provided or implied in any way whatsoever. Use this program at your
 * own risk. Permission to use this program for any purpose is given,
 * as long as the copyright is kept intact. */

#include "../../configure.h"

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/time.h>
#if defined ___AIX || defined _AIX || defined __QNX__ || defined ___AIXV3 || defined AIXV3 || defined _SEQUENT_
#include <sys/select.h>
#endif
#include <unistd.h>
#include <ctype.h>
#ifdef ISC /* Saul */
#include <sys/bsdtypes.h> /* Saul */
#endif /* Saul */
#include <stdlib.h>

#include "../../fvwm/module.h"
#include "../../version.h"
#include "FvwmBacker.h"
#include "Mallocs.h"

char **commands;
int DeskCount=0;

int Fvwm_fd[2];
int fd_width;

char *Module;

void main(int argc, char **argv)
{
char *temp, *s;

  commands=NULL;

  /* Save the program name for error messages and config parsing */
  temp = argv[0];
  s=strrchr(argv[0], '/');
  if (s != NULL)
    temp = s + 1;

  Module=temp;
  
  if((argc != 6)&&(argc != 7)) {
    fprintf(stderr,"%s Version %s should only be executed by fvwm!\n",Module,
      VERSION);
   exit(1);
  }

  Fvwm_fd[0] = atoi(argv[1]);
  Fvwm_fd[1] = atoi(argv[2]);

  signal (SIGPIPE, DeadPipe);  

  /* Parse the config file */
  ParseConfig(argv[3]);

#ifndef NO_SYSCONF
  fd_width = sysconf(_SC_OPEN_MAX);
#else
  fd_width = getdtablesize();
#endif

  /* Request a list of all windows,
   * wait for ConfigureWindow packets */
  SendFvwmPipe("Send_WindowList",0);

  /* Recieve all messages from Fvwm */
  EndLessLoop();
}

/******************************************************************************
  EndLessLoop -  Read until we get killed, blocking when can't read
******************************************************************************/
void EndLessLoop()
{
fd_set readset;
struct timeval tv;

  while(1) {
    FD_ZERO(&readset);
    FD_SET(Fvwm_fd[1],&readset);
    tv.tv_sec=0;
    tv.tv_usec=0;
    if (!select(fd_width,&readset,NULL,NULL,&tv)) {
      FD_ZERO(&readset);
      FD_SET(Fvwm_fd[1],&readset);
      select(fd_width,&readset,NULL,NULL,NULL);
    }

    if (!FD_ISSET(Fvwm_fd[1],&readset)) continue;
    ReadFvwmPipe();
  }
}

/******************************************************************************
  ReadFvwmPipe - Read a single message from the pipe from Fvwm
    Originally Loop() from FvwmIdent:
      Copyright 1994, Robert Nation and Nobutaka Suzuki.
******************************************************************************/
void ReadFvwmPipe()
{
int count,total,count2=0,body_length;
unsigned long header[3],*body;
char *cbody;
  if((count = read(Fvwm_fd[1],header,3*sizeof(unsigned long))) >0) {
    if(header[0] == START_FLAG) {
      body_length = header[2]-3;
      body = (unsigned long *)
        safemalloc(body_length*sizeof(unsigned long));
      
      cbody = (char *)body;
      total = 0;
      while(total < body_length*sizeof(unsigned long)) {
        if((count2=read(Fvwm_fd[1],&cbody[total],
           body_length*sizeof(unsigned long)-total)) >0) total += count2;
        else if(count2 < 0) exit(1);
      }
      ProcessMessage(header[1],body);
      free(body);
    }
  } else exit(1);
}

/******************************************************************************
  ProcessMessage - Process the message coming from Fvwm
    Skeleton based on processmessage() from FvwmIdent:
      Copyright 1994, Robert Nation and Nobutaka Suzuki.
******************************************************************************/
void ProcessMessage(unsigned long type,unsigned long *body)
{
  if (type==M_NEW_DESK) {
    if (body[0]>DeskCount || commands[body[0]]==NULL) return;
    system(commands[body[0]]);
  }
}

/******************************************************************************
  SendFvwmPipe - Send a message back to fvwm 
    Based on SendInfo() from FvwmIdent:
      Copyright 1994, Robert Nation and Nobutaka Suzuki.
******************************************************************************/
void SendFvwmPipe(char *message,unsigned long window)
{
int w;
char *hold,*temp,*temp_msg;
  hold=message;

  while(1) {
    temp=strchr(hold,',');
    if (temp!=NULL) {
      temp_msg=malloc(temp-hold+1);
      strncpy(temp_msg,hold,(temp-hold));
      temp_msg[(temp-hold)]='\0';
      hold=temp+1;
    } else temp_msg=hold;

    write(Fvwm_fd[0],&window, sizeof(unsigned long));

    w=strlen(temp_msg);
    write(Fvwm_fd[0],&w,sizeof(int));
    write(Fvwm_fd[0],temp_msg,w);

    /* keep going */
    w=1;
    write(Fvwm_fd[0],&w,sizeof(int));

    if(temp_msg!=hold) free(temp_msg);
    else break;
  }
}

/***********************************************************************
  Detected a broken pipe - time to exit 
    Based on DeadPipe() from FvwmIdent:
      Copyright 1994, Robert Nation and Nobutaka Suzuki.
 **********************************************************************/
void DeadPipe(int nonsense)
{
  exit(1);
}

/******************************************************************************
  ParseConfig - Parse the configuration file fvwm to us to use
    Based on part of main() from FvwmIdent:
      Copyright 1994, Robert Nation and Nobutaka Suzuki.
******************************************************************************/
void ParseConfig(char *file)
{
char line[256];
char line2[40];
char *tline;
FILE *ptr;
  sprintf(line2,"*%sDesk",Module);
  ptr=fopen(file,"r");
  if(ptr != (FILE *)NULL) {

    tline = fgets(line,(sizeof line)-1,ptr);
    while(tline != (char *)0) {
      while(isspace(*tline))tline++;
      if(strlen(tline)>1) {
        if(strncasecmp(tline,line2,strlen(line2))==0)
           AddCommand(&tline[strlen(line2)]);
      }
      tline = fgets(line,(sizeof line)-1,ptr);
    }
  }
}

/******************************************************************************
AddCommand - Add a command to the correct spot on the dynamic array.
******************************************************************************/
void AddCommand(char *string)
{
char *temp;
int num;
  temp=string;
  while(isspace(*temp)) temp++;
  num=atoi(temp);
  while(!isspace(*temp)) temp++;
  while(isspace(*temp)) temp++;
  if (DeskCount<1) {
    commands=(char **)safemalloc((num+1)*sizeof(char *));
    while(DeskCount<num+1) commands[DeskCount++]=NULL;
  }
  else {
    if (num+1>DeskCount) {
      commands=(char **)realloc(commands,(num+1)*sizeof(char *));
      while(DeskCount<num+1) commands[DeskCount++]=NULL;
    }
  }
  commands[num]=(char *)safemalloc(strlen(temp)+1);
  strcpy(commands[num],temp);

}
