/*
 * METALBASE 5.1
 *
 * Released January 1st, 1993 by Huan-Ti [ t-richj@microsoft.com ]
 *
 */

/*
 * Make sure you include "input.h" before <mbase.h>--see VR.C
 *
 */

#include "input.h"
#include <mbase.h>


WINDOW *win = (WINDOW *)0;
char    editorname[128];

/*
 * DEFINITIONS ----------------------------------------------------------------
 *
 */

#ifndef F_SETFL

#define DELAY_TIME   1

#else

#ifdef TROUBLE
#define DELAY_TIME  40
#else
#define DELAY_TIME 100
#endif

#endif


/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

#ifndef MSDOS
   extern long   atol  XARGS( (char *) );
   extern double atof  XARGS( (char *) );
#endif

   static int    GetPage XARGS( (char *, mchar *, int) );


   char    str[160], str2[160];  /* Reenterable one time (for CTRL_E) */


/*
 * ROUTINES -------------------------------------------------------------------
 *
 */

/*
 * getarr() functions like getch(), but returns special codes for arrow
 * keys as well.  If we're compiling with USE_CURKEY, mbase.h has decided
 * that the curses package is capable of returning keycodes directly;
 * if so, we just map them to our defines.  If not, we have to try to snatch
 * the escape codes ourselves.
 *
 */

#ifdef USE_CURKEY

char
getarr ()
{
   int   ch;

   do  ch = (int)getch();
   while (ch == 0);

   if (ch == KEY_UP)     return (char)AR_UP;
   if (ch == KEY_DOWN)   return (char)AR_DOWN;
   if (ch == KEY_LEFT)   return (char)AR_LEFT;
   if (ch == KEY_RIGHT)  return (char)AR_RIGHT;
   if (ch == KEY_IC)     return (char)AR_INS;
   if (ch == KEY_DC)     return (char)AR_DEL;
   if (ch == KEY_HOME)   return (char)AR_HOME;
   if (ch == KEY_LL)     return (char)AR_END;
   if (ch == KEY_PPAGE)  return (char)AR_PGUP;
   if (ch == KEY_NPAGE)  return (char)AR_PGDN;

   return (char)ch;
}

#else

char
getarr ()
{
   register int   x;
   char          *a,*b,*c,*d,*e,*f,*g,*h,*i,*j,ch;
   static char   *up="\033[A";
   static char   *down="\033[B";
   static char   *left="\033[D";
   static char   *right="\033[C";
   static char   *ins="\033[@";
   static char   *del="\033[P";
   static char   *home="\033[H";
   static char   *end="\033[24H";
   static char   *pgup="\033[V";
   static char   *pgdn="\033[U";

   do {
      ch = (char)getch();  if (ch < 0)  ch = 0;

      if (ch != *(a= up))     a=NULL;  else a++;
      if (ch != *(b= down))   b=NULL;  else b++;
      if (ch != *(c= left))   c=NULL;  else c++;
      if (ch != *(d= right))  d=NULL;  else d++;
      if (ch != *(e= ins))    e=NULL;  else e++;
      if (ch != *(f= del))    f=NULL;  else f++;
      if (ch != *(g= home))   g=NULL;  else g++;
      if (ch != *(h= end))    h=NULL;  else h++;
      if (ch != *(i= pgup))   i=NULL;  else i++;
      if (ch != *(j= pgdn))   j=NULL;  else j++;

      if (!a && !b && !c && !d && !e && !f && !g && !h && !i && !j)  break;

#ifdef F_SETFL
      fcntl (0, F_SETFL, O_NDELAY);  /* Turn off waiting for keys */
#endif

      for (;;)
         {
         if (a && !*a) { ch = AR_UP;     break; }
         if (b && !*b) { ch = AR_DOWN;   break; }
         if (c && !*c) { ch = AR_LEFT;   break; }
         if (d && !*d) { ch = AR_RIGHT;  break; }
         if (e && !*e) { ch = AR_INS;    break; }
         if (f && !*f) { ch = AR_DEL;    break; }
         if (g && !*g) { ch = AR_HOME;   break; }
         if (h && !*h) { ch = AR_END;    break; }
         if (i && !*i) { ch = AR_PGUP;   break; }
         if (j && !*j) { ch = AR_PGDN;   break; }

         if (!a && !b && !c && !d && !e && !f && !g && !h && !i && !j)
            {
            ch = (*(up));
            break;
            }

         for (x=0; x < DELAY_TIME; x++)       /* DELAY_TIME quick reads */
            {
            if ((ch = (char)getch()) > 0)  break;
#ifdef TROUBLE
            usleep (100);
#endif
            }
         if (x == DELAY_TIME)
            {
            ch = (*(up));
            break;
            }

         a = (a!=NULL && ch == *a) ? a+1 : NULL;
         b = (b!=NULL && ch == *b) ? b+1 : NULL;
         c = (c!=NULL && ch == *c) ? c+1 : NULL;
         d = (d!=NULL && ch == *d) ? d+1 : NULL;
         e = (e!=NULL && ch == *e) ? e+1 : NULL;
         f = (f!=NULL && ch == *f) ? f+1 : NULL;
         g = (g!=NULL && ch == *g) ? g+1 : NULL;
         h = (h!=NULL && ch == *h) ? h+1 : NULL;
         i = (i!=NULL && ch == *i) ? i+1 : NULL;
         j = (j!=NULL && ch == *j) ? j+1 : NULL;
         }

#ifdef F_SETFL
      fcntl (0, F_SETFL, 0);
#endif
      } while (! ch);

   return ch;
}

#endif

bool _fUpdateNow = TRUE;

void
display (buf, typ, siz)
dataptr  buf;
ftype         typ;
int                siz;
{
   int       b, a, i, n;
   double    tdouble;
   char      temp[21];

   getyx    (win,b,a);
   sprintf  (str, "%-132.132s", "");  str[siz] = 0;
   mvaddstr (b,a, str);

   switch (typ)
      {
      case T_CHAR:    strzcpy (str, buf,   siz);                      break;
      case T_SHORT:   sprintf (str, "%d",  (int)*(short  *)buf);      break;
      case T_USHORT:  sprintf (str, "%u",  (int)*(ushort *)buf);      break;
      case T_LONG:    sprintf (str, "%ld", *(long   *)buf);           break;
      case T_ULONG:   sprintf (str, "%lu", *(ulong  *)buf);           break;
      case T_FLOAT:   sprintf (str, "%f",  *(float  *)buf);           break;
      case T_DOUBLE:  sprintf (str, "%lf", *(double *)buf);           break;
      case T_MONEY:   tdouble = *(double *)buf;
                      sprintf (str, "%-.2lf", tomoney(tdouble));      break;
      case T_TIME:    strcpy (str, fmt_time (*(mb_time *)buf, 1));    break;
      case T_DATE:    strcpy (str, fmt_date (*(mb_date *)buf, 0));    break;
      case T_SERIAL:  sprintf (str, "%ld", *(long   *)buf);           break;
      case T_PHONE:   strcpy (str, fmt_phone ((mb_phone *)buf, 1));   break;
      case T_BYTE:    hextostr (str, buf, min(20, siz));              break;

      case T_MBYTE:   siz = (int)GetPage (temp, (mchar *)buf, 20);
                      hextostr (str, temp, min(20, siz));             break;
      case T_MCHAR:   n = GetPage (str, (mchar *)buf, 60);
                      for (i = 0; i < n; i++)
                         if (str[i] < ' ')
                            str[i] = '_';
                     break;
      }

   if (typ == T_BYTE)  str[3*min(20,siz) -1] = 0;
   else                str[siz] = 0;

   mvaddstr (b,a, str);
   move     (b,a);

   if (_fUpdateNow)
      refresh ();
   _fUpdateNow = TRUE;
}

/*
 * Returns:     0 -- Continue to next field
 *              1 -- Finished with DE
 *             -1 -- Abort DE
 *          other -- Field control (-/+/j/k)
 *
 */

char
input   (buf, typ, siz)
dataptr  buf;
ftype         typ;
int                siz;
{
   register int  i;
   double        tdouble;
   char          c;                  /* Character read from keyboard      */
   char         *org;                /* Working buffer, and backup string */
   int           len;                /* Length of working buffer          */
   int           y, x;               /* Position of left-edge on screen   */
   bool          fStart = TRUE;      /* TRUE if just starting             */
   int           pos = 0;            /* Working position within buffer    */
   int           width;              /* Width of edit field (usually siz) */

   width = (typ == T_BYTE) ? (3*siz -1) : siz;

   raw(); noecho();           /* First we have to initialize the terminal */
   getyx (win, y, x);         /* so we can ensure an active interface.    */

   if ((org = (char *)malloc (width+1)) == NULL)
      {
      SetError (MB_NO_MEMORY);
      return -1;  /* Abort DE */
      }

   display (buf, typ, siz);   /* Display the original string              */
   len = strlen (str);        /* And remember how long the string is now. */
   numcpy (org, str, width);  /* Then make a backup, so CTRL_U will work. */

   if ( (typ == T_MCHAR) || (typ == T_MBYTE) )
      {
      (void)CallService (svcIN_START);
      }

   for (;;)
      {
      movech (c,y,x+pos);

      if (strchr (quit_chars, c))
         break;

      if ( (c == CTRL_E) && ((typ == T_MCHAR) || (typ == T_MBYTE)) )
         {
         strcpy (str2, str);
         strcpy (editorname, DEFAULT_EDITOR);

         if (! CallService (svcIN_EDITOR))     /* If aborted here, */
            {
            (void)CallService (svcIN_START);   /* return to editing field */
            continue;
            }

         strcpy (str, str2);
         strcat (editorname, " ");
         strcat (editorname, ((mchar *)buf)->name);

         system (editorname);

         clearok (win, TRUE);
         refresh ();
         move    (y, x);
         display (buf, typ, siz);

         (void)CallService (svcIN_START);   /* return to editing field */
         continue;
         }

      if (c == ESC)      { c = 'q';  break; }  /* ESC    aborts */
      if (c == CTRL_C)   { c = 'q';  break; }  /* Ctrl-C aborts */
      if (c == CTRL_Q)   { c = 'q';  break; }  /* Ctrl-Q aborts */
      if (c == AR_PGUP)  { c = 'k';  break; }
      if (c == AR_UP)    { c = 'k';  break; }
      if (c == AR_PGDN)  { c = 'j';  break; }
      if (c == AR_DOWN)  { c = 'j';  break; }
      if (c == CTRL_L)   { clearok (win, TRUE);  refresh();  continue; }
      if (c == AR_END)   { pos = len;  continue; }
      if (c == CTRL_U)   { strcpy  (str, org);
                           move (y, x); display (buf, typ, siz);
                           len=strlen(str); fStart = TRUE;
                           c = AR_HOME;  /* Pretend they hit HOME afterward. */
                         }
      if (c == AR_HOME)  { pos = 0;
                           continue;
                         }
      if (c == AR_RIGHT) { if (pos < len)  pos++;
                           continue;
                         }
      if (c == AR_LEFT)  { if (pos > 0)  pos--;
                           continue;
                         }

      if (c == '\r' || c == '\n' || c == CTRL_A)
         {
         break;
         }
      if ( (typ == T_MCHAR) || (typ == T_MBYTE) )
         {
         continue;
         }
      if (c == '\b' || c == 127 || c == AR_LEFT || c == AR_DEL)
         {
         if (pos != 0)
            {
            pos--,len--,mvdelch(y,x+pos),mvinsch(y,x+width-1,' ');
            for (i=pos; i<len; i++)
               str[i] = str[i+1];
            str[i] = 0;
            }
         }
      if (c < ' ' || c > '~')
         {
         continue;
         }

      if (pos == 0 && fStart)
         {
         for (i=0; i<len; i++)
            mvdelch(y,x),mvinsch(y,x+width-1,' ');
         str[0] = 0;  len = 0;  move(y,x);  refresh();
         }
      fStart = FALSE;
      if (len == width)  continue;
      insch(c);  mvdelch(y,x+width);
      for (i=len-1; i>=pos; i--)
         str[i+1] = str[i];
      len++;  str[len] = 0;
      str[pos] = c;  pos++;
#ifdef ADVANCE_AT_END
      if (len == width) { c = 'j'; break; }
#endif
      continue;
      }

   if ( (typ == T_MCHAR) || (typ == T_MBYTE) )
      {
      (void)CallService (svcIN_END);
      }

   if (c == 'q' || c == 'Q')  /* If backing out, restore original string. */
      {
      strcpy (str, org);
      }

   switch (typ)
      {
      case T_CHAR:    strncpy (buf, str, siz);                 break;
      case T_SHORT:   *(short  *)buf  = (short) atoi(str);     break;
      case T_USHORT:  *(ushort *)buf  = (ushort)atoi(str);     break;
      case T_LONG:    *(long   *)buf  = (long)  atol(str);     break;
      case T_ULONG:   *(ulong  *)buf  = (ulong) atol(str);     break;
      case T_FLOAT:   *(float  *)buf  = (float) atof(str);     break;
      case T_DOUBLE:  *(double *)buf  = (double)atof(str);     break;
      case T_MONEY:   tdouble = (double)atof(str);
                      *(double  *)buf  = tomoney(tdouble);     break;
      case T_SERIAL:  *(long   *)buf  = (long)  atoi(str);     break;
      case T_TIME:    *(mb_time *)buf = scn_time (str);        break;
      case T_DATE:    *(mb_date *)buf = scn_date (str);        break;
      case T_PHONE:   scn_phone ((mb_phone *)buf, str);        break;
      case T_BYTE:    strtohex (buf, str, siz);                break;
      }

   free (org);

   move    (y, x);
   display (buf, typ, siz);

   return (char) ( (c=='\r') ? (char)0
                 : (c=='x'||c=='Z'||c=='\n'||c==CTRL_A) ? (char)1
                 : (c=='q'||c=='Q') ? (char)-1
                 : tolower(c) );
}

void
init_curses ()
{
#ifdef MSDOS
   initscr();
   win = stdscr;
#else
#ifdef AMIGA
   initscr();
   win = stdscr;
#else
   win = initscr();
#endif
#endif
#ifdef USE_CURKEY
   keypad(win, TRUE);
#endif

   savetty();
   raw();
   noecho();
   nl();
   clear();
}

void
exit_curses ()
{
   clear   ();
   refresh ();
   endwin  ();
   resetty ();
}

static int
GetPage (dest, ptr, n)
char    *dest;
mchar         *ptr;
int                 n;
{
   file  fh;

   if ((fh = openx (ptr->name, READMODE)) <= 0)
      n = 0;
   else
      {
      lseek (fh, 0L, 0);
      n = readx (fh, dest, n);
      close (fh);
      }

   dest[n] = 0;
   return n;
}

