/*---------------------------------------------------------------------------
  Module FmAwCb

  (c) S.Marlow 1990-92
  (c) A.Graef 1994

  Callback routines for widgets in the application window
---------------------------------------------------------------------------*/

#include <stdio.h>
#include <memory.h>

#include <X11/Intrinsic.h>

#include "Am.h"

/*---------------------------------------------------------------------------
  PUBLIC FUNCTIONS
---------------------------------------------------------------------------*/

void appInstallCb(Widget w, FileWindowRec *fw, XtPointer call_data)
{
  installNewPopup();
}

/*---------------------------------------------------------------------------*/

void appEditCb(Widget w, FileWindowRec *fw, XtPointer call_data)
{
  installExistingPopup();
}

/*---------------------------------------------------------------------------*/

void appMoveCb(Widget w, FileWindowRec *fw, XtPointer call_data)
{
  int i;
  for (i=0; i<aw.n_apps; i++)
    if (aw.apps[i].selected) {
      moveApplication(i);
      break;
    }
  updateApplicationDisplay();
}

/*---------------------------------------------------------------------------*/

void appCopyCb(Widget w, FileWindowRec *fw, XtPointer call_data)
{
  int i;
  for (i=0; i<aw.n_apps; i++)
    if (aw.apps[i].selected) {
      installApplication(aw.apps[i].name, aw.apps[i].directory,
			 aw.apps[i].fname, aw.apps[i].icon,
			 aw.apps[i].push_action, aw.apps[i].drop_action);
      break;
    }
  updateApplicationDisplay();
}

/*---------------------------------------------------------------------------*/

void appRemoveCb(Widget w, FileWindowRec *fw, XtPointer call_data)
{
  char s[0xff];
  int i;

  if (resources.confirm_deletes) {
    sprintf(s, "Deleting %d item%s from", aw.n_selections,
	    aw.n_selections > 1 ? "s" : "" );
    if (!confirm(s, "the applications window", ""))
      return;
  }

  for (i=0; i<aw.n_apps; i++)
    if (aw.apps[i].selected) {
      removeApplication(i);
      i--;
    }
  updateApplicationDisplay();
}

/*---------------------------------------------------------------------------*/

void appSaveCb(Widget w, FileWindowRec *fw, XtPointer call_data)
{
  writeApplicationData(resources.app_file);
}

/*---------------------------------------------------------------------------*/

void appLoadCb(Widget w, FileWindowRec *fw, XtPointer call_data)
{
  int i;

  for(i=0; i<aw.n_apps; i++)
    freeApplicationResources(&aw.apps[i]);
  XTFREE(aw.apps);

  readApplicationData(resources.app_file);
  updateApplicationDisplay();
}

/*---------------------------------------------------------------------------*/

void appOpenCb(Widget w, FileWindowRec *fw, XtPointer call_data)
{
  newFileWindow(user.home,resources.initial_display_type,False);
}

/*---------------------------------------------------------------------------*/

void appCloseCb(Widget w, FileWindowRec *fw, XtPointer call_data)
{
  if (resources.confirm_quit && !confirm("", "Exit file manager?", ""))
    return;

  quit();
}
