/*
 * k_compat.h 1.18 1996/11/20 07:49:37 (David Hinds)
 */

#ifndef _LINUX_K_COMPAT_H
#define _LINUX_K_COMPAT_H

#define VERSION(v,p,s) (((v)<<16)+(p<<8)+s)

#if (LINUX_VERSION_CODE < VERSION(2,1,4))
#define FS_SIZE_T int
#define U_FS_SIZE_T int
#else
#define FS_SIZE_T long
#define U_FS_SIZE_T unsigned long
#endif

#if (LINUX_VERSION_CODE < VERSION(1,3,0))

#define RUN_AT(x) (x)
#define CONST
#define ALLOC_SKB(len) alloc_skb(len, GFP_ATOMIC)
#define DEVICE(req) ((req)->dev)
#define GET_PACKET(dev, skb, pkt_len) \
	(skb)->len = (pkt_len); \
	BLOCK_INPUT((skb)->data, (pkt_len))
#undef GET_SCSI_INFO

#define readb(p)		(*(volatile u_char *)(p))
#define readw(p)		(*(volatile u_short *)(p))
#define writeb(b, p)		(*(volatile u_char *)(p) = b)
#define writew(w, p)		(*(volatile u_short *)(p) = w)
#define memcpy_fromio(a, b, c)	memcpy((a), (void *)(b), (c))
#define memcpy_toio(a, b, c)	memcpy((void *)(a), (b), (c))

#else /* 1.3.0 */

#define RUN_AT(x) (jiffies+(x))
#define CONST const
#define ALLOC_SKB(len) dev_alloc_skb(len+2)
#define DEVICE(req) ((req)->rq_dev)
#define GET_PACKET(dev, skb, pkt_len) \
	skb_reserve((skb), 2); \
	BLOCK_INPUT(skb_put((skb), (pkt_len)), (pkt_len)); \
	(skb)->protocol = eth_type_trans((skb), (dev))
#define GET_SCSI_INFO

#endif /* 1.3.0 */

#if (LINUX_VERSION_CODE >= VERSION(1,3,31))
#define GET_8390_HDR 1
#endif /* 1.3.31 */

#if (LINUX_VERSION_CODE < VERSION(1,3,36))
#define BLK_DEV_HDR "drivers/block/blk.h"
#else /* 1.3.36 */
#define BLK_DEV_HDR "linux/blk.h"
#endif /* 1.3.36 */

#if (LINUX_VERSION_CODE < VERSION(1,3,38))

#ifdef MODULE
#include <linux/module.h>
#if !defined(CONFIG_MODVERSIONS) && !defined(__NO_VERSION__)
char kernel_version[] = UTS_RELEASE;
#endif
#else
#define MOD_DEC_USE_COUNT
#define MOD_INC_USE_COUNT
#endif

#else /* 1.3.38 */

#ifdef CONFIG_MODVERSIONS
#define MODVERSIONS 1
#if (LINUX_VERSION_CODE >= VERSION(1,3,40))
#include <linux/modversions.h>
#endif
#endif
#include <linux/module.h>

#endif /* 1.3.38 */

#if (LINUX_VERSION_CODE >= VERSION(1,3,44))
#define NEW_MULTICAST
#endif /* 1.3.44 */

#if (LINUX_VERSION_CODE >= VERSION(1,3,70))
#define FREE_IRQ(i) free_irq(i, NULL)
#define REQUEST_IRQ(i,h,f,n) request_irq(i,h,f,n,NULL)
#define IRQ(a,b,c) (a,b,c)
#else
#define FREE_IRQ(i) free_irq(i)
#define REQUEST_IRQ(i,h,f,n) request_irq(i,h,f,n)
#define IRQ(a,b,c) (a,c)
#endif

#if (LINUX_VERSION_CODE < VERSION(2,1,0))
#define copy_from_user memcpy_fromfs
#define copy_to_user memcpy_tofs
#if (LINUX_VERSION_CODE >= VERSION(1,3,0))
/* This is evil... throw away the built-in get_user in 1.3, 2.0 */
#include <asm/segment.h>
#undef get_user
#else
#define put_user(x, ptr) \
((sizeof(*ptr) == 4) ? put_fs_long(x, ptr) : \
 (sizeof(*ptr) == 2) ? put_fs_word(x, ptr) : \
 put_fs_byte(x, ptr))
#endif
#define get_user(x, ptr) \
((sizeof(*ptr) == 4) ? (x = get_fs_long(ptr)) : \
 (sizeof(*ptr) == 2) ? (x = get_fs_word(ptr)) : \
 (x = get_fs_byte(ptr)))
#else /* 2.1.X */
#include <asm/uaccess.h>
#endif

#if (LINUX_VERSION_CODE < VERSION(2,0,16))
#define init_waitqueue(p) (*(p) = NULL)
#endif

#endif /* _LINUX_K_COMPAT_H */
