/* in.cfingerd.c -- GNU Finger call-in inet daemon. */

/* Copyright (C) 1988,1990,1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <stdio.h>
#include <config.h>
#include <sys/types.h>
#include <tcp.h>
#include <packet.h>
#include <os.h>
#include <netinet/in.h>


/* If this is non-zero then all instances of users are reported on
   instead of having one unique entry for each user. */
int all_users = 0;

/* **************************************************************** */
/*								    */
/*			Client Finger Daemon			    */
/*								    */
/* **************************************************************** */

/* This gets invoked when called by the GNU Finger server host.  The only
   purpose of this code is to return local finger packets in binary. */
main (argc, argv)
     int argc;
     char **argv;
{
  register int i;
  FINGER_PACKET **packets;
  char *buffer = NULL;
  int buffer_size = 0;

  default_error_handling (argv[0]);

  if (getline (&buffer, &buffer_size, stdin) < 0)
    exit (1);

  xfree (buffer);

  packets = get_finger_data (1);

  for (i = 0; packets[i]; i++)
    write_packet (packets[i], stdout);

  free_array (packets);

  fflush (stdout);
  exit (0);
}
