/***************************************************************************
 * This program is Copyright (C) 1986, 1987, 1988 by Jonathan Payne.  JOVE *
 * is provided to you without charge, and with no warranty.  You may give  *
 * away copies of JOVE, including sources, provided that this notice is    *
 * included in all the files.                                              *
 ***************************************************************************/

#include "jove.h"
#include "ctype.h"
#include "disp.h"
#include "ask.h"
#include "c.h"
#include "delete.h"
#include "insert.h"
#include "extend.h"
#include "fmt.h"
#include "marks.h"
#include "misc.h"
#include "move.h"
#include "paragraph.h"

#include <signal.h>

void
prCTIME()
{
	s_mess(": %f %s", get_time((time_t *)NULL, (char *)NULL, 0, -1));
}

void
ChrToOct()
{
	int	c,
		slow = NO;

	c = waitchar(&slow);
	ins_str(sprint("\\%03o", c), NO);
}

void
StrLength()
{
	static const char	inquotes[] = "Where are the quotes?";
	char	*first = StrIndex(BACKWARD, linebuf, curchar, '"'),
		*last = StrIndex(FORWARD, linebuf, curchar + 1, '"'),
		c;
	int	numchars = 0;

	if (first == NULL || last == NULL)
		complain(inquotes);
	first += 1;
	while (first < last) {
		c = *first++;
		if (c == '\\') {
			int	num;

			if (!jisdigit(*first)) {
				first += 1;
			} else {
				num = 3;
				do ; while (num-- && jisdigit(*first++) && first < last);
			}
		}
		numchars += 1;
	}
	s_mess("%d characters", numchars);
}

/* Transpos cur_char with cur_char - 1 */

void
TransChar()
{
	char	before;

	if (curchar == 0 || (eolp() && curchar == 1))
		complain((char *)NULL);	/* BEEP */
	if (eolp())
		b_char(1);
	before = linebuf[curchar - 1];
	del_char(BACKWARD, 1, NO);
	f_char(1);
	insert_c(before, 1);
}

/* Switch current line with previous one */

void
TransLines()
{
	daddr	old_prev;

	if (firstp(curline))
		return;
	lsave();
	/* Exchange l_dline values.
	 * This somewhat breaks the buffer abstraction.
	 */
	old_prev = curline->l_prev->l_dline;
	curline->l_prev->l_dline = curline->l_dline;
	curline->l_dline = old_prev;
	if (!lastp(curline))
		line_move(FORWARD, 1, NO);
	modify();
	DOLsave = NO;	/* contents of linebuf need not override l_dline. */
}

void
Leave()
{
	longjmp(mainjmp, QUIT);
}

/* If argument is specified, kill that many lines down.  Otherwise,
   if we "appear" to be at the end of a line, i.e. everything to the
   right of the cursor is white space, we delete the line separator
   as if we were at the end of the line. */

void
KillEOL()
{
	Line	*line2;
	int	char2;
	int	num = arg_value();

	if (is_an_arg()) {
		if (num == 0) {	/* Kill to beginning of line */
			line2 = curline;
			char2 = 0;
		} else {
			line2 = next_line(curline, num);
			if ((LineDist(curline, line2) < num) || (line2 == curline))
				char2 = length(line2);
			else
				char2 = 0;
		}
	} else if (blnkp(&linebuf[curchar])) {
		line2 = next_line(curline, 1);
		if (line2 == curline)
			char2 = length(curline);
		else
			char2 = 0;
	} else {
		line2 = curline;
		char2 = length(curline);
	}
	reg_kill(line2, char2, NO);
}

/* kill to beginning of sentence */

void
KillBos()
{
	negate_arg();
	KillEos();
}

/* Kill to end of sentence */

void
KillEos()
{
	Line	*line1;
	int	char1;

	line1 = curline;
	char1 = curchar;
	Eos();
	reg_kill(line1, char1, YES);
}

void
KillExpr()
{
	Line	*line1;
	int	char1;

	line1 = curline;
	char1 = curchar;
	FSexpr();
	reg_kill(line1, char1, YES);
}

void
Yank()
{
	Line	*line,
		*lp;
	Bufpos	*dot;

	if (killbuf[killptr] == NULL)
		complain("[Nothing to yank!]");
	lsave();
	this_cmd = YANKCMD;
	line = killbuf[killptr];
	lp = lastline(line);
	dot = DoYank(line, 0, lp, length(lp), curline, curchar, curbuf);
	set_mark();
	SetDot(dot);
}

void
ToIndent()
{
	Bol();
	skip_wht_space();
}

void
skip_wht_space()
{
	register char	*cp,
			c;

	for (cp = linebuf + curchar; (c = *cp)!='\0'; cp++)
		if (c != ' ' && c != '\t')
			break;
	curchar = cp - linebuf;
}

/* GoLine -- go to a line, usually wired to goto-line, ESC g or ESC G.
   If no argument is specified it asks for a line number. */
void
GoLine()
{
	Line	*newline;

	if (!is_an_arg())
		set_arg_value(ask_int("Line: ",10));
	newline = next_line(curbuf->b_first, arg_value() - 1);
	PushPntp(newline);
	SetLine(newline);
}

void
NotModified()
{
	unmodify();
}

void
SetLMargin()
{
	int	lmarg = calc_pos(linebuf, curchar);

	if (lmarg >= RMargin)
		complain("[Left margin must be left of right margin]");
	LMargin = lmarg;
}

void
SetRMargin()
{
	int	rmarg = calc_pos(linebuf, curchar);

	if (rmarg <= LMargin)
		complain("[Right margin must be right of left margin]");
	RMargin = rmarg;
}
