/* pd67xx.h v1.5: 1995/01/13 16:18:33 (David Hinds) */

#ifndef _LINUX_PD67XX_H
#define _LINUX_PD67XX_H

#define PD67_MISC_CTL_1		0x16	/* Misc control 1 */
#define PD67_FIFO_CTL		0x17	/* FIFO control */
#define PD67_MISC_CTL_2		0x1E	/* Misc control 2 */
#define PD67_CHIP_INFO		0x1f	/* Chip information */
#define PD67_EXT_INDEX		0x2e	/* Extension index */
#define PD67_EXT_DATA		0x2f	/* Extension data */

/* I/O window address offset */
#define PD67_IO_OFF(w)		(0x36+((w)<<1))

/* Timing register sets */
#define PD67_TIME_SETUP(n)	(0x3a + 3*(n))
#define PD67_TIME_CMD(n)	(0x3b + 3*(n))
#define PD67_TIME_RECOV(n)	(0x3c + 3*(n))

/* Flags for PD67_MISC_CTL_1 */
#define PD67_MC1_5V_DET		0x01	/* 5v detect */
#define PD67_MC1_VCC_3V		0x02	/* 3.3v Vcc */
#define PD67_MC1_PULSE_MGMT	0x04
#define PD67_MC1_PULSE_IRQ	0x08
#define PD67_MC1_SPKR_ENA	0x10
#define PD67_MC1_INPACK_ENA	0x80

/* Flags for PD67_FIFO_CTL */
#define PD67_FIFO_EMPTY		0x80

/* Flags for PD67_MISC_CTL_2 */
#define PD67_MC2_FREQ_BYPASS	0x01
#define PD67_MC2_DYNAMIC_MODE	0x02
#define PD67_MC2_SUSPEND	0x04
#define PD67_MC2_5V_CORE	0x08
#define PD67_MC2_LED_ENA	0x10	/* IRQ 12 is LED enable */
#define PD67_MC2_3STATE_BIT7	0x20	/* Floppy change bit */
#define PD67_MC2_DMA_MODE	0x40
#define PD67_MC2_IRQ15_RI	0x80	/* IRQ 15 is ring enable */

/* Special for CL6729 PCI chip */
#define PD67_MC2_FAST_PCI	0x10	/* Set if PCI bus > 25 MHz */

/* Flags for PD67_CHIP_INFO */
#define PD67_INFO_SLOTS		0x20	/* 0 = 1 slot, 1 = 2 slots */
#define PD67_INFO_CHIP_ID	0xc0
#define PD67_INFO_REV		0x1c

/* Fields in PD67_TIME_* registers */
#define PD67_TIME_SCALE		0xc0
#define PD67_TIME_SCALE_1	0x00
#define PD67_TIME_SCALE_16	0x40
#define PD67_TIME_SCALE_256	0x80
#define PD67_TIME_SCALE_4096	0xc0
#define PD67_TIME_MULT		0x3f

/* Extension registers -- indexed in PD67_EXT_INDEX */
#define PD67_DATA_MASK0		0x01	/* Data mask 0 */
#define PD67_DATA_MASK1		0x02	/* Data mask 1 */
#define PD67_DMA_CTL		0x03	/* DMA control */

/* Fields in PD67_DMA_CTL */
#define PD67_DMA_MODE		0xc0
#define PD67_DMA_OFF		0x00
#define PD67_DMA_DREQ_INPACK	0x40
#define PD67_DMA_DREQ_WP	0x80
#define PD67_DMA_DREQ_BVD2	0xc0
#define PD67_DMA_PULLUP		0x20	/* Disable socket pullups? */

#endif /* _LINUX_PD67XX_H */
