#include <stdio.h>
#include <sys/errno.h>

void describe_error(void)
{
	switch (errno)
	{
	case ENODEV:
		fprintf(stderr,	"The device file was found in /dev but\n"
				"there is no driver for it in the kernel.\n"
				"\n"
				"There is several possible reasons:\n"
				"- The sound driver is not present\n"
				"  in the kernel you are currently running.\n"
				"- The driver is in the kernel but there is\n"
				"  no soundcard on your system.\n"
				"- Configuration of the sound driver doesn't\n"
				"  match the hardware.\n");
				"\n"
				"Try cat /dev/sndstat for further info.\n");
		break;

	case ENOSPC:
		fprintf(stderr,	"The soundcard driver was not installed\n"
				"properly. The sound_mem_init() routine\n"
				"was not called during the boot procedure.\n");
		break;

	case ENOENT:
		fprintf(stderr,	"The device file is missing from /dev.\n"
				"Run the script at the end of file\n"
				"sound/linux/Readme (distributed with\n"
				"the sound driver.\n");
		break;

	default: ;
	}
}
