#!/bin/sh
MAJOR=29
# Create the devices
#
#	Mixer				[ Control ]
#
rm -f /dev/mixer
mknod /dev/mixer 	c $MAJOR 0
chmod 666 /dev/mixer
#
#	Sequencer			[ FM Synth and MIDI output ]
#
rm -f /dev/sequencer
mknod /dev/sequencer	c $MAJOR 1
chmod 666 /dev/sequencer
#
# 	Midi input			[ Not implemented ]
#
rm -f /dev/midi
mknod /dev/midi		c $MAJOR 2
#
#	DSP				[ Digitized voice ]
#
rm -f /dev/dsp
mknod /dev/dsp		c $MAJOR 3
chmod 666 /dev/dsp
#
#	SPARC audio			[ Not fully implemented ]
#
rm -f /dev/audio
mknod /dev/audio	c $MAJOR 4
chmod 666 /dev/audio
#
#	DSP16				[ Same as /dev/dsp, except 16 bits ]
#
rm -f /dev/dsp16
mknod /dev/dsp16	c $MAJOR 5
chmod 666 /dev/dsp16
#
#	Status Device			[ Debugging interface ]
#
rm -f /dev/sndstat
mknod /dev/sndstat	c $MAJOR 6
chmod 666 /dev/sndstat
#
# 	PRO_MIDI 			[PAS midi input and output]
#
rm -f /dev/pro_midi
mknod /dev/pro_midi	c $MAJOR 15
chmod 666 /dev/pro_midi
#
#	DSP 1 				[ SB emulation of PAS16 or 2nd audio ]
#
rm -f /dev/dsp1
mknod /dev/dsp1		c $MAJOR 19
chmod 666 /dev/dsp1
#
#	Sparc Audio 1			[ SB emulation of PAS16 or 2nd audio ]
#
rm -f /dev/audio1
mknod /dev/audio1	c $MAJOR 20
chmod 666 /dev/audio1
#
#	
exit 0
