/*
 * ---------------------------------------------------------------------------
 * sfxserver/error.c
 *
 * Copyright by Terry Evans 1994
 * tevans@cs.utah.edu, tevans@slc.unisys.com
 * ---------------------------------------------------------------------------
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ---------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>


#include "error.h"


void E_ErrnoFatalError(char *name, ...)
{
  extern int errno, sys_nerr;
  extern char *sys_errlist[];

  va_list args;

  /* Function name and format */
  char *format;

  /* Start the variable args */
  va_start(args, name);

  format = va_arg(args, char *);

  fprintf(stderr, "%s: ", name);
  vfprintf(stderr, format, args);
  fprintf(stderr, "\n");

  /* See if we have a valid errno */
  if(errno > 0 && errno < sys_nerr)
    fprintf(stderr, "  errno = %d (%s)\n", errno, sys_errlist[errno]);

  /* Start the variable args */
  va_end(args);

  exit(-1);
}


void E_ErrnoNonFatalError(char *name, ...)
{
  extern int errno, sys_nerr;
  extern char *sys_errlist[];

  va_list args;

  /* Function name and format */
  char *format;

  /* Start the variable args */
  va_start(args, name);

  format = va_arg(args, char *);

  fprintf(stderr, "%s: ", name);
  vfprintf(stderr, format, args);
  fprintf(stderr, "\n");

  /* See if we have a valid errno */
  if(errno > 0 && errno < sys_nerr)
    fprintf(stderr, "  errno = %d (%s)\n", errno, sys_errlist[errno]);

  /* Start the variable args */
  va_end(args);
}


void E_FatalError(char *name, ...)
{
  va_list args;

  /* Function name and format */
  char *format;

  /* Start the variable args */
  va_start(args, name);

  format = va_arg(args, char *);

  fprintf(stderr, "%s: ", name);
  vfprintf(stderr, format, args);
  fprintf(stderr, "\n");

  /* Start the variable args */
  va_end(args);

  exit(-1);
}


void E_NonFatalError(char *name, ...)
{
  va_list args;

  /* Function name and format */
  char *format;

  /* Start the variable args */
  va_start(args, name);

  format = va_arg(args, char *);

  fprintf(stderr, "%s: ", name);
  vfprintf(stderr, format, args);
  fprintf(stderr, "\n");

  /* Start the variable args */
  va_end(args);
}
