/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 *
 * sco.c - Show images on PCs under Unix/SCO using ioctl.
 *
 * Portions:    Eric Thiebaut
 *              ENSIMAG
 *              University of Grenoble
 * E-mail:      thiebaut@ensisun.imag.fr
 * Date:        Sun Feb 6 1994
 * Copyright (c) 1994, Eric Thiebaut
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Mon Jan 4 1993
 * Copyright (c) 1993, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>


/*
 * Look here !!!
 * =============
 *
 * This code is valid only if we have defined the iSCO
 * macro ( read the root Makefile for more information ).
 *
 */

#ifdef iSCO

#include <stdio.h>
#include <fcntl.h>
#include <sys/console.h>

static int vga;

static void GrSetColor(int i,int r,int g,int b)
{
struct port_io_arg arg;
arg.args[0].dir=OUT_ON_PORT;
arg.args[0].port=0x3C8;
arg.args[0].data=i;
arg.args[1].dir=OUT_ON_PORT;
arg.args[1].port=0x3C9;
arg.args[1].data=r>>2;
arg.args[2].dir=OUT_ON_PORT;
arg.args[2].port=0x3C9;
arg.args[2].data=g>>2;
arg.args[3].dir=OUT_ON_PORT;
arg.args[3].port=0x3C9;
arg.args[3].data=b>>2;
ioctl(vga,VGAIO,&arg);
}

show_bitmap( name, in, ditherflag )
char *name;
bitmap_hdr *in;
int ditherflag;
{
        bitmap_hdr out8;
        bitmap_hdr out24;
        bitmap_hdr *bitmap8 = in;
        bitmap_hdr *bitmap24 = in;
        register int i, r, g, b;
        register byte *ptr, *scr;
        register int y;
        int xinit, yinit;
        int xsize, ysize;
        double j;
	char *screenptr;

        if ( in->magic != LUGUSED )
                error( 19 );

	/* Only the 320*200 mode is supported now */
        xsize = 320;
        ysize = 200;

        /*
         * Resample if the bitmap are greater than
         * the screen.
         */
        if ( in->xsize > xsize || in->ysize > ysize ) {
                double xfactor, yfactor;
                int newx, newy;

                /* Get the factor to adjust */  
                xfactor = ((double) xsize) / ((double) in->xsize);
                yfactor = ((double) ysize) / ((double) in->ysize);
                /* 
                 * Now, select the correct. What we need is the image
                 * inside the physical display borders, so we choose
                 * the factor which suports this.
                 */
                if ( yfactor*in->xsize > xsize ) {
                        newx = xfactor * in->xsize;
                        newy = xfactor * in->ysize;
                }else {
                        newx = yfactor * in->xsize;
                        newy = yfactor * in->ysize;
                }
                fprintf( stderr, "Resampling to screen ( %dx%d )\n",
                         xsize, ysize); 
                fprintf( stderr, "From %dx%d to %dx%d\n", in->xsize, in->ysize,
                         newx, newy );
                adjust_bitmap( in, &out24, newx, newy, 0 );
                bitmap24 = &out24;
        }

        /*
         * Ooppppsssss !!!, only 8 planes.
         */
        if ( bitmap24->depth > 8 ) {
                if ( ditherflag ) {
                        fprintf( stderr, "Dithering ...\n" );
                        dither_image( bitmap24, &out8, 6, (double) 1.0 );
                }else{
                        fprintf( stderr, "Quantizing ...\n" );
                        quantize( bitmap24, &out8, 256 );
                }
                bitmap8 = &out8;
        }else bitmap8 = bitmap24;

        /* If we are using a resample image, now we can free it */
        if ( bitmap24 == &out24 ) {
                freebitmap( &out24 );
        }

        /* Ok, all do it. Lets go to show the image !. */
	vga=open("/dev/vga",O_RDWR);
	ioctl(vga,SW_VGA13,0L);
	screenptr=(char*)ioctl(vga,MAPVGA,0L);

        /*
         * Set a null color map.
         */
        for ( i = 0; i < 256 ; i++ ) {
                GrSetColor( i, 0, 0, 0 );
        }

        /*
         * Dump the image to screen ( centered ).
         */
        xinit = ( xsize >> 1 ) - ( bitmap8->xsize >> 1 );
        yinit = ( ysize >> 1 ) - ( bitmap8->ysize >> 1 );
        ptr = bitmap8->r;
        scr = screenptr + xinit + yinit * xsize;
        for ( y = 0; y < bitmap8->ysize ; y++, scr += xsize,
                                         ptr += bitmap8->xsize ) {
                bcopy( ptr, scr, bitmap8->xsize );
        }

        /*
         * Fade in the image.
         */
        for ( j = 0.; j <= 1. ; j += 0.05 ) {
                for ( i = 0, ptr = bitmap8->cmap; i < bitmap8->colors ; i++ ) {
                        r = j * (double)*ptr++;
                        g = j * (double)*ptr++;
                        b = j * (double)*ptr++;
                        GrSetColor( i, r, g, b );
                }
        }

        if ( bitmap8 == &out8 )
                freebitmap( &out8 );

        /*
         * Now wait for a interaction ( from the user ) and exit.
         */
	getchar();

        /*
         * Fade out the image.
         */
        for ( j = 1.; j >= 0. ; j -= 0.05 ) {
                for ( i = 0, ptr = bitmap8->cmap; i < bitmap8->colors ; i++ ) {
                        r = j * (double)*ptr++;
                        g = j * (double)*ptr++;
                        b = j * (double)*ptr++;
                        GrSetColor( i, r, g, b );
                }
        }

        /*
         * Return to the text mode.
         */
	ioctl(vga,SW_VGA80x25,0L);
	close(vga);

}


#endif  /* iSCO */

