/*
 *  menuprs.l from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
%start  END_STRING EMBEDDED FILE_NAME HELP_DEF_NAME 
%a 30000
%p 16000
%o 25000
%n 2000
%{
#undef yywrap 
#include "menuprsl.h"
#undef yywrap
extern int yywrap();
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) yy_input_opd(buf,result)
static void yy_input_opd(char * buf, int& result)
{
    int c = mygetc(0);
    // result = (c == EOF) ? YY_NULL : (buf[0] = c, 1);
    if (c == EOF) {
		/* fprintf(stderr,"returned NULL\n"); */
		result = YY_NULL;
		return ;
	}
	result = 1 ;
	buf[0] = c;
}


%}
%%
\/\/.*\n				LineNumber++;  /* cpp style comments */
Init[ \t]*\{				{
						BEGIN EMBEDDED;
						LeftBrace();
						return INIT;
					}
<FILE_NAME>[^\n \t\{\}\:]+		{PushFile(yytext);
					if(EmbSt) {
						BEGIN EMBEDDED;
						EmbSt=0;
					} else BEGIN 0;} 
<EMBEDDED>\nSource[ \t]*:[ \t]*		{LineNumber++; EmbSt=1;BEGIN FILE_NAME;}
\nSource[ \t]*:[ \t]*			{LineNumber++; EmbSt=0;BEGIN FILE_NAME;}
<EMBEDDED>\n				LineNumber++;
<END_STRING>\{[ \t]*\n			{LineNumber++; BraceInit();
					LeftBrace(); BEGIN EMBEDDED;}
\n					{ LineNumber++ ; BEGIN 0 ;}
<EMBEDDED>\{				LeftBrace();
<EMBEDDED>\}				if(RightBrace()) {
						BEGIN 0;
						yylval.Text = CurrentText();
						return TEXT ;
					}
<EMBEDDED>[ \t]+				|
<EMBEDDED>[^\n\$\{\} \t]+(\ [^\n\$\{\} \t]+)* 	AddedText(yytext);
<EMBEDDED>\$[a-zA-Z][ a-zA-Z0-9_+]*[a-zA-Z0-9_+]\$	GetEmbeddedName(yytext);
<END_STRING>\{					|
<END_STRING>\}					|
<END_STRING>[^ \t\n\{\}][^\n\{\}]*[^ \t\n\{\}]	|
<END_STRING>[^ \t\n\{\}]		{yylval.Name = MakeName(yytext);
					/* cout << "Returning STRING:"
					 *	<< yytext << "\n" ;  
					 */
						return STRING ;}
[ \t]+					; /* Skip white space */
\"[^\n\"]*\"				{yylval.Name = MakeString(yytext);
					return EXPLICIT_STRING ; }
Multiple				return MULTIPLE ;
Use 					return USE ;
Menu					return MENU ;
Dynamic					return DYNAMIC ;
Add[ \t]+To[ \t]+Menu			return ADD_TO_MENU ;
Conflict				return CONFLICT ;
Template				return TEMPLATE ;
History					return HISTORY ;
Select					return SELECT ;
Orphan					return ORPHAN ;
Wait					return WAIT ;
IncludeLocal				return INCLUDE_LOCAL;
IncludeRemote				return INCLUDE_REMOTE;
operator				return OPERATOR;
UserCopyright			return USER_COPYRIGHT ;
"<<"					return SHIFT_L;
">>"					return SHIFT_R;
"<="					return LEQ ;
">="					return GEQ ;
"=="					return EQU ;
"!="					return NEQ ;
"&&"					return AND ;
"||"					return OR ;
Mains					{yylval.Val = 0;
					/* printf("Found Mains\n"); */
					return MAINS;}
HelpDefaultFile				{return DEF_HELP_FILE ;}
HelpDefinition				{ EmbSt = 1 ; return HELP_DEF;}
DefinedAction				return DEFINED_ACTION ;
\=\ *HelpText[ \t]*			return yylval.Int = ITEM_HELP ;
\=\ *Local[ \t]*			return yylval.Int = LOCAL ; 
\=\ *Remote[ \t]*			return yylval.Int = REMOTE ; 
\=\ *LocalRemote[ \t]*			return yylval.Int = LOCAL_REMOTE ; 
\=\ *RemoteOptions[ \t]*		return yylval.Int = REMOTE_OPTIONS ; 
\=\ *Menu[ \t]*				return yylval.Int = NEW_MENU ;
\=\ *Reference[ \t]*			return yylval.Int = ITEM_REF ;
\=\ *DynamicMenu[ \t]*			return yylval.Int = DYNAMIC_MENU ;
\=\ *DefaultHelpFile[ \t]*			{ return yylval.Int = DEF_HELP_FILE ; }
\=\ *HelpFile[ \t]*			{ return yylval.Int = HELP_FILE ; }
[ \t]*HelpFile[ \t]*\:[ \t]*Default[ \t]*	{ return yylval.Int = DEFAULT ;}
[ \t]*HelpFile[ \t]*\:				{ BEGIN END_STRING ;
					return yylval.Int = HELP_FILE ; }
[a-zA-Z][a-zA-Z0-9_\.]*			{ yylval.Name = MakeName(yytext);
					  /* printf("Emb=%d,Name: %s\n",EmbSt,
					   *	yytext);
					   */
						if (EmbSt) {
							EmbSt=0;
							BEGIN EMBEDDED;
							BraceInit();
							LeftBrace();
						}
						return NAME ;
					}
0[0-7]*				{
					yylval.Int = OctConvert(yytext);
					FoundInt(yylval.Int);
					return INTEGER_VAL ;
				}
[1-9][0-9]*			{
					yylval.Int = IntConvert(yytext);
					FoundInt(yylval.Int);
					return INTEGER_VAL ;
				}
0[xX][0-9a-fA-F]*		{	
					yylval.Int = HexConvert(yytext+2);
					FoundInt(yylval.Int);
					return INTEGER_VAL ;
				}
[0-9]*\.[0-9]+			|
[0-9]+\.[0-9]*			|
[0-9]*\.?[0-9]+[Ee][+-]?[0-9]+	|
[0-9]+\.[0-9]*[Ee][+-]?[0-9]+	{
					yylval.Dbl = MakeDouble(yytext);
					return DOUBLE_VAL ;
				}
\;					|
\%					|
\!					|
\^					|
\&					|
\|					|
\$					|
\+					|
\-					|
\/					|
\*					|
\[					|
\]					|
\)					|
\(					|
\=					|
\,					|
\{					|
\}					{
				/* printf("returning:%c\n",yytext[0]); */
					return yylval.Int = yytext[0]; 
					}
\:					{ BEGIN END_STRING ;
					return ':'; }
.					IllegalChar(yytext[0]);
